/*
 * Decompiled with CFR 0.152.
 */
package mirrg.swing.helium.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mirrg.struct.hydrogen.Tuple;
import mirrg.swing.helium.logging.EnumTypeLog;
import mirrg.swing.helium.logging.FrameLog;

public class LoggerMirrg {
    public boolean bridgeStdout;
    private PrintStream outInfo;
    private PrintStream outFine;
    private PrintStream outWarning;
    private PrintStream outError;
    private PrintStream outUnexpected;
    private ArrayList<Tuple<EnumTypeLog, String>> messages = new ArrayList();
    private ArrayList<Predicate<Tuple<EnumTypeLog, String>>> listeners = new ArrayList();

    public void processException(Exception exception) {
        this.processException(exception, null, true, EnumTypeLog.ERROR);
    }

    public void processExceptionWarning(Exception exception) {
        this.processException(exception, null, false, EnumTypeLog.WARNING);
    }

    public void processExceptionUnexpected(Exception exception) {
        this.processException(exception, null, true, EnumTypeLog.UNEXPECTED);
    }

    public void processException(Exception exception, String string, boolean isFatal) {
        this.processException(exception, string, isFatal, isFatal ? EnumTypeLog.ERROR : EnumTypeLog.WARNING);
    }

    public void processException(Exception exception, String string, boolean showFrameLog, EnumTypeLog typeLog) {
        FrameLog frameLog = null;
        if (showFrameLog) {
            frameLog = new FrameLog(0);
            frameLog.setVisible(true);
        }
        if (string != null) {
            this.log(typeLog, string);
        }
        if (exception != null) {
            exception.printStackTrace(this.log(typeLog));
        }
        if (frameLog != null) {
            frameLog.disableAcceptMessage();
        }
    }

    public LoggerMirrg(boolean bridgeStdout) {
        this.bridgeStdout = bridgeStdout;
    }

    public LoggerMirrg() {
        this(false);
    }

    public void setBridgeStdout(boolean bridgeStdout) {
        this.bridgeStdout = bridgeStdout;
    }

    public boolean isBridgeStdout() {
        return this.bridgeStdout;
    }

    public void info(String string) {
        this.log(EnumTypeLog.INFO, string);
    }

    public void fine(String string) {
        this.log(EnumTypeLog.FINE, string);
    }

    public void warning(String string) {
        this.log(EnumTypeLog.WARNING, string);
    }

    public void error(String string) {
        this.log(EnumTypeLog.ERROR, string);
    }

    public void unexpected(String string) {
        this.log(EnumTypeLog.UNEXPECTED, string);
    }

    public void log(EnumTypeLog typeLog, String string) {
        if (this.bridgeStdout) {
            System.out.println("[" + typeLog.name() + "] " + string);
        }
        Tuple<EnumTypeLog, String> message = new Tuple<EnumTypeLog, String>(typeLog, string);
        this.messages.add(message);
        Iterator<Predicate<Tuple<EnumTypeLog, String>>> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Predicate<Tuple<EnumTypeLog, String>> next = iterator.next();
            if (!next.test(message)) continue;
            iterator.remove();
        }
    }

    public PrintStream info() {
        if (this.outInfo == null) {
            this.outInfo = this.createPrintStream(this::info);
        }
        return this.outInfo;
    }

    public PrintStream fine() {
        if (this.outFine == null) {
            this.outFine = this.createPrintStream(this::fine);
        }
        return this.outFine;
    }

    public PrintStream warning() {
        if (this.outWarning == null) {
            this.outWarning = this.createPrintStream(this::warning);
        }
        return this.outWarning;
    }

    public PrintStream error() {
        if (this.outError == null) {
            this.outError = this.createPrintStream(this::error);
        }
        return this.outError;
    }

    public PrintStream unexpected() {
        if (this.outUnexpected == null) {
            this.outUnexpected = this.createPrintStream(this::unexpected);
        }
        return this.outUnexpected;
    }

    public PrintStream log(EnumTypeLog typeLog) {
        switch (typeLog) {
            case INFO: {
                return this.info();
            }
            case FINE: {
                return this.fine();
            }
            case WARNING: {
                return this.warning();
            }
            case ERROR: {
                return this.error();
            }
            case UNEXPECTED: {
                return this.unexpected();
            }
        }
        return null;
    }

    private PrintStream createPrintStream(Consumer<String> consumer) {
        try {
            return new PrintStream((OutputStream)new OutputStreamLogger(consumer), true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    public Tuple<EnumTypeLog, String> getMessage(int index) {
        return this.messages.get(index);
    }

    public void registerListener(Predicate<Tuple<EnumTypeLog, String>> listener) {
        this.listeners.add(listener);
    }

    private static class OutputStreamLogger
    extends OutputStream {
        private static final Charset charset = Charset.forName("UTF-8");
        private Consumer<String> consumer;
        private ArrayList<Byte> buffer = new ArrayList();
        private boolean afterR = false;

        public OutputStreamLogger(Consumer<String> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void write(int b) throws IOException {
            if (b == 13) {
                this.flush2();
            } else if (b == 10) {
                if (!this.afterR) {
                    this.flush2();
                }
            } else {
                this.buffer.add((byte)b);
            }
            this.afterR = b == 13;
        }

        private void flush2() {
            byte[] bytes = new byte[this.buffer.size()];
            for (int i = 0; i < this.buffer.size(); ++i) {
                bytes[i] = this.buffer.get(i);
            }
            this.consumer.accept(new String(bytes, charset));
            this.buffer.clear();
        }
    }
}

