/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mirrg.applet.nitrogen.AppletNitrogen;
import mirrg.applet.nitrogen.FPSAdjuster;
import mirrg.applet.nitrogen.HAppletNitrogen;
import mirrg.applet.nitrogen.events.NitrogenEventApplet;
import mirrg.applet.nitrogen.events.NitrogenEventGameThread;
import mirrg.simulation.cart.almandine.gui.FrameMain;
import mirrg.simulation.cart.almandine.gui.ToolCursor;
import mirrg.simulation.cart.almandine.property.ManagerProperty;
import mirrg.simulation.cart.almandine.property.PropertyInt;

public class PanelAlmandine
extends AppletNitrogen {
    public PanelAlmandine(FrameMain frameMain) {
        HAppletNitrogen.ResponceApplyStandard responce = HAppletNitrogen.applyStandard(this);
        Supplier<ManagerProperty> mp = frameMain::getManagerProperty;
        final Supplier<ToolCursor> tc = frameMain::getToolCursor;
        IntSupplier tickPerFrame = mp.get().createPropertyInt(2, "panel.tickPerFrame", "1\u63cf\u753b\u30d5\u30ec\u30fc\u30e0\u3042\u305f\u308a\u306eTick\u6570[t/f]");
        DoubleSupplier secondPerTick = mp.get().createPropertyDouble(1.0, "panel.secondPerTick", "1Tick\u3042\u305f\u308a\u306e\u9032\u884c\u6642\u9593[s/t]");
        this.getEventManager().register(NitrogenEventGameThread.Tick.class, event -> {
            for (int i = 0; i < 2 * tickPerFrame.getAsInt(); ++i) {
                frameMain.getFactory().tick(secondPerTick.getAsDouble());
            }
            frameMain.getToolCursor().tick();
        });
        DoubleSupplier fps = mp.get().createPropertyDouble(30.0, "panel.fps", "\u63cf\u753bFPS[frame/s]");
        this.getEventManager().register(NitrogenEventGameThread.Render.class, event -> {
            responceApplyStandard.gameThread.objectiveFps = fps.getAsDouble();
            this.repaint();
        });
        this.getEventManager().register(NitrogenEventApplet.Paint.class, event -> {
            this.renderAll(frameMain, responce);
            responceApplyStandard.tripleBuffer.flip();
            event.graphics.drawImage(responceApplyStandard.tripleBuffer.getBufferSafety().getBuffer(), 0, 0, this);
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ((ToolCursor)tc.get()).mouseReleased(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ((ToolCursor)tc.get()).mousePressed(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((ToolCursor)tc.get()).mouseExited(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ((ToolCursor)tc.get()).mouseEntered(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ((ToolCursor)tc.get()).mouseClicked(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ((ToolCursor)tc.get()).mouseDragged(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                ((ToolCursor)tc.get()).mouseMoved(e);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ((ToolCursor)tc.get()).mouseWheelMoved(e);
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                ((ToolCursor)tc.get()).keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                ((ToolCursor)tc.get()).keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ((ToolCursor)tc.get()).keyReleased(e);
            }
        });
        this.setPreferredSize(new Dimension(600, 600));
    }

    private void renderAll(FrameMain frameMain, HAppletNitrogen.ResponceApplyStandard responce) {
        Graphics2D graphics = responce.tripleBuffer.getBufferDirty().getGraphics();
        graphics.setTransform(new AffineTransform());
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setBackground(Color.white);
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        frameMain.getFactory().render(graphics, frameMain);
        this.drawFPS(graphics, responce.fpsAdjuster);
        this.drawToolCursorText(graphics, frameMain.getToolCursor());
        frameMain.getToolCursor().render(graphics);
        graphics.setFont(new Font("SansSerif", 0, 14));
        graphics.setColor(Color.black);
        graphics.drawString(String.format("\u9032\u884c\u901f\u5ea6: x%s", ((PropertyInt)frameMain.getManagerProperty().getProperty("panel.tickPerFrame")).getValue()), 0, graphics.getFont().getSize() * 2);
    }

    private void drawToolCursorText(Graphics2D graphics, ToolCursor toolCursor) {
        graphics.setFont(new Font("SansSerif", 0, 14));
        graphics.setColor(Color.black);
        graphics.drawString(String.format("\u30ab\u30fc\u30bd\u30eb\u30c4\u30fc\u30eb: %s", toolCursor.toString()), 0, graphics.getFont().getSize());
    }

    private void drawFPS(Graphics2D graphics, FPSAdjuster fpsAdjuster) {
        graphics.setFont(new Font("SansSerif", 0, 14));
        graphics.setColor(Color.black);
        graphics.drawString(String.format("FPS: %.2f", fpsAdjuster.getFPS()), 0, this.getHeight());
        graphics.drawString(String.format("CPU: %.2f%%", fpsAdjuster.getLoadFactor() * 100.0), 0, this.getHeight() - graphics.getFont().getSize());
    }
}

