/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory.stackslab;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.FrameProperty;
import mirrg.simulation.cart.almandine.factory.stackslab.IEnvironmentStackSlab;
import mirrg.simulation.cart.almandine.factory.stackslab.IStackSlab;

public class StackSlabSimple
implements IStackSlab {
    public int amount;

    @Deprecated
    public StackSlabSimple() {
    }

    public StackSlabSimple(int amount) {
        this.amount = amount;
    }

    @Override
    public IStackSlab tryPop(int amount) {
        if (this.amount < amount) {
            this.amount = 0;
            return new StackSlabSimple(this.amount);
        }
        this.amount -= amount;
        return new StackSlabSimple(amount);
    }

    @Override
    public void push(IStackSlab stack) {
        this.amount += stack.getAmount();
        stack.clear();
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void clear() {
        this.amount = 0;
    }

    @Override
    public void addProperty(Factory factory, FrameProperty frameProperty) {
        frameProperty.addPropertyInt("Amount", () -> this.amount, amount -> {
            if (amount <= 0) {
                return false;
            }
            this.amount = amount;
            return true;
        });
    }

    @Override
    public void render(Graphics2D graphics, Rectangle bound, int capacity) {
        graphics.setColor(new Color(128));
        graphics.fill(bound);
        bound = new Rectangle(bound);
        bound.grow(-2, -2);
        graphics.setColor(new Color(0xC0C0C0));
        graphics.fill(bound);
        graphics.setColor(new Color(0x800000));
        int h = (int)(bound.getHeight() * (double)this.amount / (double)capacity);
        graphics.fillRect((int)bound.getMinX(), (int)bound.getMaxY() - h, (int)bound.getWidth(), h);
    }

    @Override
    public void tick(Factory factory, double deltaSecond, IEnvironmentStackSlab environment) {
    }
}

