/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory.parts;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.FrameProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.aistation.AIStation;
import mirrg.simulation.cart.almandine.factory.parts.Part;
import mirrg.simulation.cart.almandine.factory.primaries.Cart;
import mirrg.simulation.cart.almandine.factory.primaries.Rail;
import mirrg.swing.helium.GroupBuilder;

public class Station
extends Part {
    public int x;
    public int y;
    public int radius;
    public String script = "";
    @XStreamOmitField
    public AIStation ai = null;

    @Deprecated
    public Station() {
    }

    public Station(Factory factory, int x, int y, int radius) {
        super(factory);
        this.x = x;
        this.y = y;
        this.radius = radius;
    }

    @Override
    public boolean isHover(Factory factory, int x, int y) {
        int dist2 = (x - this.x) * (x - this.x) + (y - this.y) * (y - this.y);
        if (dist2 < (this.radius - 4) * (this.radius - 4)) {
            return false;
        }
        return dist2 < (this.radius + 4) * (this.radius + 4);
    }

    @Override
    public void render(Factory factory, Graphics2D graphics) {
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(3.0f));
        graphics.setColor(new Color(2449));
        graphics.draw(new Ellipse2D.Double(this.x - this.radius, this.y - this.radius, this.radius * 2, this.radius * 2));
        graphics.setStroke(stroke);
    }

    @Override
    public void renderHover(Factory factory, Graphics2D graphics) {
        int radius = this.radius + 4;
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(3.0f));
        graphics.setColor(new Color(8125570));
        graphics.draw(new Ellipse2D.Double(this.x - radius, this.y - radius, radius * 2, radius * 2));
        graphics.setStroke(stroke);
    }

    public void move(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    @Override
    public Point getPoint(Factory factory) throws IllegalEntityIdException {
        return new Point(this.x, this.y);
    }

    public int freeOrder(Factory factory) {
        OptionalInt max = this.getCarts(factory).mapToInt(cart -> ((Cart.PositionStation)cart.position).order).max();
        return max.isPresent() ? max.getAsInt() + 1 : 0;
    }

    @Override
    protected void addProperty(Factory factory, FrameProperty frameProperty) {
        super.addProperty(factory, frameProperty);
        frameProperty.addPropertyInt("X", () -> this.x, x -> {
            this.x = x;
            return true;
        });
        frameProperty.addPropertyInt("Y", () -> this.y, y -> {
            this.y = y;
            return true;
        });
        frameProperty.addPropertyInt("Radius", () -> this.radius, radius -> {
            this.radius = radius;
            return true;
        });
        frameProperty.addPropertyBoolean("Compile OK", () -> this.ai != null ? this.ai.compileOk : false, compileOk -> false);
        JTextPane textPane = new JTextPane();
        textPane.setText(this.script);
        JButton buttonCompile = new JButton("\u30b3\u30f3\u30d1\u30a4\u30eb");
        buttonCompile.addActionListener(e -> this.setScript(textPane.getText()));
        JScrollPane scrollPane = new JScrollPane(textPane);
        scrollPane.setPreferredSize(new Dimension(200, 400));
        frameProperty.addComponent(GroupBuilder.group(scrollPane));
        frameProperty.addComponent(GroupBuilder.group(buttonCompile));
    }

    public void setScript(String script) {
        this.script = script;
        this.ai = null;
    }

    @Override
    public void tick(Factory factory, double deltaSecond) throws IllegalEntityIdException {
        if (!this.getCartPrimary(factory).isPresent()) {
            return;
        }
        if (this.ai == null) {
            this.ai = AIStation.compile(this.script);
        }
        this.ai.run(factory, this);
    }

    public Stream<Rail> getRails(Factory factory) {
        return factory.rails.stream().filter(rail -> rail.idBegin == this.getId() || rail.idEnd == this.getId());
    }

    public void emitCart(Factory factory, Cart cart, Rail rail) {
        cart.position = rail.idBegin == this.getId() ? new Cart.PositionRail(rail.getId(), 0.0, true) : new Cart.PositionRail(rail.getId(), 1.0, false);
        this.updateOrder(factory);
    }

    protected void updateOrder(Factory factory) {
        int[] order = new int[]{0};
        this.getCarts(factory).forEach(cart -> {
            ((Cart.PositionStation)cart.position).order = order[0];
            nArray[0] = order[0] + 1;
        });
    }

    public Stream<Cart> getCarts(Factory factory) {
        return factory.carts.stream().filter(cart -> cart.position instanceof Cart.PositionStation).filter(cart -> ((Cart.PositionStation)cart.position).idStation == this.getId()).sorted((a, b) -> ((Cart.PositionStation)a.position).order - ((Cart.PositionStation)b.position).order);
    }

    public Optional<Cart> getCartPrimary(Factory factory) {
        return this.getCarts(factory).findFirst();
    }
}

