/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory.entities.primaries.furnitures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.stream.Stream;
import javax.swing.JButton;
import mirrg.simulation.cart.almandine.factory.Bound;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.FrameProperty;
import mirrg.simulation.cart.almandine.factory.entities.parts.SlotBase;
import mirrg.simulation.cart.almandine.factory.entities.parts.SlotModule;
import mirrg.simulation.cart.almandine.factory.entities.primaries.Furniture;
import mirrg.simulation.cart.almandine.factory.stackslab.IStackSlabTemperatureSingle;
import mirrg.swing.helium.GroupBuilder;

public class FurnitureThermometer
extends Furniture {
    public double sumTemperature;
    public int count;
    public SlotModule slotA;
    public SlotModule slotB;

    @Deprecated
    public FurnitureThermometer() {
    }

    public FurnitureThermometer(Factory factory, int x, int y) {
        super(factory, new Bound(x - 50, y - 20, 100, 40));
        this.slotA = new SlotModule(factory, new Bound(x - 48, y - 18, 16, 16), 1, 1.0E10);
        this.slotB = new SlotModule(factory, new Bound(x - 48, y + 2, 16, 16), 1, 1.0E10);
    }

    @Override
    public Stream<SlotBase> getSlots() {
        return Stream.of(this.slotA, this.slotB);
    }

    @Override
    protected void renderBody(Factory factory, Graphics2D graphics) {
        graphics.setColor(new Color(16767214));
        graphics.fill(this.bound.createShape());
        graphics.setColor(new Color(0));
        graphics.draw(this.bound.grow(1, 1, 0, 0).createShape());
        graphics.setFont(new Font("SansSerif", 0, 14));
        graphics.drawString(String.format("\u6e29\u5ea6: %.1f", this.count == 0 ? 0.0 : this.sumTemperature / (double)this.count), this.bound.getX() + 20, this.bound.getY() + this.bound.getHeight() / 2 + graphics.getFont().getSize() * 0);
        graphics.drawString("\u500b\u6570: " + this.count, this.bound.getX() + 20, this.bound.getY() + this.bound.getHeight() / 2 + graphics.getFont().getSize() * 1);
    }

    @Override
    public void tick(Factory factory, double deltaSecond) {
        super.tick(factory, deltaSecond);
        if (this.slotB.slotSlab.stack.getAmount() == 0 && this.slotA.slotSlab.stack.getAmount() >= 1) {
            int amount;
            double temperature = 0.0;
            if (this.slotA.slotSlab.stack instanceof IStackSlabTemperatureSingle) {
                temperature = ((IStackSlabTemperatureSingle)((Object)this.slotA.slotSlab.stack)).getTemperatureMean();
            }
            if ((amount = this.slotB.slotSlab.tryPush(this.slotA.slotSlab.stack)) >= 1) {
                this.count += amount;
                this.sumTemperature += temperature;
            }
        }
    }

    @Override
    protected void addProperty(Factory factory, FrameProperty frameProperty) {
        super.addProperty(factory, frameProperty);
        frameProperty.addPropertyDouble("Sum Temperature", () -> this.sumTemperature, sumTemperature -> {
            this.sumTemperature = sumTemperature;
            return true;
        });
        frameProperty.addPropertyDouble("Average Temperature", () -> this.count == 0 ? 0.0 : this.sumTemperature / (double)this.count, temperature -> {
            if (temperature <= 0.0) {
                return false;
            }
            this.sumTemperature = temperature * (double)this.count;
            return true;
        });
        frameProperty.addPropertyInt("Count", () -> this.count, count -> {
            if (count < 0) {
                return false;
            }
            this.count = count;
            return true;
        });
        JButton button = new JButton("\u30ea\u30bb\u30c3\u30c8");
        button.addActionListener(e -> {
            this.sumTemperature = 0.0;
            this.count = 0;
        });
        frameProperty.addComponent(GroupBuilder.group(button));
    }
}

