/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory.entities.parts;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.FrameProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.entities.parts.StationThrough;
import mirrg.simulation.cart.almandine.factory.entities.primaries.Cart;

public abstract class StationCoverBase
extends StationThrough {
    public double amount;
    public double duration;

    @Deprecated
    public StationCoverBase() {
    }

    public StationCoverBase(Factory factory, int x, int y, int radius, double duration) {
        super(factory, x, y, radius);
        this.duration = duration;
    }

    @Override
    protected void addProperty(Factory factory, FrameProperty frameProperty) {
        super.addProperty(factory, frameProperty);
        frameProperty.addPropertyDouble("Duration", () -> this.duration, duration -> {
            if (duration < 0.0) {
                return false;
            }
            this.duration = duration;
            return true;
        });
        frameProperty.addPropertyDouble("Amount", () -> this.amount, amount -> {
            if (amount < 0.0) {
                return false;
            }
            this.amount = amount;
            return true;
        });
    }

    @Override
    public void tick(Factory factory, double deltaSecond) throws IllegalEntityIdException {
        Cart cart = this.getCartPrimary(factory).orElse(null);
        if (cart == null) {
            return;
        }
        if (this.shouldAction(factory, deltaSecond, cart)) {
            super.tick(factory, deltaSecond);
        } else {
            this.amount += deltaSecond;
            if (this.amount > this.duration) {
                this.amount = 0.0;
                this.action(factory, deltaSecond, cart);
            }
        }
    }

    protected abstract void action(Factory var1, double var2, Cart var4) throws IllegalEntityIdException;

    protected abstract boolean shouldAction(Factory var1, double var2, Cart var4) throws IllegalEntityIdException;

    @Override
    public void render(Factory factory, Graphics2D graphics) {
        super.render(factory, graphics);
        int w = 40;
        graphics.setColor(new Color(0xC0C0C0));
        graphics.fill(new Rectangle2D.Double(this.x - w / 2, this.y - this.radius - 16, w, 10.0));
        graphics.setColor(new Color(this.getColor()));
        graphics.fill(new Rectangle2D.Double(this.x - w / 2, this.y - this.radius - 16, (double)w * (this.amount / this.duration), 10.0));
    }
}

