/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory.entities.parts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import mirrg.simulation.cart.almandine.factory.Bound;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.FrameProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.entities.Part;

public abstract class PartRectangle
extends Part {
    public Bound bound;

    @Deprecated
    public PartRectangle() {
    }

    public PartRectangle(Factory factory, Bound bound) {
        super(factory);
        this.bound = bound;
    }

    @Override
    public boolean isHover(Factory factory, int x, int y) {
        return this.bound.contains(x, y);
    }

    public void move(int dx, int dy) {
        this.bound = this.bound.translate(dx, dy);
    }

    @Override
    public void renderHover(Factory factory, Graphics2D graphics) {
        graphics.setColor(new Color(8125570));
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(3.0f));
        graphics.draw(this.bound.grow(5).createShape());
        graphics.setStroke(stroke);
    }

    @Override
    protected void addProperty(Factory factory, FrameProperty frameProperty) {
        super.addProperty(factory, frameProperty);
        frameProperty.addPropertyInt("X", () -> this.bound.getX(), x -> {
            this.bound = new Bound(x, this.bound.getY(), this.bound.getWidth(), this.bound.getHeight());
            return true;
        });
        frameProperty.addPropertyInt("Y", () -> this.bound.getY(), y -> {
            this.bound = new Bound(this.bound.getX(), y, this.bound.getWidth(), this.bound.getHeight());
            return true;
        });
        frameProperty.addPropertyInt("Width", () -> this.bound.getWidth(), width -> {
            this.bound = new Bound(this.bound.getX(), this.bound.getY(), width, this.bound.getHeight());
            return true;
        });
        frameProperty.addPropertyInt("Height", () -> this.bound.getHeight(), height -> {
            this.bound = new Bound(this.bound.getX(), this.bound.getY(), this.bound.getWidth(), height);
            return true;
        });
    }

    @Override
    public Point getPoint(Factory factory) throws IllegalEntityIdException {
        return this.bound.getCenter();
    }
}

