/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.entities.Entity;
import mirrg.simulation.cart.almandine.factory.entities.Primary;
import mirrg.simulation.cart.almandine.factory.entities.parts.SlotBase;
import mirrg.simulation.cart.almandine.factory.entities.parts.StationBase;
import mirrg.simulation.cart.almandine.factory.entities.primaries.Arm;
import mirrg.simulation.cart.almandine.factory.entities.primaries.Cart;
import mirrg.simulation.cart.almandine.factory.entities.primaries.Furniture;
import mirrg.simulation.cart.almandine.factory.entities.primaries.Rail;
import mirrg.simulation.cart.almandine.factory.stackslab.IStackSlab;
import mirrg.simulation.cart.almandine.factory.stackslab.StackSlabTemperatureSingle;
import mirrg.simulation.cart.almandine.gui.FrameMain;
import mirrg.stream.BuilderArrayList;
import mirrg.swing.helium.logging.HLog;

public class Factory {
    public int offsetX;
    public int offsetY;
    public double temperature;
    public ArrayList<Furniture> furnitures = new ArrayList();
    public ArrayList<Arm> arms = new ArrayList();
    public ArrayList<Rail> rails = new ArrayList();
    public ArrayList<Cart> carts = new ArrayList();
    @XStreamOmitField
    private ArrayList<Runnable> listenersInvokePostTick;

    @Deprecated
    public Factory() {
    }

    public Factory(double temperature) {
        this.temperature = temperature;
    }

    public void tick(double deltaSecond) {
        try {
            this.furnitures.forEach(entity -> this.tick((Entity)entity, deltaSecond, (ArrayList<? extends Entity>)this.furnitures));
            this.arms.forEach(entity -> this.tick((Entity)entity, deltaSecond, (ArrayList<? extends Entity>)this.arms));
            this.rails.forEach(entity -> this.tick((Entity)entity, deltaSecond, (ArrayList<? extends Entity>)this.rails));
            this.carts.forEach(entity -> this.tick((Entity)entity, deltaSecond, (ArrayList<? extends Entity>)this.carts));
        }
        catch (ConcurrentModificationException e) {
            HLog.processExceptionWarning(e);
        }
        this.getListenersInvokePostTick().forEach(Runnable::run);
        this.getListenersInvokePostTick().clear();
    }

    private void tick(Entity entity, double deltaSecond, ArrayList<? extends Entity> entities) {
        try {
            entity.tick(this, deltaSecond);
        }
        catch (IllegalEntityIdException e) {
            this.invokePostTick(() -> {
                entities.remove(entity);
                HLog.processException(e, "\u63a5\u7d9a\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u306e\u672b\u7aef\u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f\u3002\u63a5\u7d9a\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u3092\u524a\u9664\u3057\u307e\u3059: id=" + entity.getId(), false);
            });
        }
    }

    public Optional<Furniture> getParent(SlotBase slotBase) {
        return this.furnitures.stream().filter(furniture -> furniture.getSlots().anyMatch(slot2 -> slotBase == slot2)).findFirst();
    }

    public ArrayList<? extends Entity> getEntities(int x, int y) {
        ArrayList entities = new BuilderArrayList().add(this.furnitures.stream()).add(this.arms.stream()).add(this.rails.stream()).add(this.carts.stream()).add(this.furnitures.stream().flatMap(Furniture::getSlots)).add(this.furnitures.stream().flatMap(Furniture::getGauges)).add(this.furnitures.stream().flatMap(Furniture::getStations)).getList().stream().flatMap(stream -> stream).filter(primary -> {
            try {
                return primary.isHover(this, x, y);
            }
            catch (IllegalEntityIdException e) {
                return false;
            }
        }).collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(entities);
        return entities;
    }

    public ArrayList<? extends Primary> getPrimaries(int x, int y) {
        ArrayList primaries = Stream.of(this.furnitures, this.arms, this.rails, this.carts).flatMap(Collection::stream).filter(primary -> {
            try {
                return primary.isHover(this, x, y);
            }
            catch (IllegalEntityIdException e) {
                return false;
            }
        }).collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(primaries);
        return primaries;
    }

    public Stream<? extends Primary> getSelecteds() {
        return Stream.of(this.furnitures, this.arms, this.rails, this.carts).flatMap(Collection::stream).filter(primary -> primary.selected);
    }

    public ArrayList<SlotBase> getSlots(int x, int y) {
        ArrayList slots = this.furnitures.stream().flatMap(Furniture::getSlots).filter(slot -> slot.isHover(this, x, y)).collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(slots);
        return slots;
    }

    public ArrayList<StationBase> getStations(int x, int y) {
        ArrayList stations = this.furnitures.stream().flatMap(Furniture::getStations).filter(Station2 -> Station2.isHover(this, x, y)).collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(stations);
        return stations;
    }

    public void resetSelection() {
        this.furnitures.forEach(entity -> {
            entity.selected = false;
        });
        this.arms.forEach(entity -> {
            entity.selected = false;
        });
        this.rails.forEach(entity -> {
            entity.selected = false;
        });
        this.carts.forEach(entity -> {
            entity.selected = false;
        });
    }

    public void render(Graphics2D graphics, FrameMain frameMain) {
        frameMain.pushTanslate(graphics);
        try {
            this.furnitures.forEach(entity -> this.render((Entity)entity, graphics));
            this.arms.forEach(entity -> this.render((Entity)entity, graphics));
            this.rails.forEach(entity -> this.render((Entity)entity, graphics));
            this.carts.forEach(entity -> this.render((Entity)entity, graphics));
        }
        catch (ConcurrentModificationException e) {
            HLog.processExceptionWarning(e);
        }
        frameMain.popTanslate(graphics);
    }

    private void render(Entity entity, Graphics2D graphics) {
        try {
            entity.render(this, graphics);
        }
        catch (IllegalEntityIdException illegalEntityIdException) {
            // empty catch block
        }
    }

    public int freeId() {
        int id;
        while (this.getEntity(id = (int)(Math.random() * 1.0E8)).isPresent()) {
        }
        return id;
    }

    public Optional<? extends Entity> getEntity(int id) {
        return new BuilderArrayList().add(this.furnitures.stream()).add(this.arms.stream()).add(this.rails.stream()).add(this.carts.stream()).add(this.furnitures.stream().flatMap(Furniture::getSlots)).add(this.furnitures.stream().flatMap(Furniture::getGauges)).add(this.furnitures.stream().flatMap(Furniture::getStations)).getList().stream().flatMap(stream -> stream).filter(entity -> entity.getId() == id).findFirst();
    }

    private ArrayList<Runnable> getListenersInvokePostTick() {
        if (this.listenersInvokePostTick == null) {
            this.listenersInvokePostTick = new ArrayList();
        }
        return this.listenersInvokePostTick;
    }

    private void invokePostTick(Runnable runnable) {
        this.getListenersInvokePostTick().add(runnable);
    }

    public IStackSlab createStackSlab(int amount, String source) {
        return new StackSlabTemperatureSingle(amount, source);
    }

    public IStackSlab createStackSlab() {
        return new StackSlabTemperatureSingle(0, 0.0);
    }

    public void delete(Primary primary) {
        if (primary instanceof Furniture) {
            this.furnitures.remove(primary);
        } else if (primary instanceof Arm) {
            this.arms.remove(primary);
        } else if (primary instanceof Rail) {
            this.rails.remove(primary);
        } else if (primary instanceof Cart) {
            this.carts.remove(primary);
        } else {
            HLog.error("\u524a\u9664\u3067\u304d\u306a\u3044\u578b\u306e\u30d7\u30e9\u30a4\u30de\u30ea\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3067\u3059: " + primary + "(" + primary.getClass() + ")");
        }
    }
}

