/*
 * Decompiled with CFR 0.152.
 */
package mirrg.applet.nitrogen.samples;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import mirrg.applet.nitrogen.samples.Game1;

class Game2
extends Game1 {
    private static final double playerR = 0.01;
    private double[] player;
    private int score;
    private int scoreMax;

    public Game2(Component parent) {
        super(parent);
    }

    @Override
    public void init() {
        super.init();
        this.player = new double[]{0.5, 0.75};
    }

    @Override
    public void move() {
        super.move();
        for (int i = 0; i < this.points.size(); ++i) {
            double[] point = (double[])this.points.get(i);
            double dist2 = this.pow2(point[0] - this.player[0]) + this.pow2(point[1] - this.player[1]);
            if (!(dist2 < this.pow2(0.01))) continue;
            this.delete(this.player[0], this.player[1], this.pow2(0.5));
            if (this.score > this.scoreMax) {
                this.scoreMax = this.score;
            }
            this.score = 0;
            break;
        }
        ++this.score;
    }

    private void delete(double x, double y, double r2) {
        for (int i = 0; i < this.points.size(); ++i) {
            double[] point = (double[])this.points.get(i);
            double dist2 = this.pow2(point[0] - x) + this.pow2(point[1] - y);
            if (!(dist2 < r2)) continue;
            this.points.set(i, this.createPoint());
        }
    }

    @Override
    protected double[] createPoint() {
        double theta = Math.random() * 2.0 * Math.PI;
        double speed = Math.random() * 0.01 + 0.005;
        return new double[]{0.5, 0.25, speed * Math.cos(theta), speed * Math.sin(theta)};
    }

    private double pow2(double value) {
        return value * value;
    }

    public void setPlayerPosition(double x, double y) {
        this.player[0] = x;
        this.player[1] = y;
    }

    @Override
    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        int width = this.parent.getWidth();
        int height = this.parent.getHeight();
        graphics.setColor(Color.white);
        graphics.fillOval((int)((this.player[0] - 0.01) * (double)width), (int)((this.player[1] - 0.01) * (double)height), (int)(0.02 * (double)width), (int)(0.02 * (double)height));
        graphics.setFont(new Font("SansSerif", 0, 24));
        graphics.drawString("Score: " + this.score, 0, graphics.getFont().getSize());
        graphics.drawString("HiScore: " + this.scoreMax, 0, graphics.getFont().getSize() * 2);
    }
}

