﻿// TcpConnectionEventArgs.cs
//
// Author:
// tsntsumi <tsntsumi at tsntsumi.com>
//
// Copyright (c) 2015 tsntsumi
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.

/// @file
/// <summary>
/// TCP 接続イベント引数。
/// </summary>
/// @since 2015.8.12
using System;

namespace SocketNet
{
	/// <summary>
	/// Tcp接続に関連付けられたイベントのデータ。
	/// </summary>
	public class TcpConnectionEventArgs : EventArgs
	{
		/// <summary>
		/// 関連付けられた接続を取得します。
		/// </summary>
		public TcpConnection Connection { get; private set; }

		/// <summary>
		/// コンストラクタ。
		/// </summary>
		/// <param name="connection">関連付ける接続。</param>
		public TcpConnectionEventArgs(TcpConnection connection)
		{
			Connection = connection;
		}
	}
}

