/*
 * Decompiled with CFR 0.152.
 */
package miragecrops6;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mirrg.minecraft.item.multi.copper.IMetaitem;
import mirrg.minecraft.item.multi.copper.Metaitem;
import mirrg.minecraft.nbt.mir60.HNbt;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

class MetaitemPluginCrops
extends Metaitem {
    private Arguments arguments;
    private IIcon icon;

    public MetaitemPluginCrops(IMetaitem _super, int metaid, Arguments arguments) {
        super(_super, metaid);
        this.arguments = arguments;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.registerIcon(this.arguments.textureName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        return this.icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack itemStack, int pass) {
        return this.arguments.color;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List<String> strings, boolean isShift) {
        String key = "item." + this.arguments.name + ".information";
        if (StatCollector.canTranslate((String)key)) {
            strings.add(StatCollector.translateToLocal((String)key));
        }
    }

    @Override
    public String getUnlocalizedName(ItemStack itemStack) {
        return "item." + this.arguments.name;
    }

    protected static int getNBTInteger(ItemStack itemStack, String path, int _default) {
        return HNbt.getInteger(itemStack.getTagCompound(), path).orElse(_default);
    }

    protected static String getNBTString(ItemStack itemStack, String path, String _default) {
        return HNbt.getString(itemStack.getTagCompound(), path).orElse(_default);
    }

    public static class Arguments {
        private final String textureName;
        private final int color;
        private final String name;

        public Arguments(String textureName, int color, String name) {
            this.textureName = textureName;
            this.color = color;
            this.name = name;
        }
    }
}

