/*
 * Decompiled with CFR 0.152.
 */
package miragecrops6;

import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import miragecrops6.alis.AliCrop;
import miragecrops6.alis.AliItemStack;
import miragecrops6.crop.CropCardMirageCrops;
import miragecrops6.crop.HCropCardMirageCrops;
import mirrg.struct.hydrogen.Tuple;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

class InitializerCrops {
    InitializerCrops() {
    }

    public static void registerCropCards() {
        InitializerCrops.registerSpinaches();
        InitializerCrops.registerSarracenias();
        InitializerCrops.registerFlowers();
        InitializerCrops.registerIndustrials();
        InitializerCrops.registerCactuses();
        InitializerCrops.registerWeeds();
        InitializerCrops.registerOthers();
    }

    private static void registerSpinaches() {
        String a1 = "Spinach";
        String a2 = "SpinachGroup";
        CropCardMirageCrops c = InitializerCrops.r("spinach", 2, 4, InitializerCrops.s(0, 4, 0, 1, 0), InitializerCrops.a(a1, a2, "Food", "Edible"));
        HCropCardMirageCrops.setGain(c, iCropTile -> AliItemStack.cropSpinach.copy());
        c = InitializerCrops.r("spinachRed", 3, 4, InitializerCrops.s(2, 2, 0, 3, 0), InitializerCrops.a(a1, a2, "Red", "Undead", "Blood"));
        HCropCardMirageCrops.setGain(c, iCropTile -> AliItemStack.cropSpinachRed.copy());
        HCropCardMirageCrops.setTextureRespect(c, HCropCardMirageCrops.max(3), AliCrop.spinach);
        c = InitializerCrops.r("spinachBlue", 5, 4, InitializerCrops.s(4, 1, 0, 3, 0), InitializerCrops.a(a1, a2, "Blue", "Magic"));
        HCropCardMirageCrops.setGain(c, iCropTile -> AliItemStack.cropSpinachBlue.copy());
        HCropCardMirageCrops.setTextureRespect(c, HCropCardMirageCrops.max(3), AliCrop.spinach);
        c = InitializerCrops.r("spinachPoison", 8, 4, InitializerCrops.s(6, 0, 4, 1, 0), InitializerCrops.a(a1, a2, "Purple", "Poizon", "Toxic"));
        HCropCardMirageCrops.setGain(c, iCropTile -> AliItemStack.cropSpinachPoison.copy());
        HCropCardMirageCrops.setTextureRespect(c, HCropCardMirageCrops.max(3), AliCrop.spinach);
        c = InitializerCrops.r("spinachFire", 10, 4, InitializerCrops.s(2, 0, 6, 1, 0), InitializerCrops.a(a1, a2, "Orange", "Fire", "Flame"));
        HCropCardMirageCrops.setGain(c, iCropTile -> AliItemStack.cropSpinachFire.copy());
        HCropCardMirageCrops.setTextureRespect(c, HCropCardMirageCrops.max(3), AliCrop.spinach);
        c = InitializerCrops.r("spinachIce", 12, 4, InitializerCrops.s(1, 1, 1, 1, 0), InitializerCrops.a(a1, a2, "White", "Blue", "Ice"));
        HCropCardMirageCrops.setGain(c, iCropTile -> AliItemStack.cropSpinachIce.copy());
        HCropCardMirageCrops.setTextureRespect(c, HCropCardMirageCrops.max(3), AliCrop.spinach);
    }

    private static void registerSarracenias() {
        String a1 = "Sarracenia";
        String a2 = "SarraceniaGroup";
        CropCardMirageCrops c = InitializerCrops.r("sarracenia", 3, 5, InitializerCrops.s(0, 0, 4, 1, 2), InitializerCrops.a(a1, a2, "Green"));
        HCropCardMirageCrops.setGain(c, iCropTile -> AliItemStack.cropSarracenia.copy());
        HCropCardMirageCrops.setGain(c, HCropCardMirageCrops.array(4), iCropTile -> AliItemStack.cropSarraceniaImmature.copy());
        HCropCardMirageCrops.setEmittedLight(c, HCropCardMirageCrops.array(5), 0);
        HCropCardMirageCrops.addCropComponentSarracenia(c, HCropCardMirageCrops.array(4, 5), 1, 2.0f, entityLivingBase -> entityLivingBase.getCreatureAttribute() == EnumCreatureAttribute.ARTHROPOD);
        c = InitializerCrops.r("sarraceniaLightning", 6, 5, InitializerCrops.s(4, 0, 5, 2, 1), InitializerCrops.a(a1, a2, "Purple", "Lightning"));
        HCropCardMirageCrops.setGain(c, iCropTile -> AliItemStack.cropSarraceniaLightning.copy());
        HCropCardMirageCrops.setGain(c, HCropCardMirageCrops.array(4), iCropTile -> AliItemStack.cropSarraceniaImmature.copy());
        HCropCardMirageCrops.setTextureRespect(c, HCropCardMirageCrops.max(4), AliCrop.sarracenia);
        HCropCardMirageCrops.setEmittedLight(c, HCropCardMirageCrops.array(5), 12);
        HCropCardMirageCrops.addCropComponentSarracenia(c, HCropCardMirageCrops.array(4, 5), 1, 5.0f, entityLivingBase -> entityLivingBase.getCreatureAttribute() == EnumCreatureAttribute.ARTHROPOD);
        c = InitializerCrops.r("sarraceniaNagae", 10, 5, InitializerCrops.s(0, 4, 7, 5, 0), InitializerCrops.a(a1, a2, "Fish", "Food", "Edible", "Lightning", "Cloth"));
        HCropCardMirageCrops.setGain(c, iCropTile -> {
            if (iCropTile.getWorld().rand.nextInt(5) == 0) {
                return new ItemStack(Items.fish);
            }
            return AliItemStack.cropSarraceniaNagae.copy();
        });
        HCropCardMirageCrops.setGain(c, HCropCardMirageCrops.array(4), iCropTile -> AliItemStack.cropSarraceniaImmature.copy());
        HCropCardMirageCrops.setTextureRespect(c, HCropCardMirageCrops.max(4), AliCrop.sarracenia);
        HCropCardMirageCrops.setEmittedLight(c, HCropCardMirageCrops.array(5), 8);
        HCropCardMirageCrops.setTickerNagae(c, HCropCardMirageCrops.array(4));
        c = InitializerCrops.r("sarraceniaManeater", 8, 5, InitializerCrops.s(0, 0, 6, 3, 1), InitializerCrops.a(a1, a2, "Pink", "Red", "Blood", "Undead"));
        HCropCardMirageCrops.setGain(c, iCropTile -> AliItemStack.cropSarraceniaManeater.copy());
        HCropCardMirageCrops.setGain(c, HCropCardMirageCrops.array(4), iCropTile -> AliItemStack.cropSarraceniaImmature.copy());
        HCropCardMirageCrops.setTextureRespect(c, HCropCardMirageCrops.max(4), AliCrop.sarracenia);
        HCropCardMirageCrops.setEmittedLight(c, HCropCardMirageCrops.array(5), 2);
        HCropCardMirageCrops.addCropComponentSarracenia(c, HCropCardMirageCrops.array(4, 5), 1, 3.0f, entityLivingBase -> entityLivingBase instanceof EntityZombie);
        HCropCardMirageCrops.addCropComponentSarracenia(c, HCropCardMirageCrops.array(4, 5), 1, 3.0f, entityLivingBase -> entityLivingBase instanceof EntityVillager);
        HCropCardMirageCrops.addCropComponentSarracenia(c, HCropCardMirageCrops.array(4, 5), 1, 1.0f, entityLivingBase -> entityLivingBase instanceof EntityPlayerMP);
        c = InitializerCrops.r("sarraceniaDevil", 14, 5, InitializerCrops.s(0, 0, 8, 3, 0), InitializerCrops.a(a1, a2, "Red", "Redstone", "Undead", "Blood"));
        HCropCardMirageCrops.setGain(c, iCropTile -> AliItemStack.cropSarraceniaDevil.copy());
        HCropCardMirageCrops.setGain(c, HCropCardMirageCrops.array(4), iCropTile -> AliItemStack.cropSarraceniaImmature.copy());
        HCropCardMirageCrops.setTextureRespect(c, HCropCardMirageCrops.max(4), AliCrop.sarracenia);
        HCropCardMirageCrops.setEmittedLight(c, HCropCardMirageCrops.array(5), 4);
        HCropCardMirageCrops.addCropComponentSarracenia(c, HCropCardMirageCrops.array(4, 5), 1, 3.0f, entityLivingBase -> entityLivingBase.getCreatureAttribute() == EnumCreatureAttribute.UNDEAD);
    }

    private static void registerFlowers() {
        String a1 = "Chrysanthum";
        String a2 = "ChrysanthumGroup";
        String a3 = "Flower";
        String a4 = "White";
        CropCardMirageCrops c = InitializerCrops.r("roseQuartz", 6, 4, InitializerCrops.s(1, 0, 3, 4, 0), InitializerCrops.a("Flower", "Purple", "Rose", "Quartz", "Silica", "Crystal"));
        HCropCardMirageCrops.setGain(c, iCropTile -> (ItemStack)((Supplier)((Weighter)((Weighter)((Weighter)((Weighter)InitializerCrops.w()).entry(95.0, () -> AliItemStack.cropRoseQuartz.copy())).entry(1.0, () -> AliItemStack.gemCertusQuartz.copy())).entry(4.0, () -> new ItemStack(Items.quartz))).get(iCropTile.getWorld().rand)).get());
        c = InitializerCrops.r("chrysanthum", 2, 4, InitializerCrops.s(1, 1, 0, 5, 1), InitializerCrops.a(a1, a2, a3, a4));
        HCropCardMirageCrops.setGain(c, iCropTile -> new ItemStack((Block)Blocks.red_flower, 1, 8));
        c = InitializerCrops.r("chrysanthumErodium", 8, 4, InitializerCrops.s(3, 1, 0, 5, 1), InitializerCrops.a(a1, a2, a3, a4));
        HCropCardMirageCrops.setGain(c, iCropTile -> (ItemStack)((Supplier)((Weighter)((Weighter)((Weighter)InitializerCrops.w()).entry(50.0, () -> new ItemStack((Block)Blocks.red_flower, 1, 8))).entry(50.0, () -> null)).get(iCropTile.getWorld().rand)).get());
        HCropCardMirageCrops.setTextureRespect(c, HCropCardMirageCrops.max(4), AliCrop.chrysanthum);
        c = InitializerCrops.r("chrysanthumIridium", 17, 4, InitializerCrops.s(6, 0, 0, 5, 0), InitializerCrops.a(a1, a2, a3, a4, "Iridium", "Metal"));
        HCropCardMirageCrops.setGain(c, iCropTile -> (ItemStack)((Supplier)((Weighter)((Weighter)((Weighter)InitializerCrops.w()).entry(99.0, () -> new ItemStack((Block)Blocks.red_flower, 1, 8))).entry(1.0, () -> null)).get(iCropTile.getWorld().rand)).get());
    }

    private static void registerIndustrials() {
        String a1 = "Industrial";
        CropCardMirageCrops c = InitializerCrops.r("reedCircuit", 14, 4, InitializerCrops.s(1001, 0, 0, 0, 0), InitializerCrops.a(a1, "Metal", "Circuit", "Reed"));
        HCropCardMirageCrops.setGain(c, iCropTile -> AliItemStack.cropReedCircuit.copy());
        HCropCardMirageCrops.setGain(c, HCropCardMirageCrops.range(2, 3), iCropTile -> InitializerCrops.copy(AliItemStack.cropReedWire, iCropTile.getSize() - 1));
        HCropCardMirageCrops.setSizeAfterHarvest(c, HCropCardMirageCrops.array(4), iCropTile -> InitializerCrops.rBw(iCropTile, 1, 3));
        c = InitializerCrops.r("berriesMatter", 9, 4, InitializerCrops.s(1002, 0, 0, 6, 0), InitializerCrops.a(a1, "Matter", "Purple"));
        HCropCardMirageCrops.setGain(c, iCropTile -> (ItemStack)((Supplier)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)InitializerCrops.w()).entry(100000.0, () -> new ItemStack(Items.stick))).entry(10000.0, () -> new ItemStack(Blocks.stone))).entry(10000.0, () -> new ItemStack(Blocks.dirt))).entry(10000.0, () -> new ItemStack((Block)Blocks.sand))).entry(10000.0, () -> new ItemStack(Blocks.gravel))).entry(5000.0, () -> new ItemStack(Blocks.netherrack))).entry(2000.0, () -> new ItemStack(Blocks.end_stone))).entry(500.0, () -> new ItemStack(Items.iron_ingot))).entry(50.0, () -> new ItemStack(Items.gold_ingot))).entry(10.0, () -> new ItemStack(Items.diamond))).entry(500.0, () -> new ItemStack(Items.quartz))).entry(1000.0, () -> new ItemStack(Items.redstone))).entry(300.0, () -> new ItemStack(Items.glowstone_dust))).entry(200.0, () -> new ItemStack(Items.dye, 1, 4))).get(iCropTile.getWorld().rand)).get());
        c = InitializerCrops.r("wartGlass", 8, 3, InitializerCrops.s(1000, 0, 0, 0, 0), InitializerCrops.a(a1, "Glass"));
        HCropCardMirageCrops.setGain(c, iCropTile -> (ItemStack)((Supplier)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)InitializerCrops.w()).entry(100.0, () -> AliItemStack.cropWartGlass.copy())).entry(10.0, () -> AliItemStack.dustGlass.copy())).entry(5.0, () -> new ItemStack(Items.glass_bottle))).entry(1.0, () -> new ItemStack(Blocks.glass))).get(iCropTile.getWorld().rand)).get());
        c = InitializerCrops.r("wartMatter", 15, 7, InitializerCrops.s(1003, 0, 0, 6, 0), InitializerCrops.a(a1, "Matter", "Purple"));
        HCropCardMirageCrops.setGain(c, iCropTile -> (ItemStack)((Supplier)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)InitializerCrops.w()).entry(10000.0, () -> new ItemStack(Items.stick))).entry(10000.0, () -> new ItemStack(Blocks.stone))).entry(10000.0, () -> new ItemStack(Blocks.dirt))).entry(10000.0, () -> new ItemStack((Block)Blocks.sand))).entry(10000.0, () -> new ItemStack(Blocks.gravel))).entry(5000.0, () -> new ItemStack(Blocks.netherrack))).entry(2000.0, () -> new ItemStack(Blocks.end_stone))).entry(500.0, () -> new ItemStack(Items.iron_ingot))).entry(50.0, () -> new ItemStack(Items.gold_ingot))).entry(10.0, () -> new ItemStack(Items.diamond))).entry(500.0, () -> new ItemStack(Items.quartz))).entry(1000.0, () -> new ItemStack(Items.redstone))).entry(300.0, () -> new ItemStack(Items.glowstone_dust))).entry(200.0, () -> new ItemStack(Items.dye, 1, 4))).get(iCropTile.getWorld().rand)).get());
    }

    private static void registerCactuses() {
        String a1 = "Cactus";
        String a2 = "CactusGroup";
        CropCardMirageCrops c = InitializerCrops.r("cactus", 2, 4, InitializerCrops.s(1, 0, 4, 4, 1), InitializerCrops.a(a1, a2, "Green"));
        HCropCardMirageCrops.setGain(c, iCropTile -> AliItemStack.cropCactus.copy());
        HCropCardMirageCrops.addCropComponentCactus(c, HCropCardMirageCrops.array(4), 1, 1.0f);
        c = InitializerCrops.r("cactusObsidian", 7, 4, InitializerCrops.s(3, 0, 6, 3, 0), InitializerCrops.a(a1, a2, "Purple", "Black", "Obsidian", "Glass", "Fire"));
        HCropCardMirageCrops.setGain(c, iCropTile -> AliItemStack.cropCactusObsidian.copy());
        HCropCardMirageCrops.setTextureRespect(c, HCropCardMirageCrops.max(3), AliCrop.cactus);
        HCropCardMirageCrops.addCropComponentCactus(c, HCropCardMirageCrops.array(4), 1, 2.0f);
        c = InitializerCrops.r("cactusSnow", 6, 5, InitializerCrops.s(2, 0, 5, 2, 0), InitializerCrops.a(a1, a2, "White", "Ice", "Snow"));
        HCropCardMirageCrops.setGain(c, iCropTile -> (ItemStack)((Supplier)((Weighter)((Weighter)((Weighter)((Weighter)((Weighter)InitializerCrops.w()).entry(100.0, () -> new ItemStack(Items.snowball))).entry(10.0, () -> new ItemStack(Blocks.ice))).entry(5.0, () -> new ItemStack(Blocks.snow))).entry(1.0, () -> new ItemStack(Blocks.snow_layer))).get(iCropTile.getWorld().rand)).get());
        HCropCardMirageCrops.setGain(c, HCropCardMirageCrops.array(4), iCropTile -> AliItemStack.cropCactusSnow.copy());
        HCropCardMirageCrops.setSizeAfterHarvest(c, HCropCardMirageCrops.array(5), 4);
        HCropCardMirageCrops.setTextureRespect(c, HCropCardMirageCrops.max(3), AliCrop.cactus);
        HCropCardMirageCrops.addCropComponentCactus(c, HCropCardMirageCrops.array(4, 5), 7, 1.0f);
        HCropCardMirageCrops.addCropComponentSlow(c, HCropCardMirageCrops.array(5), 1);
    }

    private static void registerWeeds() {
        String a5 = "Green";
        String a1 = "Fern";
        String a2 = "FernGroup";
        CropCardMirageCrops c = InitializerCrops.r("fern", 1, 4, InitializerCrops.s(0, 0, 0, 1, 4), InitializerCrops.a(a1, a2, a5, "Weed"));
        HCropCardMirageCrops.setGain(c, iCropTile -> new ItemStack((Block)Blocks.tallgrass, 1, 2));
        c = InitializerCrops.r("fernHoney", 5, 5, InitializerCrops.s(0, 3, 0, 1, 2), InitializerCrops.a(a1, a2, a5, "Bee", "Honey", "Edible"));
        HCropCardMirageCrops.setGain(c, iCropTile -> null);
        HCropCardMirageCrops.setTextureRespect(c, HCropCardMirageCrops.max(4), AliCrop.fern);
        String a3 = "Vine";
        String a4 = "VineGroup";
        c = InitializerCrops.r("vine", 1, 4, InitializerCrops.s(0, 0, 1, 0, 4), InitializerCrops.a(a3, a4, a5, "Weed"));
        HCropCardMirageCrops.setGain(c, iCropTile -> new ItemStack(Blocks.vine));
        c = InitializerCrops.r("vineApatite", 6, 4, InitializerCrops.s(3, 0, 0, 2, 1), InitializerCrops.a(a3, a4, a5, "Blue", "Apatite", "Crystal", "Phosphorus"));
        HCropCardMirageCrops.setGain(c, iCropTile -> (ItemStack)((Supplier)((Weighter)((Weighter)InitializerCrops.w()).entry(1.0, () -> AliItemStack.gemApatite.copy())).get(iCropTile.getWorld().rand)).get());
        HCropCardMirageCrops.setSizeAfterHarvest(c, HCropCardMirageCrops.array(4), 3);
        HCropCardMirageCrops.setGrowthLightRegion(c, HCropCardMirageCrops.array(3), 15, 15);
        HCropCardMirageCrops.setGrowthDurationRatio(c, HCropCardMirageCrops.array(3), 5.0);
        HCropCardMirageCrops.setTextureRespect(c, HCropCardMirageCrops.max(3), AliCrop.vine);
        c = InitializerCrops.r("vineFluoroberries", 9, 4, InitializerCrops.s(6, 0, 4, 3, 1), InitializerCrops.a(a3, a4, "Yellow", "Fluorine", "Berry"));
        HCropCardMirageCrops.setGain(c, iCropTile -> InitializerCrops.copy(AliItemStack.cropVineFluoroberries, InitializerCrops.rBw(iCropTile, 1, 10)));
    }

    private static void registerOthers() {
        CropCardMirageCrops c = InitializerCrops.r("wheatFire", 5, 9, InitializerCrops.s(4, 1, 3, 1, 0), InitializerCrops.a("Wheat", "Orange", "Yellow", "Fire", "Flame"));
        HCropCardMirageCrops.setGain(c, HCropCardMirageCrops.array(9), iCropTile -> (ItemStack)((Supplier)((Weighter)((Weighter)InitializerCrops.w()).entry(1.0, () -> new ItemStack(Items.dye, 1, 15))).get(iCropTile.getWorld().rand)).get());
        HCropCardMirageCrops.setGain(c, HCropCardMirageCrops.array(8), iCropTile -> (ItemStack)((Supplier)((Weighter)((Weighter)InitializerCrops.w()).entry(1.0, () -> new ItemStack(Blocks.torch))).get(iCropTile.getWorld().rand)).get());
        HCropCardMirageCrops.setGain(c, HCropCardMirageCrops.array(7), iCropTile -> (ItemStack)((Supplier)((Weighter)((Weighter)InitializerCrops.w()).entry(1.0, () -> (ItemStack)((Supplier)((Weighter)((Weighter)((Weighter)InitializerCrops.w()).entry(1.0, () -> new ItemStack(Items.fire_charge))).entry(1.0, () -> AliItemStack.gemSulfur.copy())).get(iCropTile.getWorld().rand)).get())).get(iCropTile.getWorld().rand)).get());
        HCropCardMirageCrops.setEmittedLight(c, HCropCardMirageCrops.array(8), 14);
        HCropCardMirageCrops.setGrowthDurationRatio(c, HCropCardMirageCrops.array(8), 0.15);
        HCropCardMirageCrops.addCropComponentFire(c, HCropCardMirageCrops.array(8), 7, 8);
        c = InitializerCrops.r("rice", 3, 7, InitializerCrops.s(0, 5, 0, 0, 0), InitializerCrops.a("Wheat", "Food", "Yellow", "Edible", "Rice"));
        HCropCardMirageCrops.setGain(c, iCropTile -> null);
        c = InitializerCrops.r("coffeeJava", 6, 4, InitializerCrops.s(1, 4, 0, 1, 0), InitializerCrops.a("Coffee", "Leaves", "Java"));
        HCropCardMirageCrops.setGain(c, iCropTile -> null);
        c = InitializerCrops.r("mandrake", 5, 4, InitializerCrops.s(5, 3, 5, 2, 3), InitializerCrops.a("Mandrake"));
        HCropCardMirageCrops.setGain(c, iCropTile -> AliItemStack.cropMandrake.copy());
        c = InitializerCrops.r("dreamflower", 7, 4, InitializerCrops.s(0, 0, 0, 3, 0), InitializerCrops.a("Dream", "Flower", "Mirage"));
        HCropCardMirageCrops.setGain(c, iCropTile -> null);
        HCropCardMirageCrops.setEmittedLight(c, HCropCardMirageCrops.array(4), 8);
    }

    private static Weighter<Supplier<ItemStack>> w() {
        return new Weighter<Supplier<ItemStack>>();
    }

    static ItemStack copy(ItemStack itemStack, int stackSize) {
        ItemStack tmp = itemStack.copy();
        tmp.stackSize = stackSize;
        return tmp;
    }

    private static String[] a(String ... arguments) {
        return arguments;
    }

    private static int[] s(int statChemical, int statFood, int statDefensive, int statColor, int statWeed) {
        return new int[]{statChemical, statFood, statDefensive, statColor, statWeed};
    }

    private static <T extends CropCard> T registerCrop(T crop) {
        Crops crops = Crops.instance;
        if (crops != null) {
            crops.registerCrop(crop);
        }
        try {
            AliCrop.class.getField(crop.name()).set(null, crop);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
        return crop;
    }

    private static CropCardMirageCrops r(String name, int tier, int maxSize, int[] stats, String[] atributes) {
        return InitializerCrops.registerCrop(new CropCardMirageCrops(new CropCardMirageCrops.CropCardMirageCropsParameter(name, tier, maxSize, stats, atributes)));
    }

    private static int rBw(ICropTile cropTile, int min, int max) {
        return cropTile.getWorld().rand.nextInt(max - min + 1) + min;
    }

    private static class Weighter<T> {
        private double sumWeight;
        private ArrayList<Tuple<Double, T>> entries = new ArrayList();

        private Weighter() {
        }

        private Weighter<T> entry(double weight, T t) {
            this.sumWeight += weight;
            this.entries.add(new Tuple<Double, T>(weight, t));
            return this;
        }

        private T get(Random random) {
            double i = this.sumWeight * random.nextDouble();
            for (Tuple<Double, T> entry : this.entries) {
                if (i < entry.getKey()) {
                    return entry.getValue();
                }
                i -= entry.getKey().doubleValue();
            }
            return this.entries.get(this.entries.size() - 1).getY();
        }
    }
}

