/*
 * Decompiled with CFR 0.152.
 */
package saccubus.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Mson {
    public MsonType type = MsonType.MSON_NULL;
    private Object obj = null;
    private static final boolean DEBUG = false;

    public Mson() {
    }

    public Mson(String str) {
        this();
        if (str != null) {
            this.type = MsonType.MSON_STRING;
            this.obj = str;
        }
    }

    public Mson(Number num) {
        this();
        if (num != null) {
            this.type = MsonType.MSON_NUMBER;
            this.obj = num;
        }
    }

    public Mson(int i) {
        this((Number)i);
    }

    public Mson(boolean bool) {
        this();
        this.type = MsonType.MSON_BOOLEAN;
        this.obj = bool;
    }

    public static Mson newInstance(String str) {
        return new Mson(str);
    }

    public String toString() {
        switch (this.type) {
            case MSON_NULL: {
                return "[]";
            }
            case MSON_STRING: {
                if (!(this.obj instanceof String)) {
                    return "*ERROR:shutSB MSON_STRING*" + this.obj.toString() + "*";
                }
                return "\"" + (String)this.obj + "\"";
            }
            case MSON_LIST: {
                if (!(this.obj instanceof MsonList)) {
                    return "*ERROR:shutSB MSON_LIST*" + this.obj.toString() + "*";
                }
                return ((MsonList)this.obj).toString();
            }
            case MSON_ASSOC: {
                if (!(this.obj instanceof MsonAssoc)) {
                    return "*ERROR:shutSB MSON_ASSOC*" + this.obj.toString() + "*";
                }
                return ((MsonAssoc)this.obj).toString();
            }
            case MSON_NUMBER: {
                if (!(this.obj instanceof Number)) {
                    return "*ERROR:shutSB MSON_NUMBER*" + this.obj.toString() + "*";
                }
                return ((Number)this.obj).toString();
            }
            case MSON_BOOLEAN: {
                if (!(this.obj instanceof Boolean)) {
                    return "*ERROR:shutSB MSON_BOOLEAN*" + this.obj.toString() + "*";
                }
                return ((Boolean)this.obj).toString();
            }
        }
        return "*ERROR:shutSB MSON_ASSOC*" + this.obj.toString() + "*";
    }

    public static Mson newList() {
        Mson mson = new Mson();
        mson.type = MsonType.MSON_LIST;
        Mson mson2 = mson;
        mson2.getClass();
        mson.obj = mson2.new MsonList();
        return mson;
    }

    public Mson add(Mson element) throws Exception {
        if (element == null) {
            element = new Mson();
        }
        switch (this.type) {
            case MSON_NULL: {
                this.type = MsonType.MSON_LIST;
                this.obj = new MsonList();
            }
            case MSON_LIST: {
                MsonList list = (MsonList)this.obj;
                list.add(element);
                this.obj = list;
                return this;
            }
            case MSON_STRING: {
                throw new Exception();
            }
            case MSON_ASSOC: {
                throw new Exception();
            }
            case MSON_NUMBER: {
                throw new Exception();
            }
        }
        return null;
    }

    public Mson append(Mson mList) throws Exception {
        Mson mson = this;
        if (mList == null || mList.type == MsonType.MSON_NULL) {
            return mson;
        }
        if (mList.type != MsonType.MSON_LIST) {
            return null;
        }
        MsonList list = (MsonList)mList.obj;
        for (Mson element : list) {
            mson.add(element);
        }
        return mson;
    }

    public Mson add(String str) throws Exception {
        return this.add(new Mson(str));
    }

    public static Mson newAssoc() {
        Mson mson = new Mson();
        mson.type = MsonType.MSON_ASSOC;
        Mson mson2 = mson;
        mson2.getClass();
        MsonAssoc hash = mson2.new MsonAssoc();
        mson.obj = hash;
        return mson;
    }

    public static MsonType getType(Mson mson) {
        return mson.type;
    }

    public Mson put(String key, Mson val) throws Exception {
        switch (this.type) {
            case MSON_NULL: {
                this.type = MsonType.MSON_ASSOC;
                this.obj = new MsonAssoc();
            }
            case MSON_ASSOC: {
                MsonAssoc hash = (MsonAssoc)this.obj;
                hash.put(key, val);
                this.obj = hash;
                return this;
            }
            case MSON_LIST: {
                throw new Exception();
            }
            case MSON_STRING: {
                throw new Exception();
            }
            case MSON_NUMBER: {
                throw new Exception();
            }
        }
        return null;
    }

    public static Mson parse(String text) throws Exception {
        return Mson.parse(text, 0, new StringBuffer());
    }

    public static Mson parse(String input, int last, StringBuffer ret) throws Exception {
        Mson mson1;
        Mson mson;
        char c = input.charAt(last);
        if (c == '[') {
            ++last;
            mson = Mson.newList();
            while (last < input.length()) {
                c = input.charAt(last);
                if (c == ']') {
                    ret.replace(0, ret.length(), input.substring(++last));
                    return mson;
                }
                mson1 = Mson.parse(input, last, ret);
                c = ret.charAt(0);
                if (c == ',') {
                    input = ret.substring(0);
                    last = 1;
                    mson = mson.add(mson1);
                    continue;
                }
                if (c != ']') continue;
                ret.delete(0, 1);
                mson = mson.add(mson1);
                return mson;
            }
        }
        if (c == ']') {
            ret.replace(0, ret.length(), input.substring(++last));
            mson = new Mson();
            return mson;
        }
        if (c == '{') {
            block15: {
                String key;
                ++last;
                mson = Mson.newAssoc();
                while (true) {
                    key = Mson.parseString(input, ++last, ret);
                    input = ret.substring(0);
                    last = 0;
                    if ((c = input.charAt(last++)) != ':') break block15;
                    mson1 = Mson.parse(input, last, ret);
                    input = ret.substring(0);
                    last = 0;
                    if ((c = input.charAt(last++)) != ',') break;
                    mson = mson.put(key, mson1);
                }
                if (c == '}') {
                    ret.delete(0, 1);
                    mson = mson.put(key, mson1);
                    return mson;
                }
            }
            throw new Exception();
        }
        if (c == '}') {
            ret.replace(0, ret.length(), input.substring(++last));
            mson = new Mson();
            return mson;
        }
        if (c == '\"') {
            String key = Mson.parseString(input, ++last, ret);
            mson = new Mson(key);
            return mson;
        }
        if (Character.isDigit(c)) {
            Number num = Mson.parseNum(input, last, ret);
            mson = new Mson(num);
            return mson;
        }
        if (input.substring(last, last + 4).toLowerCase().equals("true")) {
            mson = new Mson(true);
            ret.replace(0, ret.length(), input.substring(last + 4));
            return mson;
        }
        if (input.substring(last, last + 5).toLowerCase().equals("false")) {
            mson = new Mson(false);
            ret.replace(0, ret.length(), input.substring(last + 5));
            return mson;
        }
        if (input.substring(last, last + 4).toLowerCase().equals("null")) {
            mson = new Mson();
            ret.replace(0, ret.length(), input.substring(last + 4));
            return mson;
        }
        Matcher m = Pattern.compile("[\\],}]").matcher(input.substring(last));
        if (m.find()) {
            ret.replace(0, ret.length(), input.substring(m.end()));
            return null;
        }
        ret.replace(0, ret.length(), input.substring(++last));
        return null;
    }

    private static String parseString(String input, int last, StringBuffer ret) {
        StringBuffer sb = new StringBuffer();
        while (last < input.length()) {
            char c;
            if ((c = input.charAt(last++)) == '\"') {
                ret.replace(0, ret.length(), input.substring(last));
                return sb.toString();
            }
            sb.append(c);
        }
        ret.delete(0, ret.length());
        return sb.toString();
    }

    private static Number parseNum(String input, int last, StringBuffer ret) {
        StringBuffer sb = new StringBuffer();
        while (last < input.length()) {
            char c = input.charAt(last);
            if (!Character.isDigit(c)) break;
            sb.append(c);
            ++last;
        }
        int i = Integer.decode(sb.toString());
        ret.replace(0, ret.length(), input.substring(last));
        return i;
    }

    public void prettyPrint(PrintStream ps) {
        this.prettyPrint(ps, 0);
    }

    private void prettyPrint(PrintStream ps, int indent) {
        String tab = " ";
        String tabs = "";
        int i = 0;
        while (i < indent) {
            tabs = String.valueOf(tabs) + tab;
            ++i;
        }
        switch (this.type) {
            case MSON_NULL: {
                ps.print(tabs);
                ps.println("null");
                break;
            }
            case MSON_STRING: 
            case MSON_NUMBER: 
            case MSON_BOOLEAN: {
                ps.print(tabs);
                ps.println(this.toString());
                break;
            }
            case MSON_LIST: {
                ps.print(tabs);
                ps.println("[");
                for (Mson element : (MsonList)this.obj) {
                    element.prettyPrint(ps, indent + 1);
                }
                ps.print(tabs);
                ps.println("]");
                break;
            }
            case MSON_ASSOC: {
                ps.print(tabs);
                ps.println("{");
                MsonAssoc assoc = (MsonAssoc)this.obj;
                for (String key : assoc.keySet()) {
                    ps.print(tabs);
                    ps.print("\"" + key + "\":" + tab);
                    Mson val = (Mson)assoc.get(key);
                    MsonType valtype = val.type;
                    switch (valtype) {
                        case MSON_NULL: 
                        case MSON_STRING: 
                        case MSON_NUMBER: 
                        case MSON_BOOLEAN: {
                            ps.println(val.toString());
                            break;
                        }
                        case MSON_LIST: 
                        case MSON_ASSOC: {
                            val.prettyPrint(ps, indent + 2);
                        }
                    }
                }
                ps.print(tabs);
                ps.println("}");
                break;
            }
        }
    }

    public Mson deepSearch(String key) {
        switch (this.type) {
            case MSON_ASSOC: {
                MsonAssoc hash = (MsonAssoc)this.obj;
                if (hash.containsKey(key)) {
                    return (Mson)hash.get(key);
                }
                for (Mson mson : hash.values()) {
                    Mson mson2 = mson.deepSearch(key);
                    if (mson2 == null) continue;
                    return mson2;
                }
                return null;
            }
            case MSON_LIST: {
                MsonList list = (MsonList)this.obj;
                for (Mson mson : list) {
                    Mson mson2 = mson.deepSearch(key);
                    if (mson2 == null) continue;
                    return mson2;
                }
                return null;
            }
            case MSON_NULL: 
            case MSON_STRING: 
            case MSON_NUMBER: 
            case MSON_BOOLEAN: {
                return null;
            }
        }
        return null;
    }

    public Mson getList(String key) throws Exception {
        Mson ret = new Mson();
        if (this.type == MsonType.MSON_ASSOC) {
            MsonAssoc hash = (MsonAssoc)this.obj;
            for (String key2 : hash.keySet()) {
                Mson mson = (Mson)hash.get(key2);
                ret = key.equals(key2) ? ret.add(mson) : ret.append(mson.getList(key));
            }
            return ret;
        }
        if (this.type == MsonType.MSON_LIST) {
            MsonList list = (MsonList)this.obj;
            for (Mson mson : list) {
                ret = ret.append(mson.getList(key));
            }
            return ret;
        }
        return ret;
    }

    public ArrayList<Mson[]> getLists(String[] keys) throws Exception {
        ArrayList<Mson[]> ret = new ArrayList<Mson[]>();
        Mson[] rets = new Mson[keys.length];
        if (this.type == MsonType.MSON_ASSOC) {
            MsonAssoc hash = (MsonAssoc)this.obj;
            rets = new Mson[keys.length];
            for (String mkey : hash.keySet()) {
                Mson mson = (Mson)hash.get(mkey);
                boolean flag = false;
                int i = 0;
                while (i < keys.length) {
                    if (mkey.equals(keys[i])) {
                        rets[i] = mson;
                        flag = true;
                    }
                    ++i;
                }
                if (flag) continue;
                ret.addAll(mson.getLists(keys));
            }
            if (rets[0] != null) {
                ret.add(rets);
            }
            return ret;
        }
        if (this.type == MsonType.MSON_LIST) {
            MsonList list = (MsonList)this.obj;
            for (Mson mson : list) {
                ret.addAll(mson.getLists(keys));
            }
            return ret;
        }
        return ret;
    }

    public ArrayList<String[]> getListString(String[] keys) throws Exception {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        String[] rets = new String[keys.length];
        if (this.type == MsonType.MSON_ASSOC) {
            MsonAssoc hash = (MsonAssoc)this.obj;
            rets = new String[keys.length];
            for (String mkey : hash.keySet()) {
                Mson mson = (Mson)hash.get(mkey);
                boolean flag = false;
                int i = 0;
                while (i < keys.length) {
                    if (mkey.equals(keys[i])) {
                        String s = mson.toString();
                        if (mson.type == MsonType.MSON_STRING) {
                            s = s.substring(1, s.length() - 1);
                        }
                        rets[i] = s;
                        flag = true;
                    }
                    ++i;
                }
                if (flag) continue;
                ret.addAll(mson.getListString(keys));
            }
            if (rets[0] != null) {
                ret.add(rets);
            }
            return ret;
        }
        if (this.type == MsonType.MSON_LIST) {
            MsonList list = (MsonList)this.obj;
            for (Mson mson : list) {
                ret.addAll(mson.getListString(keys));
            }
            return ret;
        }
        return ret;
    }

    public static void main(String[] arg) throws Exception {
        Mson mson0 = new Mson();
        System.out.println("" + mson0);
        Mson mson1 = new Mson("string");
        System.out.println("" + mson1);
        Mson mson2 = new Mson();
        mson2 = mson2.add(mson1);
        System.out.println("2_1>" + mson2);
        mson2 = mson2.add(mson1);
        System.out.println("2_2>" + mson2);
        Mson mson3 = new Mson();
        mson3.put("key", mson1);
        System.out.println("3_1>" + mson3);
        mson3.put("key2", mson2);
        System.out.println("3_2>" + mson3);
        Mson mson4 = new Mson();
        StringBuffer ret = new StringBuffer();
        mson4 = Mson.parse("{\"key2\":[\"string\",\"string\"],\"key\":\"string\"}", 0, ret);
        System.out.println("4_1>" + mson4);
        mson4 = Mson.parse("{\"fullscreen\":false,\"\u30b9\u30af\u30ea\u30fc\u30f3\u5e45\":1200,\"screen_height\":900,\"antialias\":false,\"port\":39390,\"max_script_execution_time\":5000,\"max_local_storage_size\":512000,\"upnp\":false,\"udp_port\":39391,\"language\":\"jp\",\"lobby_servers\":[\"m2op.net\"]}}", 0, ret);
        System.out.println("4_2>" + mson4);
        System.out.println("End");
    }

    private class MsonAssoc
    extends HashMap<String, Mson> {
        private MsonAssoc() {
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "{}";
            }
            StringBuffer sb = new StringBuffer();
            for (String key : this.keySet()) {
                sb.append(",\"" + key + "\":" + ((Mson)this.get(key)).toString());
            }
            return String.valueOf(sb.replace(0, 1, "{").toString()) + "}";
        }
    }

    private class MsonList
    extends ArrayList<Mson> {
        private MsonList() {
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuffer sb = new StringBuffer();
            for (Mson mson : this) {
                sb.append("," + mson.toString());
            }
            return String.valueOf(sb.replace(0, 1, "[").toString()) + "]";
        }
    }

    static enum MsonType {
        MSON_NULL,
        MSON_STRING,
        MSON_LIST,
        MSON_ASSOC,
        MSON_NUMBER,
        MSON_BOOLEAN;

    }
}

