#include <kernel.h>
#include "kernel_cfg.h"

#include "rpi_lib/rpi.h"
#include <stdio.h>
#include <stdint.h>

#ifdef RPIBPLUS
#define	LED_ACT_PIN	47	//TYPE B PLUS
#elif RPI2
#define LED_ACT_PIN	47	// PRI2
#else
#define LED_ACT_PIN	16	//TYPE B
#endif

int task2Active;


void set_vector_table(void){
	extern void *_initial_vector_start;
	extern void *_initial_vector_end;
	// volatileをつけないと最適化に消される（涙目）
	volatile unsigned int *vec = 0;
	volatile unsigned int *p;
	volatile unsigned int *s = (unsigned int *)&_initial_vector_start;
	volatile unsigned int *e = (unsigned int *)&_initial_vector_end;

	printf("Vector table check\n");
	printf("Addr : Hex\n");
	for (p = s; p < e; p++) {
		*vec = *p;
		printf("0x%02x : 0x%08x\n",vec,*vec);
		vec++;
	}
}

// タイマー割り込み処理
void timerIRQ_handler(void)
{
	_kernel_signal_time();
}


// IRQ割り込みハンドラ
void IRQ_handler(void)
{
	// Basic IRQ pendingをチェック
	if(*INTERRUPT_IRQ_BASIC_PENDING & 0x01 != 0)
	{
		// タイマー割り込み

        // 割り込みフラグクリア
        *TIMER_IRQ_CLR = 0;

		// タイマ割り込み処理
		enable_IRQ();
		timerIRQ_handler();
		disable_IRQ();

		// フラグがクリアされたかチェック
	}
	// TODO: その他の割り込みも調べる

	return;
}



int main(void){
	rpi_init();

	// ベクタテーブルセット
	set_vector_table();

	// すべての割り込み不許可
	*INTERRUPT_DISABLE_BASIC_IRQS = 0xffffffff;
	*INTERRUPT_DISABLE_IRQS1 = 0xffffffff;
	*INTERRUPT_DISABLE_IRQS2 = 0xffffffff;
	*INTERRUPT_FIQ_CTRL = 0;

	// タイマ割り込み設定
	*INTERRUPT_ENABLE_BASIC_IRQS = 0x01;

	// 設定のため一旦タイマー停止
	*TIMER_CONTROL &= 0xffffff00;

	// timer clock を1MHzに設定
	//（0xF9=249: timer clock=250MHz/(249+1)）
	*TIMER_PREDIVIDER = 0x000000F9;

	// タイマー値設定(1msec)に修正
	//*TIMER_LOAD = 4000000-1;
	//*TIMER_RELOAD = 4000000-1;
	*TIMER_LOAD = 1000-1;
	*TIMER_RELOAD = 1000-1;

	// 割り込みフラグをクリア
	*TIMER_IRQ_CLR = 0;

	// タイマー開始
	// Timer enable, 32bit Timer
	*TIMER_CONTROL |= 0x000000A2;

	// 割り込み許可
	*INTERRUPT_ENABLE_BASIC_IRQS = 0x01;

	// IRQ許可
	enable_IRQ();

	sta_ker();

	while(1);		//ここには来ない
//
//	return 0;
}

void task1(intptr_t arg)
{
	printf("task1 start-----------------------------------------------------\n");
	mruby_call();
	printf("task1 End.\n");
}
void task2(intptr_t arg)
{
	int count;
	count = 1;
	printf("task2 Started\m");
	while(1)
	{
	//	printf("task2 running Count= %d\n",count++);
	}
}
