/*
 * Decompiled with CFR 0.152.
 */
package chexaformation;

import chexaformation.cheEmblem;
import chexaformation.cheFile;
import chexaformation.cheOkeData;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class cheTeamData {
    public static final int datasize = 832;
    File data_name;
    cheOkeData[] oke;
    int[] position;
    cheEmblem emblem;
    String team_name;
    String owner_name;
    int year;
    int month;
    int day;
    int rating;
    boolean benable;

    private boolean inner_load(byte[] s, int nofs, cheFile che) {
        byte[] work = new byte[39];
        if (nofs + 832 > s.length) {
            return false;
        }
        this.data_name = new File(che.get_fname());
        if (s[nofs] == 0 && s[nofs + 1] == 0 && s[nofs + 2] == 0 && s[nofs + 3] == 0) {
            return true;
        }
        try {
            int nlen;
            for (nlen = 0; nlen < 25; ++nlen) {
                work[nlen] = s[nofs + 592 + nlen];
                if (work[nlen] == 0) break;
            }
            this.team_name = new String(work, 0, nlen, "SJIS");
            for (nlen = 0; nlen < 39; ++nlen) {
                work[nlen] = s[nofs + 617 + nlen];
                if (work[nlen] == 0) break;
            }
            this.owner_name = new String(work, 0, nlen, "SJIS");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(cheTeamData.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.emblem.load(s, nofs + 16);
        this.year = s[nofs + 800] & 0xFF | (s[nofs + 801] & 0xFF) << 8;
        this.month = s[nofs + 802] & 0xFF | (s[nofs + 803] & 0xFF) << 8;
        this.day = s[nofs + 804] & 0xFF | (s[nofs + 805] & 0xFF) << 8;
        this.rating = s[nofs + 824] & 0xFF;
        this.rating += (s[nofs + 825] & 0xFF) << 8;
        this.rating += (s[nofs + 826] & 0xFF) << 16;
        this.rating += (s[nofs + 827] & 0xFF) << 24;
        for (int i = 0; i < 3; ++i) {
            int okeno = s[nofs + 688 + i * 48] & 0xFF;
            if (okeno >= 0 && okeno < che.get_oke_max()) {
                this.oke[i] = che.get_oke(okeno);
                this.position[i] = s[nofs + 692 + i * 48] & 0xFF;
                continue;
            }
            this.oke[i] = null;
            this.position[i] = -1;
        }
        this.benable = true;
        return true;
    }

    public cheTeamData() {
        Calendar nowDate = Calendar.getInstance();
        this.oke = new cheOkeData[3];
        this.position = new int[3];
        this.position[0] = -1;
        this.position[1] = -1;
        this.position[2] = -1;
        this.team_name = "\u30c1\u30fc\u30e0";
        this.owner_name = "\u30d7\u30ec\u30a4\u30e4\u30fc";
        this.emblem = new cheEmblem();
        this.year = nowDate.get(1);
        this.month = nowDate.get(2);
        this.day = nowDate.get(5);
        this.rating = 1000;
        this.benable = true;
    }

    public cheTeamData(byte[] s, int nofs, cheFile che) {
        this.oke = new cheOkeData[3];
        this.position = new int[3];
        this.benable = false;
        this.emblem = new cheEmblem();
        this.inner_load(s, nofs, che);
    }

    public void copy(cheTeamData p) {
        p.team_name = this.team_name;
        p.owner_name = this.owner_name;
        p.emblem = this.emblem;
        p.year = this.year;
        p.month = this.month;
        p.day = this.day;
        p.rating = this.rating;
        System.arraycopy(this.position, 0, p.position, 0, 3);
        System.arraycopy(this.oke, 0, p.oke, 0, 3);
        p.benable = this.benable;
        p.data_name = this.data_name;
    }

    public boolean load(byte[] s, int nofs, cheFile che) {
        return this.inner_load(s, nofs, che);
    }

    public boolean save(byte[] s, int nofs) {
        int i;
        if (nofs + 832 > s.length) {
            return false;
        }
        for (i = 0; i < 832; ++i) {
            s[nofs + i] = 0;
        }
        s[nofs] = 2;
        try {
            byte[] work = this.team_name.getBytes("SJIS");
            int ncpy = work.length;
            if (ncpy > 24) {
                ncpy = 24;
            }
            System.arraycopy(work, 0, s, nofs + 592, ncpy);
            work = this.owner_name.getBytes("SJIS");
            ncpy = work.length;
            if (ncpy > 38) {
                ncpy = 38;
            }
            System.arraycopy(work, 0, s, nofs + 617, ncpy);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(cheTeamData.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.emblem.save(s, nofs + 16);
        s[nofs + 800] = (byte)(this.year & 0xFF);
        s[nofs + 801] = (byte)(this.year >> 8);
        s[nofs + 802] = (byte)(this.month & 0xFF);
        s[nofs + 803] = (byte)(this.month >> 8);
        s[nofs + 804] = (byte)(this.day & 0xFF);
        s[nofs + 805] = (byte)(this.day >> 8);
        s[nofs + 824] = (byte)(this.rating & 0xFF);
        s[nofs + 825] = (byte)(this.rating >> 8);
        s[nofs + 826] = (byte)(this.rating >> 16);
        s[nofs + 827] = (byte)(this.rating >> 24);
        for (i = 0; i < 3; ++i) {
            if (this.oke[i] != null && this.position[i] != -1) {
                int noke = this.oke[i].get_no();
                s[nofs + 688 + i * 48] = (byte)(noke & 0xFF);
                s[nofs + 689 + i * 48] = (byte)(noke >> 8);
                s[nofs + 690 + i * 48] = (byte)(noke >> 16);
                s[nofs + 691 + i * 48] = (byte)(noke >> 24);
                s[nofs + 692 + i * 48] = (byte)(this.position[i] & 0xFF);
                s[nofs + 693 + i * 48] = (byte)(this.position[i] >> 8);
                s[nofs + 694 + i * 48] = (byte)(this.position[i] >> 16);
                s[nofs + 695 + i * 48] = (byte)(this.position[i] >> 24);
                continue;
            }
            s[nofs + 688 + i * 48] = -1;
            s[nofs + 689 + i * 48] = -1;
            s[nofs + 690 + i * 48] = -1;
            s[nofs + 691 + i * 48] = -1;
            s[nofs + 692 + i * 48] = -1;
            s[nofs + 693 + i * 48] = -1;
            s[nofs + 694 + i * 48] = -1;
            s[nofs + 695 + i * 48] = -1;
        }
        return true;
    }

    public boolean check_position(int nidx, int npos) {
        for (int i = 0; i < 3; ++i) {
            if (nidx == i || this.position[i] != npos) continue;
            return false;
        }
        return true;
    }

    public boolean add_member(int nidx, cheOkeData p, int npos) {
        if (nidx < 0 || nidx > 2) {
            return false;
        }
        if (npos != -1 && !this.check_position(nidx, npos)) {
            for (int i = 0; i < 2; ++i) {
                npos += 3;
                if (this.check_position(nidx, npos %= 9)) break;
            }
        }
        this.oke[nidx] = p;
        this.position[nidx] = npos < 0 || npos > 8 ? -1 : npos;
        return true;
    }

    public boolean del_member(int nidx) {
        if (nidx < 0 || nidx > 2) {
            return false;
        }
        this.oke[nidx] = null;
        this.position[nidx] = -1;
        return true;
    }

    public cheOkeData get_member(int nidx) {
        if (nidx < 0 || nidx > 2) {
            return null;
        }
        return this.oke[nidx];
    }

    public void set_member(int nidx, cheOkeData p) {
        if (nidx < 0 || nidx > 2) {
            return;
        }
        this.oke[nidx] = p;
    }

    public cheOkeData[] get_unique_member() {
        cheOkeData[] unique_list = new cheOkeData[3];
        int i = 0;
        unique_list[i++] = this.oke[0];
        if (this.oke[1] != null && this.oke[0] != this.oke[1]) {
            unique_list[i++] = this.oke[1];
        }
        if (this.oke[2] != null && this.oke[0] != this.oke[2] && this.oke[1] != this.oke[2]) {
            unique_list[i++] = this.oke[2];
        }
        return unique_list;
    }

    public int get_position(int nidx) {
        if (nidx < 0 || nidx > 2) {
            return -1;
        }
        return this.position[nidx];
    }

    public void set_position(int nidx, int n) {
        if (nidx < 0 || nidx > 2) {
            return;
        }
        if (n != -1 && this.oke[nidx] != null && !this.check_position(nidx, n)) {
            return;
        }
        this.position[nidx] = n;
    }

    public String get_team_name() {
        return this.team_name;
    }

    public String get_owner_name() {
        return this.owner_name;
    }

    public int get_year() {
        return this.year;
    }

    public int get_month() {
        return this.month;
    }

    public int get_day() {
        return this.day;
    }

    public int get_rating() {
        return this.rating;
    }

    public void set_team_name(String s) {
        this.team_name = s;
    }

    public void set_owner_name(String s) {
        this.owner_name = s;
    }

    public void set_date(int y, int m, int d) {
        this.year = y;
        this.month = m;
        this.day = d;
    }

    public void set_rating(int n) {
        this.rating = n;
    }

    public void set_emblem(cheEmblem emb) {
        emb.copy(this.emblem);
    }

    public void set_emblem(cheOkeData oke) {
        oke.get_emblem().copy(this.emblem);
    }

    public cheEmblem get_emblem() {
        return this.emblem;
    }

    public boolean is_enable() {
        return this.benable;
    }

    public void set_enable(boolean b) {
        this.benable = b;
    }

    public String get_data_name() {
        return this.data_name.getName();
    }

    public String member_pos(int nidx) {
        if (nidx < 0 || nidx > 2) {
            return ResourceBundle.getBundle("chexaformation/resource").getString("unknownOkePos");
        }
        switch (this.position[nidx]) {
            case 0: {
                return ResourceBundle.getBundle("chexaformation/resource").getString("okePosLeftForward");
            }
            case 1: {
                return ResourceBundle.getBundle("chexaformation/resource").getString("okePosForward");
            }
            case 2: {
                return ResourceBundle.getBundle("chexaformation/resource").getString("okePosRightForward");
            }
            case 3: {
                return ResourceBundle.getBundle("chexaformation/resource").getString("okePosLeft");
            }
            case 4: {
                return ResourceBundle.getBundle("chexaformation/resource").getString("okePosCenter");
            }
            case 5: {
                return ResourceBundle.getBundle("chexaformation/resource").getString("okePosRight");
            }
            case 6: {
                return ResourceBundle.getBundle("chexaformation/resource").getString("okePosLeftBackward");
            }
            case 7: {
                return ResourceBundle.getBundle("chexaformation/resource").getString("okePosBackward");
            }
            case 8: {
                return ResourceBundle.getBundle("chexaformation/resource").getString("okePosRightBackward");
            }
        }
        return ResourceBundle.getBundle("chexaformation/resource").getString("unknownOkePos");
    }

    public String[] make_member_list() {
        String[] member = new String[3];
        for (int i = 0; i < 3; ++i) {
            member[i] = Integer.toString(i + 1) + ":";
            if (this.oke[i] != null) {
                int n = i;
                member[n] = member[n] + this.oke[i].toString() + "[" + this.member_pos(i) + "]";
                continue;
            }
            int n = i;
            member[n] = member[n] + "-nothing-";
        }
        return member;
    }

    public String toString() {
        String retstr = this.team_name;
        for (int i = this.team_name.length(); i < 12; ++i) {
            retstr = retstr + "\u3000";
        }
        retstr = retstr + "[" + this.owner_name;
        retstr = retstr + "]:";
        retstr = retstr + (this.data_name == null ? "" : this.data_name.getName());
        return retstr;
    }

    public String make_text(String dname) {
        String retstr = dname != null ? dname : this.data_name.getName();
        retstr = retstr + '\t';
        retstr = retstr + this.team_name;
        retstr = retstr + '\t';
        retstr = retstr + '(' + this.owner_name + ')';
        for (int i = 0; i < 3; ++i) {
            retstr = retstr + '\t';
            if (this.oke[i] != null) {
                retstr = retstr + this.oke[i].get_name();
                retstr = retstr + '\t';
                retstr = retstr + '[' + this.oke[i].get_bodyname() + ']';
                retstr = retstr + '\t';
                retstr = retstr + this.member_pos(i);
                continue;
            }
            retstr = retstr + '\t';
            retstr = retstr + '\t';
        }
        return retstr;
    }
}

