/*
 * Decompiled with CFR 0.152.
 */
package chexaformation;

import chexaformation.cheOkeData;
import chexaformation.cheTeamData;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class cheFile {
    static final int teamfile_size = 24512;
    static final int matchfile_size = 266232;
    static final int buffer_size = 327680;
    static final byte[] teamfile_head = new byte[]{67, 69, 84, 68, 28, 0, 0, 0};
    static final byte[] matchfile_head = new byte[]{67, 69, 77, 68, 72, 1, 0, 0};
    static final byte[] file_version = new byte[]{48, 46, 48, 46, 52, 52, 0, 0};
    static HashMap<String, cheFile> filelist = new HashMap();
    String fname;
    cheTeamData[] team;
    cheOkeData[] oke;
    boolean bteamfile;
    int team_max;
    int oke_max;
    byte[] match_data;

    private boolean inner_load() {
        int i;
        int read_size;
        byte[] wk_buffer = new byte[327680];
        try {
            FileInputStream fin = new FileInputStream(this.fname);
            read_size = fin.read(wk_buffer);
            fin.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(cheFile.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IOException ex) {
            Logger.getLogger(cheFile.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        if (read_size == 24512) {
            for (i = 0; i < teamfile_head.length; ++i) {
                if (wk_buffer[i] == teamfile_head[i]) continue;
                return false;
            }
            this.bteamfile = true;
            this.team_max = 1;
            this.oke_max = 3;
        } else if (read_size == 266232) {
            for (i = 0; i < matchfile_head.length; ++i) {
                if (wk_buffer[i] == matchfile_head[i]) continue;
                return false;
            }
            this.bteamfile = false;
            this.team_max = 16;
            this.oke_max = 32;
            this.match_data = new byte[336];
            System.arraycopy(wk_buffer, 24, this.match_data, 0, 336);
        } else {
            return false;
        }
        this.team = new cheTeamData[this.team_max];
        this.oke = new cheOkeData[this.oke_max];
        int nofs = this.bteamfile ? 880 : 13964;
        i = 0;
        while (i < this.oke_max) {
            this.oke[i] = new cheOkeData(i);
            if (!this.oke[i].load(wk_buffer, nofs) || this.oke[i].get_flag() == 0) {
                this.oke[i] = null;
            }
            ++i;
            nofs += 7872;
        }
        nofs = this.bteamfile ? 48 : 652;
        i = 0;
        while (i < this.team_max) {
            this.team[i] = new cheTeamData(wk_buffer, nofs, this);
            if (!this.team[i].is_enable()) {
                this.team[i] = null;
            }
            ++i;
            nofs += 832;
        }
        return true;
    }

    public cheFile(byte[] d) {
        this.fname = "NEWMATCH.CHE";
        this.team_max = 16;
        this.oke_max = 32;
        this.bteamfile = false;
        this.match_data = new byte[336];
        if (d.length >= 336) {
            System.arraycopy(d, 0, this.match_data, 0, 336);
        }
        this.team = new cheTeamData[this.team_max];
        this.oke = new cheOkeData[this.oke_max];
    }

    public cheFile(String s) {
        this.fname = s;
        this.bteamfile = true;
        this.team_max = 0;
        this.oke_max = 0;
    }

    public cheFile() {
        this.fname = "NEWDATA.CHE";
        this.team_max = 1;
        this.oke_max = 3;
        this.bteamfile = true;
        this.team = new cheTeamData[this.team_max];
        this.oke = new cheOkeData[this.oke_max];
    }

    public boolean load() {
        this.bteamfile = true;
        this.team_max = 0;
        this.oke_max = 0;
        if (this.inner_load()) {
            filelist.put(this.fname, this);
            return true;
        }
        return false;
    }

    public boolean save() {
        if (this.team_max == 0) {
            return false;
        }
        int write_size = this.bteamfile ? 24512 : 266232;
        byte[] wk_buffer = new byte[write_size];
        if (this.bteamfile) {
            System.arraycopy(teamfile_head, 0, wk_buffer, 0, teamfile_head.length);
            System.arraycopy(file_version, 0, wk_buffer, 24496, file_version.length);
        } else {
            System.arraycopy(matchfile_head, 0, wk_buffer, 0, matchfile_head.length);
            System.arraycopy(file_version, 0, wk_buffer, 8, file_version.length);
        }
        int real_oke_count = 0;
        int nofs = this.bteamfile ? 880 : 13964;
        int i = 0;
        while (i < this.oke_max) {
            if (this.oke[i] != null && this.oke[i].get_flag() != 0 && this.oke[i].save(wk_buffer, nofs)) {
                ++real_oke_count;
            }
            ++i;
            nofs += 7872;
        }
        int real_team_count = 0;
        nofs = this.bteamfile ? 48 : 652;
        i = 0;
        while (i < this.team_max) {
            if (this.team[i] != null && this.team[i].is_enable() && this.team[i].save(wk_buffer, nofs)) {
                ++real_team_count;
            }
            ++i;
            nofs += 832;
        }
        if (this.bteamfile) {
            long checksum = 0L;
            for (nofs = 0; nofs < 24504; ++nofs) {
                checksum += (long)wk_buffer[nofs];
            }
            wk_buffer[nofs++] = (byte)(checksum & 0xFFL);
            wk_buffer[nofs++] = (byte)(checksum >> 8);
            wk_buffer[nofs++] = (byte)(checksum >> 16);
            wk_buffer[nofs++] = (byte)(checksum >> 24);
        } else {
            System.arraycopy(this.match_data, 0, wk_buffer, 24, 336);
            System.arraycopy(this.match_data, 0, wk_buffer, 360, 36);
            System.arraycopy(this.match_data, 36, wk_buffer, 265868, 300);
            nofs = 52;
            wk_buffer[nofs++] = (byte)(real_team_count & 0xFF);
            wk_buffer[nofs++] = (byte)(real_team_count >> 8);
            wk_buffer[nofs++] = (byte)(real_team_count >> 16);
            wk_buffer[nofs++] = (byte)(real_team_count >> 24);
            wk_buffer[nofs++] = (byte)(real_oke_count & 0xFF);
            wk_buffer[nofs++] = (byte)(real_oke_count >> 8);
            wk_buffer[nofs++] = (byte)(real_oke_count >> 16);
            wk_buffer[nofs++] = (byte)(real_oke_count >> 24);
            nofs = 388;
            wk_buffer[nofs++] = (byte)(real_team_count & 0xFF);
            wk_buffer[nofs++] = (byte)(real_team_count >> 8);
            wk_buffer[nofs++] = (byte)(real_team_count >> 16);
            wk_buffer[nofs++] = (byte)(real_team_count >> 24);
            wk_buffer[nofs++] = (byte)(real_oke_count & 0xFF);
            wk_buffer[nofs++] = (byte)(real_oke_count >> 8);
            wk_buffer[nofs++] = (byte)(real_oke_count >> 16);
            wk_buffer[nofs++] = (byte)(real_oke_count >> 24);
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.fname);
            fout.write(wk_buffer);
            fout.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(cheFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(cheFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    public int get_team_max() {
        return this.team_max;
    }

    public int get_oke_max() {
        return this.oke_max;
    }

    public String get_fname() {
        return this.fname;
    }

    public void set_fname(String s) {
        this.fname = s;
    }

    public cheTeamData get_team(int nidx) {
        if (nidx < 0 || nidx >= this.team_max) {
            return null;
        }
        return this.team[nidx];
    }

    public boolean set_team(int nidx, cheTeamData p) {
        int i;
        if (nidx < 0 || nidx >= this.team_max) {
            return false;
        }
        if (this.team[nidx] != null) {
            this.team[nidx] = null;
            this.gc_oke();
        }
        this.team[nidx] = new cheTeamData();
        p.copy(this.team[nidx]);
        cheOkeData[] ulist = p.get_unique_member();
        for (i = 0; i < 3; ++i) {
            if (ulist[i] == null || this.add_oke(ulist[i]) != null) continue;
            this.team[nidx] = null;
            this.gc_oke();
            return false;
        }
        for (i = 0; i < 3; ++i) {
            cheOkeData wk_oke = p.get_member(i);
            if (wk_oke == null) continue;
            int j = this.search_oke(wk_oke);
            if (j != -1) {
                this.team[nidx].set_member(i, this.oke[j]);
                continue;
            }
            this.team[nidx].set_member(i, null);
        }
        return true;
    }

    public void remove_team(int nidx) {
        if (nidx < 0 || nidx >= this.team_max) {
            return;
        }
        this.team[nidx] = null;
        this.gc_oke();
    }

    public void move_team(int src, int dest) {
        if (src < 0 || src >= this.team_max || dest < 0 || dest >= this.team_max || src == dest) {
            return;
        }
        if (this.team[dest] == null) {
            this.team[dest] = this.team[src];
            this.team[src] = null;
        } else {
            int i;
            cheTeamData wkteam = this.team[src];
            for (i = src; i < this.team_max - 2; ++i) {
                this.team[i] = this.team[i + 1];
            }
            this.team[i] = null;
            for (i = this.team_max - 1; i > dest; --i) {
                this.team[i] = this.team[i - 1];
            }
            this.team[dest] = wkteam;
        }
        this.gc_oke();
    }

    public cheOkeData get_oke(int nidx) {
        if (nidx < 0 || nidx >= this.oke_max) {
            return null;
        }
        return this.oke[nidx];
    }

    public void set_oke(int nidx, cheOkeData p) {
        if (nidx < 0 || nidx >= this.oke_max) {
            return;
        }
        this.oke[nidx] = p;
    }

    public int search_oke(cheOkeData p) {
        for (int i = 0; i < this.oke_max; ++i) {
            if (this.oke[i] == null || !this.oke[i].equals(p)) continue;
            return i;
        }
        return -1;
    }

    public cheOkeData add_oke(cheOkeData p) {
        int i = this.search_oke(p);
        if (i != -1) {
            return this.oke[i];
        }
        for (i = 0; i < this.oke_max; ++i) {
            if (this.oke[i] != null) continue;
            this.oke[i] = new cheOkeData(i);
            p.copy(this.oke[i]);
            return this.oke[i];
        }
        return null;
    }

    public String get_match_name() {
        if (this.match_data != null) {
            int nlen;
            byte[] work = new byte[28];
            for (nlen = 0; nlen < 28; ++nlen) {
                work[nlen] = this.match_data[nlen];
                if (work[nlen] == 0) break;
            }
            try {
                return new String(work, 0, nlen, "SJIS");
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(cheFile.class.getName()).log(Level.SEVERE, null, ex);
                return new String();
            }
        }
        return null;
    }

    public void set_match_name(String s) {
        if (this.match_data != null) {
            try {
                byte[] work = s.getBytes("SJIS");
                int ncpy = work.length;
                if (ncpy > 28) {
                    ncpy = 28;
                }
                Arrays.fill(this.match_data, 0, 28, (byte)0);
                System.arraycopy(work, 0, this.match_data, 0, ncpy);
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(cheFile.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public byte[] get_match_data() {
        if (this.match_data != null) {
            byte[] p = new byte[336];
            System.arraycopy(this.match_data, 0, p, 0, 336);
            return p;
        }
        return null;
    }

    public boolean set_match_data(byte[] p) {
        if (this.match_data != null) {
            if (p.length >= 336) {
                System.arraycopy(p, 0, this.match_data, 0, 336);
                return true;
            }
            return false;
        }
        return false;
    }

    public void gc_oke() {
        if (this.oke_max > 0) {
            int i;
            boolean[] bflag = new boolean[this.oke_max];
            Arrays.fill(bflag, false);
            for (i = 0; i < this.team_max; ++i) {
                if (this.team[i] == null) continue;
                cheOkeData[] ulist = this.team[i].get_unique_member();
                for (int j = 0; j < 3; ++j) {
                    int idx;
                    if (ulist[j] == null || (idx = this.search_oke(ulist[j])) == -1) continue;
                    bflag[idx] = true;
                }
            }
            for (i = 0; i < this.oke_max; ++i) {
                if (this.oke[i] == null || bflag[i]) continue;
                this.oke[i] = null;
            }
        }
    }

    public void clear_oke() {
        this.clear_team();
        Arrays.fill(this.oke, null);
    }

    public void clear_team() {
        Arrays.fill(this.team, null);
    }

    public boolean is_teamfile() {
        return this.bteamfile;
    }

    public static cheFile get_che(String s) {
        return filelist.get(s);
    }

    public static void clear_che() {
        filelist.clear();
    }
}

