/*
 * Decompiled with CFR 0.152.
 */
package chexaformation;

import chexaformation.Main;
import chexaformation.TeamListPanel;
import chexaformation.cheFile;
import chexaformation.cheNameDocument;
import chexaformation.cheTeamData;
import chexaformation.mainForm;
import chexaformation.transDestHandler2;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MatchDataPanel
extends JPanel {
    cheFile matchdata;
    DefaultListModel teamdata;
    private JButton addTeam;
    private JButton closeButton;
    private JButton delTeam;
    private JScrollPane jScrollPane1;
    private JTextField matchName;
    private JButton outTextTeam;
    private JButton saveMatch;
    private JList teamList;
    private JLabel titleMatch;

    public MatchDataPanel(cheFile p) {
        if (p == null) {
            p = new cheFile();
        }
        this.matchdata = p;
        this.teamdata = new DefaultListModel();
        this.update_teamlist();
        this.initComponents();
    }

    private void update_teamlist() {
        this.teamdata.clear();
        for (int i = 0; i < this.matchdata.get_team_max(); ++i) {
            cheTeamData pwk = this.matchdata.get_team(i);
            if (pwk == null) {
                pwk = new cheTeamData();
                pwk.set_team_name("-nothing-");
                pwk.set_owner_name("-nothing-");
                pwk.set_enable(false);
            }
            this.teamdata.addElement(pwk);
        }
    }

    private void normalize_teamlist() {
        for (int i = 0; i < this.matchdata.get_team_max() - 1; ++i) {
            int j;
            cheTeamData pwk = this.matchdata.get_team(i);
            if (pwk != null) continue;
            for (j = i; j < this.matchdata.get_team_max() && (pwk = this.matchdata.get_team(j)) == null; ++j) {
            }
            if (j >= this.matchdata.get_team_max()) break;
            this.matchdata.remove_team(j);
            this.matchdata.set_team(i, pwk);
        }
    }

    public void update_title() {
        File fn = new File(this.matchdata.get_fname());
        JDialog dlg = (JDialog)this.getRootPane().getParent();
        String title = ResourceBundle.getBundle("chexaformation/resource").getString("titleMatchDataPanel");
        title = title + fn.getName();
        dlg.setTitle(title);
    }

    private TeamListPanel get_teampanel() {
        mainForm form = (mainForm)this.getRootPane().getParent().getParent();
        return form.get_teamlist();
    }

    public cheTeamData get_current_team() {
        int nsel = this.teamList.getSelectedIndex();
        if (nsel != -1) {
            return (cheTeamData)this.teamdata.get(nsel);
        }
        return null;
    }

    public int get_current_index() {
        return this.teamList.getSelectedIndex();
    }

    public void load_team(cheTeamData p, int n) {
        if (n == -1) {
            for (int i = 0; i < this.matchdata.get_team_max(); ++i) {
                if (this.matchdata.get_team(i) != null) continue;
                n = i;
                break;
            }
            if (n == -1) {
                Main.mesg_box((Dialog)this.getRootPane().getParent(), ResourceBundle.getBundle("chexaformation/resource").getString("addTEAM"), ResourceBundle.getBundle("chexaformation/resource").getString("errNoSpaceTeam"), "");
                return;
            }
        }
        if (n >= 0 && n < this.matchdata.get_team_max()) {
            if (!this.matchdata.set_team(n, p)) {
                Main.mesg_box((Dialog)this.getRootPane().getParent(), ResourceBundle.getBundle("chexaformation/resource").getString("addTEAM"), ResourceBundle.getBundle("chexaformation/resource").getString("errNoSpaceTeam"), "");
            } else {
                this.update_teamlist();
            }
        }
    }

    public void move_team(int src_idx, int dest_idx) {
        this.matchdata.move_team(src_idx, dest_idx);
        this.update_teamlist();
    }

    private void initComponents() {
        this.titleMatch = new JLabel();
        this.matchName = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.teamList = new JList();
        this.addTeam = new JButton();
        this.delTeam = new JButton();
        this.saveMatch = new JButton();
        this.outTextTeam = new JButton();
        this.closeButton = new JButton();
        this.titleMatch.setFont(new Font("Monospaced", 0, 15));
        ResourceBundle bundle = ResourceBundle.getBundle("chexaformation/resource");
        this.titleMatch.setText(bundle.getString("titleMatchName"));
        this.matchName.setDocument(new cheNameDocument());
        this.matchName.setFont(new Font("Monospaced", 0, 15));
        this.matchName.setText(this.matchdata.get_match_name());
        this.teamList.setFont(new Font("Monospaced", 0, 12));
        this.teamList.setModel(this.teamdata);
        this.teamList.setSelectionMode(0);
        this.teamList.setDragEnabled(true);
        this.jScrollPane1.setViewportView(this.teamList);
        this.teamList.setTransferHandler(new transDestHandler2());
        this.addTeam.setFont(new Font("Monospaced", 0, 12));
        this.addTeam.setText(bundle.getString("addTEAM"));
        this.addTeam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MatchDataPanel.this.addTeamActionPerformed(evt);
            }
        });
        this.delTeam.setFont(new Font("Monospaced", 0, 12));
        this.delTeam.setText(bundle.getString("delTEAM"));
        this.delTeam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MatchDataPanel.this.delTeamActionPerformed(evt);
            }
        });
        this.saveMatch.setFont(new Font("Monospaced", 0, 12));
        this.saveMatch.setText(bundle.getString("saveMatchData"));
        this.saveMatch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MatchDataPanel.this.saveMatchActionPerformed(evt);
            }
        });
        this.outTextTeam.setFont(new Font("Monospaced", 0, 12));
        this.outTextTeam.setText(bundle.getString("textOut"));
        this.outTextTeam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MatchDataPanel.this.outTextTeamActionPerformed(evt);
            }
        });
        this.closeButton.setFont(new Font("Monospaced", 0, 12));
        this.closeButton.setText(bundle.getString("closeWindow"));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MatchDataPanel.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 401, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addTeam).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.delTeam).addGap(18, 18, 18).addComponent(this.saveMatch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 93, Short.MAX_VALUE).addComponent(this.outTextTeam).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addGroup(layout.createSequentialGroup().addComponent(this.titleMatch).addGap(6, 6, 6).addComponent(this.matchName, -1, 320, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.matchName, -2, -1, -2).addComponent(this.titleMatch)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 277, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addTeam).addComponent(this.delTeam).addComponent(this.saveMatch).addComponent(this.closeButton).addComponent(this.outTextTeam)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void addTeamActionPerformed(ActionEvent evt) {
        int nsel = this.teamList.getSelectedIndex();
        TeamListPanel teampanel = this.get_teampanel();
        cheTeamData team = teampanel.get_current_team();
        if (team != null) {
            this.load_team(team, nsel);
            this.update_teamlist();
        }
    }

    private void delTeamActionPerformed(ActionEvent evt) {
        int nsel = this.teamList.getSelectedIndex();
        if (nsel != -1) {
            this.matchdata.remove_team(nsel);
            this.update_teamlist();
        }
    }

    private void saveMatchActionPerformed(ActionEvent evt) {
        JFileChooser fdlg = new JFileChooser(Main.cheMatchDataDir);
        String filterTitle = ResourceBundle.getBundle("chexaformation/resource").getString("filterTitleCHE");
        FileNameExtensionFilter ffilter = new FileNameExtensionFilter(filterTitle, "CHE");
        fdlg.setFileFilter(ffilter);
        fdlg.setSelectedFile(new File(this.matchdata.get_fname()));
        int nret = fdlg.showSaveDialog(this.getRootPane().getParent());
        if (nret == 0) {
            File ifile = fdlg.getSelectedFile();
            if (ifile.exists()) {
                String wktitle = ResourceBundle.getBundle("chexaformation/resource").getString("titleSaveMatch");
                String wkmesg = ResourceBundle.getBundle("chexaformation/resource").getString("confirmExistCHE");
                if (!Main.confirm_box((Dialog)this.getRootPane().getParent(), wktitle, wkmesg, "")) {
                    return;
                }
            }
            Main.cheMatchDataDir = ifile.getParent();
            this.normalize_teamlist();
            this.matchdata.set_match_name(this.matchName.getText());
            this.matchdata.set_fname(ifile.getAbsolutePath());
            if (this.matchdata.save()) {
                Main.mesg_box((Dialog)this.getRootPane().getParent(), ResourceBundle.getBundle("chexaformation/resource").getString("titleSaveMatch"), ResourceBundle.getBundle("chexaformation/resource").getString("mesgSaveMatch"), "");
            } else {
                Main.mesg_box((Dialog)this.getRootPane().getParent(), ResourceBundle.getBundle("chexaformation/resource").getString("titleSaveMatch"), ResourceBundle.getBundle("chexaformation/resource").getString("failSaveMatch"), ifile.getAbsolutePath());
            }
            this.update_teamlist();
            this.update_title();
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        String mesg;
        String title;
        JDialog dlg = (JDialog)this.getRootPane().getParent();
        if (Main.confirm_box(dlg, title = ResourceBundle.getBundle("chexaformation/resource").getString("titleClose"), mesg = ResourceBundle.getBundle("chexaformation/resource").getString("confirmClose"), "")) {
            dlg.dispose();
        }
    }

    private void outTextTeamActionPerformed(ActionEvent evt) {
        JFileChooser fdlg = new JFileChooser(Main.cheTextDataDir);
        String filterTitle = ResourceBundle.getBundle("chexaformation/resource").getString("filterTitleText");
        FileNameExtensionFilter ffilter = new FileNameExtensionFilter(filterTitle, "txt");
        fdlg.setFileFilter(ffilter);
        if (fdlg.showSaveDialog(this.getRootPane().getParent()) == 0) {
            File ifile = fdlg.getSelectedFile();
            if (ifile.exists()) {
                String wktitle = ResourceBundle.getBundle("chexaformation/resource").getString("titleSaveText");
                String wkmesg = ResourceBundle.getBundle("chexaformation/resource").getString("confirmExistText");
                if (!Main.confirm_box((Dialog)this.getRootPane().getParent(), wktitle, wkmesg, "")) {
                    return;
                }
            }
            try {
                PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(ifile.getAbsolutePath()), "UTF-8"));
                Main.cheTextDataDir = ifile.getParent();
                this.normalize_teamlist();
                for (int i = 0; i < this.matchdata.get_team_max(); ++i) {
                    cheTeamData team = this.matchdata.get_team(i);
                    if (team == null) continue;
                    File wkfile = new File(this.matchdata.get_fname());
                    w.println(team.make_text(wkfile.getName()));
                }
                w.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MatchDataPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

