/*
 * sample handler
 *
 * License : The MIT License
 * Copyright(c) 2015 MikuToga Partners
 */

package sample.pmx;

import jp.sfjp.mikutoga.bin.parser.ParseStage;
import jp.sfjp.mikutoga.pmx.parser.PmxBoneHandler;
import jp.sfjp.mikutoga.pmx.parser.PmxFaceHandler;
import jp.sfjp.mikutoga.pmx.parser.PmxMaterialHandler;
import jp.sfjp.mikutoga.pmx.parser.PmxUnifiedHandler;
import jp.sfjp.mikutoga.pmx.parser.PmxVertexHandler;

/**
 * サンプルのハンドラ。
 * これはユニットテストではない。
 * 必要に応じて要所でデバッガのブレークポイントを設定しておくと便利。
 */
public class DummyHandler implements PmxUnifiedHandler {

    public DummyHandler(){
        super();
    }

    @Override
    public void pmxParseStart(){
        System.out.println(";PMX parse start");
    }

    @Override
    public void pmxParseEnd(boolean hasMoreData){
        System.out.println(";PMX parse end");
        if(hasMoreData){
            System.out.println(";thre is unknown data below");
        }
    }

    @Override
    public void loopStart(ParseStage stage, int loops){
        if(stage==PmxVertexHandler.VERTEX_LIST){
            System.out.println(";Vertex"+loops+",位置_x,位置_y,位置_z,法線_x,法線_y,法線_z,UV_u,UV_v,エッジ倍率");
        }else if(stage==PmxFaceHandler.FACE_LIST){
            System.out.println(";Face"+loops+",頂点Index1,頂点Index2,頂点Index3");
        }else if(stage==PmxMaterialHandler.TEXTURE_LIST){
            System.out.println(";Texture"+loops+",ファイル名");
        }else if(stage==PmxMaterialHandler.MATERIAL_LIST){
            System.out.println(";Material"+loops+",材質名,name,"
                    + "拡散色_R,拡散色_G,拡散色_B,拡散色_A(非透過度),"
                    + "反射色_R,反射色_G,反射色_B,反射強度,"
                    + "環境色_R,環境色_G,環境色_B,flags,"
                    + "エッジ色_R,エッジ色_G,エッジ色_B,エッジ色_A,エッジサイズ");
        }else if(stage==PmxBoneHandler.BONE_LIST){
            System.out.println(";Bone"+loops+",ボーン名,ボーン名(英),位置_x,位置_y,位置_z,親Id,変形階層,種類,arrow id,arrow x,arrow y,arrow z");
        }else {
            System.out.println(";===== Loop start ("+stage+")===== * " + loops);
        }
    }

    @Override
    public void loopNext(ParseStage stage){
        System.out.println();
    }

    @Override
    public void loopEnd(ParseStage stage){
        if(stage!=PmxVertexHandler.VERTEX_LIST &&
                stage!=PmxFaceHandler.FACE_LIST &&
                stage!=PmxMaterialHandler.TEXTURE_LIST &&
                stage!=PmxMaterialHandler.MATERIAL_LIST &&
                stage!=PmxBoneHandler.BONE_LIST){
            System.out.println(";===== Loop end =====");
        }
    }

    @Override
    public void pmxHeaderInfo(float version, int encode, int uv) {
        System.out.println(";Header,Version,文字エンコード(0:UTF16/1:UTF8),追加UV数");
        System.out.println("Header,"+version+","+encode+","+uv);
    }

    @Override
    public void pmxModelName(String name, String nameE){
        System.out.println(";ModelInfo,モデル名,Model name,コメント,Comment");
        System.out.print("ModelInfo,\""  + name + "\",\"" + nameE+"\"");
    }

    @Override
    public void pmxModelDescription(String description, String descriptionE){
        System.out.print(",\"" + description+"\"");
        System.out.println(",\"" + descriptionE+"\"");
    }

    @Override
    public void pmxVertexPosition(float xPos, float yPos, float zPos){
        System.out.print("Vertex," + xPos + "," + yPos + "," + zPos);
    }

    @Override
    public void pmxVertexNormal(float xVec, float yVec, float zVec){
        System.out.print("," + xVec + "," + yVec + "," + zVec);
    }

    @Override
    public void pmxVertexUV(float uVal, float vVal){
        System.out.println("," + uVal + "," + vVal);
    }

    @Override
    public void pmxVertexExUV(byte i, float xVal, float yVal, float zVal, float wVal) {
        System.out.println("exUV["+i+"]: x,y,z,w= " + xVal + "," + yVal
                + "," + zVal + "," + wVal);
    }

    @Override
    public void pmxVertexWeight(int[] boneIds, float[] weights, float[] sdef) {
        for(int i=0;i<boneIds.length;i++){
            System.out.println("bone,weight  = "
                    + boneIds[i] + "," + weights[i]);
        }
        if(sdef!=null){
            System.out.println("SDEF!");
        }
    }

    @Override
    public void pmxVertexEdge(float edge){
        System.out.println("edge manitude = " + edge);
    }

    @Override
    public void pmxFaceTriangle(int vertexId_1,
                                      int vertexId_2,
                                      int vertexId_3){
        System.out.print("Face,"
                + vertexId_1 + "," + vertexId_2 + "," + vertexId_3);
    }

    @Override
    public void pmxTexture(String textureFile)  {
        System.out.println("Texture," + textureFile);
    }

    @Override
    public void pmxMaterialNames(String name, String nameE) {
        System.out.print("Material," + name+","+nameE);
    }

    @Override
    public void pmxMaterialDiffuse(float red, float green, float blue,
                                      float alpha ){
        System.out.print("," +red +"," +green +"," +blue +"," +alpha);
    }

    @Override
    public void pmxMaterialSpecular(float red, float green, float blue,
                                       float shininess){
        System.out.print("," +red +"," +green +"," +blue +"," +shininess);
    }

    @Override
    public void pmxMaterialAmbient(float red, float green, float blue){
        System.out.println("," +red +"," +green +"," +blue);
    }

    @Override
    public void pmxMaterialEdges(byte flags, float red, float green,
            float blue, float alpha, float thick) {
        System.out.println(","+flags+"," + red + ","
                + green + "," + blue+","+alpha+","+thick);
    }

    @Override
    public void pmxMaterialTexture(int textureId, int sphereId, byte mode) {
        System.out.println("material texture ="+textureId);
        System.out.println("sphere ["+mode+"] ID ="+sphereId);
    }

    @Override
    public void pmxMaterialToon(byte shared, int toonId) {
        System.out.println("toon ["+shared+"]="+toonId);
    }

    @Override
    public void pmxMaterialInfo(String script, int vertexNum) {
        System.out.println("script=" + script);
        System.out.println("surfaces=" + (vertexNum/3));
    }

    @Override
    public void pmxBoneInfo(String name, String nameE){
        System.out.print("Bone," + name+","+ nameE);
    }

    @Override
    public void pmxBonePosition(float xPos, float yPos, float zPos){
        System.out.print(","+xPos+","+yPos+","+zPos);
    }

    @Override
    public void pmxBoneStructure(int parentId, int depth) {
        System.out.print(","+parentId+","+depth);
    }

    @Override
    public void pmxBoneFlags(short flags) {
        System.out.print(","+flags);
    }

    @Override
    public void pmxBoneOffset(float offX, float offY, float offZ) {
        System.out.println(",-1,"+offX +"," +offY +","+offZ);
    }

    @Override
    public void pmxBoneArrowhead(int arrowId) {
        System.out.println(","+arrowId+",0,0,0");
    }

    @Override
    public void pmxBoneLink(int linkParent, float r) {
        System.out.println("linkParent = " + linkParent);
        System.out.println("link_ratio = " + r);
    }

    @Override
    public void pmxBoneRotateAxe(float x, float y, float z) {
        System.out.println("rotate axe="+x+","+y+","+z);
    }

    @Override
    public void pmxBoneLocalAxis(float xx, float xy, float xz, float zx, float zy, float zz){
        System.out.println("local x_axe="+xx+","+xy+","+xz);
        System.out.println("local z_axe="+zx+","+zy+","+zz);
    }

    @Override
    public void pmxBoneExtraParent(int extraParent) {
        System.out.println("Extra Parent="+extraParent);
    }

    @Override
    public void pmxBoneIKInfo( int targetId,
                           int depth, float weight ){
        System.out.println("IK target="+targetId);
        System.out.println("IK depth="+depth);
        System.out.println("IK weight="+weight);
    }

    @Override
    public void pmxIKChainInfo(int childId, float[] limit_rotation){
        System.out.println("chained bone = " + childId);
        if(limit_rotation!=null){
            for(int i=0;i<6;i++){
                System.out.println("rot["+i+"] = " + limit_rotation[i]);
            }
        }
    }
}
