/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.parser;

import java.io.IOException;
import java.io.InputStream;
import jp.sfjp.mikutoga.bin.parser.CommonParser;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.vmd.parser.VmdBasicHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdBasicParser;
import jp.sfjp.mikutoga.vmd.parser.VmdBoolHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdBoolParser;
import jp.sfjp.mikutoga.vmd.parser.VmdCameraHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdCameraParser;
import jp.sfjp.mikutoga.vmd.parser.VmdLightingHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdLightingParser;
import jp.sfjp.mikutoga.vmd.parser.VmdUnifiedHandler;

public class VmdParser {
    private final InputStream source;
    private final VmdBasicParser basicParser;
    private final VmdCameraParser cameraParser;
    private final VmdLightingParser lightingParser;
    private final VmdBoolParser boolParser;
    private VmdBasicHandler basicHandler = VmdUnifiedHandler.EMPTY;
    private boolean redundantCheck = false;

    public VmdParser(InputStream source) throws NullPointerException {
        if (source == null) {
            throw new NullPointerException();
        }
        this.source = source;
        CommonParser parser = new CommonParser(this.source);
        this.basicParser = new VmdBasicParser(parser);
        this.cameraParser = new VmdCameraParser(parser);
        this.lightingParser = new VmdLightingParser(parser);
        this.boolParser = new VmdBoolParser(parser);
    }

    public InputStream getSource() {
        return this.source;
    }

    public void setBasicHandler(VmdBasicHandler handler) {
        this.basicParser.setBasicHandler(handler);
        this.basicHandler = handler == null ? VmdUnifiedHandler.EMPTY : handler;
    }

    public void setCameraHandler(VmdCameraHandler cameraHandler) {
        this.cameraParser.setCameraHandler(cameraHandler);
    }

    public void setLightingHandler(VmdLightingHandler lightingHandler) {
        this.lightingParser.setLightingHandler(lightingHandler);
    }

    public void setBoolHandler(VmdBoolHandler boolHandler) {
        this.boolParser.setBoolHandler(boolHandler);
    }

    public void setRedundantCheck(boolean mode) {
        this.redundantCheck = mode;
        this.basicParser.setRedundantCheck(mode);
    }

    public void parseVmd() throws IOException, MmdFormatException {
        this.setRedundantCheck(this.redundantCheck);
        this.basicHandler.vmdParseStart();
        this.parseBody();
        boolean hasMoreData = this.lightingParser.hasMore();
        this.basicHandler.vmdParseEnd(hasMoreData);
    }

    private void parseBody() throws IOException, MmdFormatException {
        this.basicParser.parse();
        if (this.cameraParser.hasMore()) {
            this.cameraParser.parse();
            this.lightingParser.parse();
        }
        if (this.boolParser.hasMore()) {
            this.boolParser.parse();
        }
    }
}

