/**
 * @file
 * @brief Test for @malloc call error case.
 *
 * This is test for @malloc call error case of @asprintf and @vasprintf.
 */

#include <stdio.h>
#include <stdlib.h>
#include <cutter.h>

#include "asprintf.h"

static void *mock_malloc(size_t size __attribute__((unused)))
{
    return NULL;
}

/**
 * @brief Setup for @malloc call error case.
 *
 * This is a setup function for @malloc call error case.
 *
 * This function sets @c mockable_malloc to be mock function @c mock_malloc.
 *
 * The mock function @c mock_malloc always returns @c NULL.
 */
void cut_setup(void)
{
    mockable_malloc = mock_malloc;
}

/**
 * @brief Teardown for @malloc call error case.
 *
 * This is a teardown function for @malloc call error case.
 *
 * This function resets @c mockable_malloc.
 */
void cut_teardown(void)
{
    mockable_malloc = malloc;
}

/**
 * @brief Test for @malloc call error case.
 *
 * This is a test for @malloc call error case.
 *
 * In this case, @asprintf should return @c -1 and set pointer to be @c NULL.
 */
void test_malloc_error_case(void)
{
    char *str;
    int size = asprintf(&str, "ABCDEFG");
    cut_assert_equal_int(-1, size);
    cut_assert_null(str);
}
