/**
 * @file
 * @brief Test for first @vsnprintf call error case.
 *
 * This is test for first @vsnprintf call error case of @asprintf and
 * @vasprintf.
 */

#include <stdio.h>
#include <stdarg.h>
#include <cutter.h>

#include "asprintf.h"

static int mock_vsnprintf1(
    char * restrict str __attribute__((unused)),
    size_t size __attribute__((unused)),
    const char * restrict format __attribute__((unused)),
    va_list ap __attribute__((unused)))
{
    return -1;
}

/**
 * @brief Setup for first @vsnprintf call error case.
 *
 * This is a setup function for first @vsnprintf call error case.
 *
 * This function sets @c mockable_vsnprintf1 to be mock function
 * @c mock_vsnprintf1.
 *
 * The mock function @c mock_vsnprintf1 always returns @c -1.
 */
void cut_setup(void)
{
    mockable_vsnprintf1 = mock_vsnprintf1;
}

/**
 * @brief Teardown for first @vsnprintf call error case.
 *
 * This is a teardown function for first @vsnprintf call error case.
 *
 * This function resets @c mockable_vsnprintf1.
 */
void cut_teardown(void)
{
    mockable_vsnprintf1 = vsnprintf;
}

/**
 * @brief Test for first @vsnprintf call error case.
 *
 * This is a test for first @vsnprintf call error case.
 *
 * In this case, @asprintf should return @c -1 and set pointer to be @c NULL.
 */
void test_vsnprintf1_error_case(void)
{
    char *str;
    int size = asprintf(&str, "ABCDEFG");
    cut_assert_equal_int(-1, size);
    cut_assert_null(str);
}
