package shooting;
 
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
 
import org.lwjgl.input.Controller;
import org.lwjgl.input.Keyboard;
 
public class PcKeyboard extends GameController {
    //  デフォルトのキーコンフィグ
    private static final Map<Integer, Input>  DEFAULT_KEY_CONFIGS;
    static {
        Map<Integer, Input>   keyConfigs = new HashMap<Integer, Input>();
 
        keyConfigs.put(Keyboard.KEY_UP, Input.UP);
        keyConfigs.put(Keyboard.KEY_DOWN, Input.DOWN);
        keyConfigs.put(Keyboard.KEY_RIGHT, Input.RIGHT);
        keyConfigs.put(Keyboard.KEY_LEFT, Input.LEFT);
        keyConfigs.put(Keyboard.KEY_Z, Input.CIRCLE);
        keyConfigs.put(Keyboard.KEY_X, Input.CROSS);
        keyConfigs.put(Keyboard.KEY_F1, Input.SELECT);
 
        DEFAULT_KEY_CONFIGS = Collections.unmodifiableMap(keyConfigs);
    }
 
    public PcKeyboard() {
        super(DEFAULT_KEY_CONFIGS);
    }
 
    public void update() {
        //  キーボードの入力をすべて取得する
        while (Keyboard.next()) {
            boolean     isPressed = Keyboard.getEventKeyState();
            int         keyCode = Keyboard.getEventKey();
            Input       input = getInput(keyCode);
             
            //  キーボードからの入力で、論理キーの状態を更新する
            if (input != null) {
                setKeyStatus(input, isPressed);
            }
        }
    }
 
    @Override
    public String getName() {
        return "Keyboard";
    }
 
    @Override
    public boolean isOwner(Controller controller) {
        return false;
    }
     
}