package shooting;

import static org.lwjgl.opengl.GL11.GL_BACK;
import static org.lwjgl.opengl.GL11.GL_BLEND;
import static org.lwjgl.opengl.GL11.GL_CULL_FACE;
import static org.lwjgl.opengl.GL11.GL_DEPTH_TEST;
import static org.lwjgl.opengl.GL11.GL_FRONT_AND_BACK;
import static org.lwjgl.opengl.GL11.GL_LINES;
import static org.lwjgl.opengl.GL11.GL_MODELVIEW;
import static org.lwjgl.opengl.GL11.GL_NORMALIZE;
import static org.lwjgl.opengl.GL11.GL_PROJECTION;
import static org.lwjgl.opengl.GL11.GL_TEXTURE_2D;
import static org.lwjgl.opengl.GL11.glClear;
import static org.lwjgl.opengl.GL11.glClearColor;
import static org.lwjgl.opengl.GL11.glColor4f;
import static org.lwjgl.opengl.GL11.glCullFace;
import static org.lwjgl.opengl.GL11.glEnable;
import static org.lwjgl.opengl.GL11.glLoadIdentity;
import static org.lwjgl.opengl.GL11.glMatrixMode;
import static org.lwjgl.opengl.GL11.glOrtho;
import static org.lwjgl.opengl.GL11.glPolygonMode;
import static org.lwjgl.opengl.GL11.glPopMatrix;
import static org.lwjgl.opengl.GL11.glPushMatrix;
import static org.lwjgl.opengl.GL11.glRotatef;
import static org.lwjgl.opengl.GL11.glScalef;
import static org.lwjgl.opengl.GL11.glTranslatef;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.input.Keyboard;

import shooting.GameController.Input;
import net.chocolapod.lwjgfont.mig1p.Migmix1pRegularH28Font;
import net.chocolapod.lwjgfont.LWJGFont;

public class Main {
	//画面に関する変数の設定
	public static int         width = 1200;
	public static int         height =700;
	public static int         depth = 800;
	private String      title = "Shooting Lesson by Yosimasa";

	private static final int    MOVE_DISTANCE_PER_SECOND = 100;

	private long        time;
	private long        timeDelta;
	private long        fps;
	private long        calcedFps;
	private float scale;

	private TextureLoader   textureLoader;
	private LightManager    lightManager;

	//各キャラクターの変数の設定
	//自分のロケットなど
	public Model           myRocket;
	private long        actionTime;
	public static float       x;
	public static float       y;
	public static float rocketSize = 20;
	private float roll;
	private float rollInc = 1.5f;
	private float pitch;
	private float pitchInc = 0.5f;
	public int maxRocketNum = 3;
	public int myRocketNum = maxRocketNum;
	public static int aileronRoll;
	public int repeatLimit = 300;//エルロンロールするときのリミット（ミリ秒）
	private long keyRepeatTime;
	private float rocketScale;

	//敵
	public int enemyTypeNum = 3;
	public Model enemyModel[] = new Model[enemyTypeNum];
	public int enemyMax = 7;
	public ArrayList<Enemy> enemy = new ArrayList<Enemy>(); 
	public static EnemyGroup group;
	public static int createNum;
	public static int groupLife;
	public static int maxSpeed;
	
	//背景用の星
	private Model starTile[] = new Model[4];
	public int starNum = 150;
	public BackGroundStar star[] = new BackGroundStar[starNum];

	//自分の弾丸
	private Model bulletModel;
	public static int bulletNum = 4;
	public static Bullet bullet[] = new Bullet[bulletNum];
	public int bulletInterval = 10 ;
	public int bulletIntervalCount = 0;
	public static float bulletSize = 3;
	public boolean circleOn;

	//爆発
	public Model explosionModel[] = new Model[3];
	public ArrayList<Explosion> explosion = new ArrayList<Explosion>();
	public static int explosionStandardNum = 20;

	//コントローラー
	private List<GameController>  controllers;
	private int             controllerIndex;
	private GameController  controller;
	private GameController  keyboard;
	private boolean pauseOn;

	//効果音
	public static SoundManager2 soundManager;
	private int SOUND_SHOT;
	public static int SOUND_HIT;
	public static int SOUND_DAMAGED;
	public static int SOUND_BGM;

	// LWJGFont を呼び出す
	LWJGFont font = new Migmix1pRegularH28Font();
	//スコア
	public static int score;
	//ゲームの状態を示す変数
	public static int game;
	/* 0:ゲーム未開始
	 * 1:プレイ中
	 * 2:自分のロケットがやられた時
	 * 3:スタート前
	 * 4:ゲームオーバー
	 * 5:
	 * 6:
	 */
	//全体的な移動距離の調整
	public static int move;
	private boolean keyOn = false;
	
	
	//////////////////////////////////////////////////////////////////////////////
	///////////////////////////////イニシャライズ//////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////
	private void init() throws Exception {

		pauseOn = true;

		time = getMillisecond();
		fps = 0;

		textureLoader = new TextureLoader();

		lightManager = new LightManager();
		lightManager.initLight();

		//  ファイルのパス指定で画像を読み込む
		myRocket = ObjectLoader.load("MyRocket3.obj");
		myRocket.compile(textureLoader);

		enemyModel[0] = ObjectLoader.load("EnemyCommet.obj");
		enemyModel[0].compile(textureLoader);
		enemyModel[1] = ObjectLoader.load("T2virus.obj");
		enemyModel[1].compile(textureLoader);
		enemyModel[2] = ObjectLoader.load("EnemyRocket.obj");
		enemyModel[2].compile(textureLoader);


		starTile[0] =  ObjectLoader.load("StarTileYellow.obj");
		starTile[0].compile(textureLoader);
		starTile[1] =  ObjectLoader.load("StarTilePink.obj");
		starTile[1].compile(textureLoader);
		starTile[2] =  ObjectLoader.load("StarTileBlue.obj");
		starTile[2].compile(textureLoader);
		starTile[3] =  ObjectLoader.load("StarTileRed.obj");
		starTile[3].compile(textureLoader);

		bulletModel = ObjectLoader.load("Bullet.obj");
		bulletModel.compile(textureLoader);

		explosionModel[0] = ObjectLoader.load("Explosion_white.obj");
		explosionModel[0].compile(textureLoader);
		explosionModel[1] = ObjectLoader.load("Explosion_yellow.obj");
		explosionModel[1].compile(textureLoader);
		explosionModel[2] = ObjectLoader.load("Explosion_orange.obj");
		explosionModel[2].compile(textureLoader);

		//  MyRocketを初期化する
		actionTime = getMillisecond();
		x = width / 2;
		y = 50;
		roll = 0;
		aileronRoll = 0;
		rocketScale = 25;

		//  コントローラーを用意する
		controllers = new ArrayList<GameController>();
		try {
			Controllers.create();
			for (int i = 0; i < Controllers.getControllerCount(); i++) {
				Controller  controller = Controllers.getController(i);

				System.out.println("Detected controller(" + i + "): " + controller.getName());
				controllers.add(new JoyStick(controller));
			}
		} catch (LWJGLException e) {
			e.printStackTrace();
		}
		keyboard = new PcKeyboard();
		controllers.add(keyboard);

		controllerIndex = controllers.size() - 1;
		controller = controllers.get(controllerIndex);

		//敵のグループを設定
		createNum = 5;
		groupLife = 500;
		maxSpeed = 4;
		group = new EnemyGroup(createNum, groupLife, maxSpeed);
		

		//弾丸を初期化
		for (int i=0; i<bulletNum; i++){
			bullet[i] = new Bullet();
		}

		//背景の星を初期化
		for (int i=0; i<starNum; i++){
			star[i] = new BackGroundStar();
		}

		//サウンドマネージャーはスペースインベーダーのチュートリアルからいただいてきた。
		// create our sound manager, and initialize it with 7 channels
		// 1 channel for sounds, 6 for effects - this should be enough
		// since we have a most 4 shots on screen at any one time, which leaves
		// us with 2 channels for explosions.
		soundManager = new SoundManager2();
		soundManager.initialize(8);

		// load our sound data
		//効果音は「sfxr」で作った。
		SOUND_SHOT   = soundManager.addSound("sounds/"+ "shoot4.wav");
		SOUND_HIT    = soundManager.addSound("sounds/"+ "explosion.wav");
		SOUND_DAMAGED = soundManager.addSound("sounds/"+ "myExplosion.wav");
		SOUND_BGM = soundManager.addSound("sounds/"+ "cosmoRunning.wav");
	}

	////////////////////////////////////////////////////////////////////////
	////////////////////////////////////スタート////////////////////////////
	///////////////////////////////////////////////////////////////////////
	public void start() {
		try {
			//  ウインドウを生成する
			Display.setDisplayMode(new DisplayMode(width, height));
			Display.setTitle(title);
			Display.create();
		} catch(LWJGLException e) {
			e.printStackTrace();
			return;
		}

		try {
			//  OpenGL の初期設定

			//  オフスクリーンを初期化する際の背景色を指定する
			glClearColor(0f, 0f, 0f, 1f);

			//  テクスチャーを有効化する
			glEnable(GL_TEXTURE_2D);

			//  アルファブレンドを有効化する
			glEnable(GL_BLEND);

			//  ポリゴンの表示面を表のみに設定する
			glEnable(GL_CULL_FACE);
			glCullFace(GL_BACK);

			//  カメラ用の設定変更を宣言する
			glMatrixMode(GL_PROJECTION);
			//  設定を初期化する
			glLoadIdentity();
			//  視体積（目に見える範囲）を定義する
			glOrtho(0, width, 0, height, 0, depth);

			//  物体モデル用の設定変更を宣言する
			glMatrixMode(GL_MODELVIEW);

			//  デプステストを有効にする
			glEnable(GL_DEPTH_TEST);

			init();
			game = 0;
			///////////////////////////////////////////////////////////////////////////////////////
			////////////////////////////////実質的メインループ//////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////
			while (!Display.isCloseRequested()) {
				//  オフスクリーンを初期化する
				glClear(GL11.GL_COLOR_BUFFER_BIT | GL11.GL_DEPTH_BUFFER_BIT);

				//  キー入力を処理する
				updateControllers();

				//  FPS を計算する
				calcFps();

				switch(game){
				/* 0:ゲーム未開始
				 * 1:プレイ中
				 * 2:自分のロケットがやられた時
				 * 3:スタート前
				 * 4:ゲームオーバー
				 * 5:
				 * 6:
				 */
				case 0://ゲームタイトル
					gameTitle();

					break;
				case 1://ゲームのプレイ中である
					playing();

					break;
				case 2://やられました
					damaging();

					break;
				case 3://戦闘開始
					hereWeGo();

					break;
				case 4://ゲームオーバー
					gameover();
					break;
				}//switch
				//  オフスクリーンをスクリーンに反映する
				Display.update();

			}//while
			/////////////////////////////////////////////////////////////////////////////////////////
		} catch(Exception e) {
			e.printStackTrace();
		} finally {
			terminate();
			Display.destroy();
		}
	}//end of start()


	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////各オブジェクトの移動など//////////////////
	///////////////////////////////////////////////////////////////////////////
	private void update(){
		//時間調整に必要な処理
		long    now = getMillisecond();
		long    delta = now - actionTime;
		move = (int)(MOVE_DISTANCE_PER_SECOND * (delta / 1000f));
		actionTime = now;
		Display.setTitle(title + "(" + calcedFps + "fps)");
		//  FPS を調整する
		Display.sync(60);
	}
	//////////////////////４：ゲームオーバー///////////////////////
	private void gameover() {
		update();
		starUpdate();

		render();
		renderStars();

		renderGameOver();

		if (Keyboard.isKeyDown(Keyboard.KEY_F5)){
			game = 0;//タイトルにする。
		}
	}

	//////////////////////３：戦闘開始////////////////////////
	private void hereWeGo() {
		update();
		starUpdate();

		render();
		renderStars();
		renderText();

		x = width / 2;
		y = 50;
		roll = 0;

		game = 1;
		soundManager.playSound(SOUND_BGM);
		
	}
	//////////////////////０：ゲームタイトル////////////////////////////
	private void gameTitle() {
		update();
		starUpdate();

		render();
		renderStars();
		renderTitle();

		//F2でゲーム開始
		if (Keyboard.isKeyDown(Keyboard.KEY_F2)){
			//ゲームをリセットする。
			score = 0;
			myRocketNum = maxRocketNum;
			createNum = 5;
			groupLife = 500;
			maxSpeed = 4;
			enemyMax = 7;

			game = 3;//ゲームを始める
			
		}
	}

	//////////////////////２：やられました//////////////////////////////////
	private void damaging() {
		update();

		starUpdate();
		explosionUpdate();
		bulletUpdate();
		enemyUpdate();
		
		soundManager.stopSound(SOUND_BGM);

		boolean explodeEnd;
		explodeEnd = true;
		for (int i=0; i<enemy.size(); i++){
			if (enemy.get(i).state != 0) {
				explodeEnd = false;
			}
		}
		for (int i=0; i<explosion.size(); i++){
			if (explosion.get(i).life > 0) {
				explodeEnd = false;
			}
		}
		if (explodeEnd){//爆発がすべて終わり、敵がすべて画面の外へでたら・・・
			myRocketNum --;
			if (myRocketNum ==0 ){
				game = 4;//残機が０なら「４：ゲームオーバー」にする。
			}else game = 3;//ゲームを「３：戦闘開始」にする。
		}

		//  オフスクリーンに描画する
		render();

		renderEnemies();
		renderExplosion();
		renderBullets();
		renderStars();
		renderText();

	}
	//////////////////////１：ゲーム中//////////////////////////////////
	private void playing() throws IOException {
		//F1キーでポーズする
		if (Keyboard.isKeyDown(Keyboard.KEY_F1) ){
			keyOn = true;
		}//押されて離したらポーズを切り替える
		if (!(Keyboard.isKeyDown(Keyboard.KEY_F1)) && keyOn ){
			pauseOn = !pauseOn;
			keyOn = false;
			if ( soundManager.isPlayingSound() ){
				soundManager.pauseSound(SOUND_BGM);
			}else soundManager.playSound(SOUND_BGM);
		}

		update();//ポーズ中でもこれとrender()は呼び出しかけないとだめ。

		if (pauseOn){
			//各種オブジェクトの描画位置を計算する。
			starUpdate();
			explosionUpdate();
			bulletUpdate();
			enemyUpdate();
			rocketUpdate();
			groupUpdate();

			if ( !(soundManager.isPlayingSound()) ){
				soundManager.playSound(SOUND_BGM);
			}
			//ゲーム開始時
			//createNum = 5;
			//groupLife = 500;
			//maxSpeed = 4;
			if ( score > 1000){
				createNum = 6;
				groupLife = 400;
				maxSpeed = 5;
			}
			if ( score > 2000){
				createNum = 8;
				groupLife = 300;
				maxSpeed = 7;
			}
			if ( score > 3000){
				createNum = 10;
				groupLife = 300;
				maxSpeed = 8;
				enemyMax = 10;
			}
			if ( score > 4000){
				createNum = 12;
				groupLife = 300;
				maxSpeed = 10;
				enemyMax = 15;
			}
			if ( score > 5000){
				createNum = 14;
				groupLife = 200;
				maxSpeed = 12;
				enemyMax = 20;
			}
		}

		//  オフスクリーンに描画する
		render();

		//if (pauseOn){//ポーズしている時も画面は更新し続けるのか？否か？
		renderMyRocket();
		renderEnemies();
		renderExplosion();
		renderBullets();
		renderStars();
		renderText();
		//}

	}// end of playing
	//////////////////////敵のグループの計算処理////////////////////////////
	private void groupUpdate() {
		int num, life;
		num = group.getNum();
		life = group.getLife();
		if (num == 0 && life == 0){
			group = null;
			group = new EnemyGroup(createNum, groupLife, maxSpeed);
		}else group.decLife();
	}
	/////////////////MyRocketの移動（計算）処理////////////////////////
	private void rocketUpdate() {
		
		long now;//エルロンロールのための時間測定に使用。
		
		//  GameController.isPressing() ではなく、最初に押して離されたキーをイベントとして取得する
		if (keyboard.getKeyEvent() == Input.SELECT) {
			controllerIndex = (controllerIndex + 1) % controllers.size();
			controller = controllers.get(controllerIndex);
		}

		//  移動の方向と大きさを判定する
		int moveSize = 5;
		int moveX = 0;
		int moveY = 0;

		//上下移動
		if (controller.isPressing(Input.UP)) {
			moveY = 1;
			pitch = pitch - pitchInc;
			if (pitch < -10) pitch = -10;

		} else if (controller.isPressing(Input.DOWN)) {
			moveY = -1;
			pitch = pitch + pitchInc;
			if (pitch > 10) pitch = 10;

		} else {
			if (pitch <0){
				pitch = pitch + pitchInc;
			}else if (pitch >0){
				pitch = pitch - pitchInc;
			}
		}

		//左右移動
		//右キー入力があった
		if (controller.isPressing(Input.RIGHT)) {
			moveX = 1; 
			roll = roll + rollInc;//通常のロール
			if ( roll > 80 && aileronRoll != 3 ) roll = 80;
			
			now = getMillisecond();
			if (aileronRoll == 0) aileronRoll = 1;//一度目のキー入力
			if (aileronRoll == 2 && now - keyRepeatTime < repeatLimit ){//右エルロンロール開始
				aileronRoll = 3;
			}
			if (aileronRoll == 3){//右エルロンロールしている。
				moveX = 2;
				roll = roll + rollInc * 3;
				if (roll > 90) roll = -roll;
				if ( rocketScale < 40) rocketScale = rocketScale + 2;
			}
			if (aileronRoll < 0) {
				aileronRoll = 0;//左キーのロールは解除する。
			}
			
		//左キー入力があった。	
		} else if (controller.isPressing(Input.LEFT)) {
			moveX = -1;
			roll = roll - rollInc;
			if ( roll < -80 && aileronRoll != -3 ) roll = -80;

			now = getMillisecond();
			if (aileronRoll == 0) aileronRoll = -1;//一度目のキー入力
			if (aileronRoll == -2 && now - keyRepeatTime < repeatLimit ){//左エルロンロール開始
				aileronRoll = -3;
			}
			if (aileronRoll == -3){//左エルロンロールしている。
				moveX = -2;
				roll = roll - rollInc * 3;
				if (roll < -90)roll = -roll;
				if ( rocketScale < 40) rocketScale = rocketScale + 2;
			}
			if (aileronRoll > 0) {
				aileronRoll = 0;//右キーのロールは解除する。
			}
		//キーがおされていない
		} else {
			if (Math.abs(aileronRoll) == 3){//２度めのキーが離されたのでエルロンロールが終了したと判断
				aileronRoll = 0;
			}
			
			if (Math.abs(aileronRoll) == 1 ){//一度目のキーが離されたと判断
				aileronRoll = aileronRoll * 2;
				keyRepeatTime = getMillisecond();//時間を測り始める
			}
			now = getMillisecond();
			if (now - keyRepeatTime > repeatLimit ) aileronRoll = 0;
			
			if (roll <0) {
				roll = roll + rollInc;
			}else if (roll >0) {
				roll = roll - rollInc;	
			}
		}
		if (rocketScale > 25 && Math.abs(aileronRoll) != 3 ) rocketScale = rocketScale -2;//スケールを元に戻そうとする。
		///////弾丸発射////////
		//circleOn によってボタンのおしっぱなしができないようにしている。
		//エルロンロールしているときは弾が撃てない。
		if (controller.isPressing(Input.CIRCLE) && !circleOn && Math.abs(aileronRoll) != 3 ) {//キーボードでは「ｚ」
			for (int i=0; i<bulletNum; i++){
				if (!bullet[i].bulletState && bulletIntervalCount > bulletInterval){
					bullet[i].Shoot();
					bulletIntervalCount = 0;
					soundManager.playEffect(SOUND_SHOT);
					circleOn = true;
				}
			}
		}
		if (!controller.isPressing(Input.CIRCLE)) {
			circleOn = false;
		}
		bulletIntervalCount++;
		if (x + (moveX * move * moveSize) >0 && x + (moveX * move * moveSize) < width ){
			x += (moveX * move * moveSize);
		}
		if (y + (moveY * move * moveSize) >0 && y + (moveY * move * moveSize) < height){
			y += (moveY * move * moveSize);
		}
	}
	/////////////////////エイリアンの移動処理/////////////////////////////
	private void enemyUpdate() {

		for (int i=0; i<enemy.size(); i++){

			switch (enemy.get(i).state){
			case 0:
				break;
			case 1://活動中である。
				enemy.get(i).update();
				break;

			case 2://たまに当たった
				soundManager.playEffect(SOUND_HIT);
				score = score + enemy.get(i).score;

				/////////爆発を発生させる///////
				int m, n;
				n = explosionStandardNum;
				for (int j=0; j<n; j++){
					m = (int)(Math.random()*30)+10;
					explosion.add(new Explosion(enemy.get(i).x, enemy.get(i).y, 
							enemy.get(i).vx, enemy.get(i).vy, m , 0));
				}
				enemy.remove(i);

				break;

			case 3://自分のロケットと当たった
				soundManager.playEffect(SOUND_DAMAGED);
				game = 2;//「やられました」の処理にする。

				/////////大爆発を発生させる///////
				n = explosionStandardNum + 20;

				for (int j=0; j<n; j++){
					m = (int)(Math.random()*60)+20;
					explosion.add(new Explosion(enemy.get(i).x, enemy.get(i).y, 0, 0, m , 100));
				}
				//ロケットの座標をマイナスにしてロケットが爆発している時は衝突しないようにする。
				x = -100;
				y = -100;

				enemy.remove(i);

				break;

			case 4://ロケットが破壊されたときは画面の外へでたらエイリアンは消滅する
				enemy.remove(i); 

				break;
			}//end of switch
		}//end of for i
		//エイリアンを発生させるか？
		if (group.Appear() && enemy.size() < enemyMax ){ 
			enemy.add(new Enemy(group));
		}
	}
	//////////////////////弾丸の移動処理///////////////////////
	private void bulletUpdate() {
		for (int i=0; i<bulletNum; i++){
			if (bullet[i].bulletState){
				bullet[i].Update();
			}
		}

	}
	///////////////////////爆発の移動処理////////////////////////////
	private void explosionUpdate() {
		for (int i=0; i<explosion.size(); i++){
			if (explosion.get(i).life > 0 ){
				explosion.get(i).update();
			}
			else{
				explosion.remove(i);
			}
		}// for i
	}
	///////////////////////背景の星の移動処理////////////////////////
	private void starUpdate() {

		for (int i=0; i<starNum; i++){
			star[i].updateStar();
		}
	}
	///////////////////////////////////////////////////////////////////////////
	//////////////////////////////画面を更新する////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	private void render() {

		glPolygonMode(GL_FRONT_AND_BACK, GL_LINES);

		glEnable(GL_NORMALIZE);

		//  設定を初期化する
		glLoadIdentity();

		lightManager.light();
	}
	////////////////////ゲームタイトルの描画////////////////////////
	private void renderTitle() {
		// フォントの色を設定する
		font.setColor(1f, 0f, 0f);//うまく行ってない。全部白になってる。
		glTranslatef(0, 0, depth / -2f);
		glColor4f(1f, 0f, 0f, 1f);
		// LWJGFont で文字列を表示する
		try {
			String string;
			string = "よしまさのシューティングゲーム";
			font.drawString(string, width/2 -200, height/2, 0);
			string = "F2を押してください";
			font.drawString(string, width/2 -150,height/2 -100, 0);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	///////////////////ゲームオーバーの描画///////////////////
	private void renderGameOver() {

		// フォントの色を設定する
		font.setColor(1f, 0f, 0f);//うまく行ってない。全部白になってる。
		glTranslatef(0, 0, depth / -2f);
		glColor4f(1f, 0f, 0f, 1f);
		// LWJGFont で文字列を表示する
		try {
			String string;
			string = "ゲームオーバー";
			font.drawString(string, width/2 -100, height/2, 0);
			string = "スコア："+ score+ "点でした";
			font.drawString(string, width/2 -150,height/2 -50, 0);
			string = "F5を押してください";
			font.drawString(string, width/2 -150,height/2 -100, 0);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	///////////////////////スコアなどテキスト描画///////////////////////
	private void renderText() {

		// フォントの色を設定する
		font.setColor(1f, 0f, 0f);//うまく行ってない。全部白になってる。
		glTranslatef(0, 0, depth / -2f);
		glColor4f(1f, 0f, 0f, 1f);
		// LWJGFont で文字列を表示する
		try {
			String scoreString;
			scoreString = "スコア："+ Integer.toString(score)+"  ロケット："+ Integer.toString(myRocketNum) ;

			font.drawString(scoreString, 10, 10, 0);

		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	///////////////////////////星を描く/////////////////////////////////
	private void renderStars() {

		for (int i=0; i<starNum; i++){
			glPushMatrix();

			glTranslatef(0, 0, depth / -2f);
			glTranslatef(star[i].starX, star[i].starY,10);
			glRotatef(0, 1, 0, 0);
			scale = 2f;
			glScalef(scale, scale, scale);
			glColor4f(1f, 1f, 1f, 1f);
			starTile[star[i].starColorNum].render();

			glPopMatrix();
		}
	}
	//////////////////////////弾丸を描く/////////////////////////////////
	private void renderBullets() {
		//これから描画する物体は自分で発光する
		lightManager.emissionOn();

		for(int i=0; i<bulletNum; i++){
			if (bullet[i].bulletState){
				glPushMatrix();

				glTranslatef(0, 0, depth / -2f);
				glTranslatef(bullet[i].bulletX, bullet[i].bulletY,100);
				glRotatef(0, 1, 0, 0);
				scale = 10f;
				glScalef(scale, scale, scale);
				glColor4f(1f, 1f, 1f, 1f);
				bulletModel.render();

				glPopMatrix();
			}
		}
		//自分で発光するのをやめる
		lightManager.emissionOff();
	}
	///////////////////////////爆発を描く/////////////////////////////////////
	private void renderExplosion() {

		//これから描画する物体は自分で発光する
		lightManager.emissionOn();

		for (int i=0; i<explosion.size(); i++){
			//  行列スタックに現在の行列を退避させ、新しい行列に対してモデルビュー変換を開始する
			glPushMatrix();

			//  画面中央の座標を (0, 0, 0) とするよう座標系を移動する
			glTranslatef(0, 0, depth / -2f);

			glTranslatef(explosion.get(i).x
					,explosion.get(i).y
					,100);
			//glRotatef((int)(Math.random()*90), 1, 1, 0);

			scale = explosion.get(i).size;
			glScalef(scale, scale, scale);

			glColor4f(1f, 1f, 1f, 1f);

			explosionModel[explosion.get(i).color].render();

			//  行列スタックからもとの行列を取り出す
			glPopMatrix();
		}
		//自分で発光するのをやめる
		lightManager.emissionOff();
	}
	/////////////////////////////エイリアンを描く//////////////////////////////////////
	private void renderEnemies() {


		for (int i=0; i< enemy.size(); i++){
			if (enemy.get(i).state == 1){//活動中であるなら描画する
				//  行列スタックに現在の行列を退避させ、新しい行列に対してモデルビュー変換を開始する
				glPushMatrix();

				//  画面中央の座標を (0, 0, 0) とするよう座標系を移動する
				glTranslatef(0, 0, depth / -2f);
				glTranslatef(enemy.get(i).x,enemy.get(i).y,100);

				glRotatef(enemy.get(i).direction , 0, 0, 1);
				glRotatef(enemy.get(i).roll, 0, 1, 0);
				

				scale = 25f;
				glScalef(scale, scale, scale);

				glColor4f(1f, 1f, 1f, 1f);

				enemyModel[enemy.get(i).type].render();

				//  行列スタックからもとの行列を取り出す
				glPopMatrix();
			}//end if
		}//for i
	}
	////////////////////////////////////自分のロケットを描く///////////////////////////////
	private void renderMyRocket() {

		//  行列スタックに現在の行列を退避させ、新しい行列に対してモデルビュー変換を開始する
		glPushMatrix();

		//  画面左下の座標を (0, 0, 0) とするよう座標系を移動する
		glTranslatef(0, 0, depth / -2f);
		glTranslatef(x,y,100);

		glRotatef(roll, 0, 1, 0);
		glRotatef(pitch, 1, 0, 0);

		scale = rocketScale;
		glScalef(scale, scale, scale);

		glColor4f(1f, 1f, 1f, 1f);

		myRocket.render();
		//  行列スタックからもとの行列を取り出す
		glPopMatrix();


	}
	///////////////////////FPSを計算する////////////////////////
	private void calcFps() {
		long    now = getMillisecond();

		//  前のフレームからの経過時間を求め、timeDelta に足す
		timeDelta += now - time;
		time = now;

		if (1000 <= timeDelta) {
			//  timeDelta が 1 秒を上回ったら、FPS をリセットする
			timeDelta -= 1000;
			calcedFps = fps;
			fps = 1;
		} else {
			fps++;
		}
	}
	////////////////////////コントローラーの状況をアップデート///////////////////
	private void updateControllers() {
		//  すべてのジョイパッドの入力を取得する
		Controllers.poll();

		while (Controllers.next()) {
			//  現在利用しているジョイパッドのイベントであれば、入力状況を更新する
			if (controller.isOwner(Controllers.getEventSource())) {
				controller.update();
			}
		}

		//  キーボードは常に入力状況を更新する
		keyboard.update();
	}
	//////////////////////////各３Dモデルを破棄する//////////////////////
	private void terminate() {
		if (myRocket != null) myRocket.dispose();
		for (int i=0; i<enemyTypeNum; i++){
			if (enemyModel[i] != null) enemyModel[i].dispose();
		}
		for (int i=0; i<4 ; i++){
			if (starTile[i] != null ) starTile[i].dispose();
		}
		for (int i=0; i<3 ; i++){
			if (explosionModel[i] != null) explosionModel[i].dispose();
		}
		soundManager.destroy();
	}
	////////////////////////現在の時間をミリ秒で返す///////////////////////////
	public static long getMillisecond() {

		return (Sys.getTime() * 1000) / Sys.getTimerResolution();
	}
	/////////////////////////////////////////////////////////////////////////
	public static void setLibraryPath(String path) throws Exception {
	    System.setProperty("java.library.path", path);
	 
	    //set sys_paths to null
	    final Field sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
	    sysPathsField.setAccessible(true);
	    sysPathsField.set(null, null);
	    //System.loadLibrary("natives");
	}
	/////////////////////////main////////////////////////////////
	public static void main(String[] args) throws Exception {
		/*String s;
		s = System.getProperty("user.dir") + File.separator + "natives";
		setLibraryPath(s);*/
		
		//System.setProperty("java.library.path", "natives");

	    //Extracted from Distributing Your LWJGL Application
	    //System.setProperty("org.lwjgl.librarypath", new File("natives").getAbsolutePath());
	    
	    //Your sourcecode for starting the display
		new Main().start();
	}
}