package shooting;
 
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
 
import org.lwjgl.input.Controller;
 
public class JoyStick extends GameController {
    //  デフォルトのキーコンフィグ
    private static final Map<Integer, Input>  DEFAULT_KEY_CONFIGS;
    static {
        Map<Integer, Input>   keyConfigs = new HashMap<Integer, Input>();
 
        keyConfigs.put(3, Input.CIRCLE);
        keyConfigs.put(2, Input.CROSS);
        DEFAULT_KEY_CONFIGS = Collections.unmodifiableMap(keyConfigs);
    }
 
    private final Controller    controller;
 
    public JoyStick(Controller controller) {
        super(DEFAULT_KEY_CONFIGS);
        this.controller = controller;
    }
 
    @Override
    public void update() {
        //  ボタンの入力状態を反映する
        for (int keyCode: keyCodes()) {
            Input   input = getInput(keyCode);
            boolean isPressed = false;
 
            if (keyCode < controller.getButtonCount()) {
                isPressed = controller.isButtonPressed(keyCode);
            }
            setKeyStatus(input, isPressed);
        }
         
        float   xAxis = controller.getXAxisValue();
        float   yAxis = controller.getYAxisValue();
 
        //  アナログスティックの X 軸方向の入力状態を反映する
        boolean isLeftPressing = false;
        boolean isRightPressing = false;
        if (xAxis < 0) {
            isLeftPressing = true;
        } else if (0 < xAxis) {
            isRightPressing = true;
        }
        setKeyStatus(Input.LEFT, isLeftPressing);
        setKeyStatus(Input.RIGHT, isRightPressing);
 
        //  アナログスティックの Y 軸方向の入力状態を反映する
        boolean isUpPressing = false;
        boolean isDownPressing = false;
        if (yAxis < 0) {
            isUpPressing = true;
        } else if (0 < yAxis) {
            isDownPressing = true;
        }
        setKeyStatus(Input.UP, isUpPressing);
        setKeyStatus(Input.DOWN, isDownPressing);
    }
 
    public boolean isOwner(Controller controller) {
        return (this.controller == controller);
    }
 
    @Override
    public String getName() {
        return controller.getName();
    }
 
}