package shooting;

public class Enemy {

	public float x,y;
	public float vx,vy;
	public float direction, maxSpeed;
	public float size;
	public float roll,yaw,pitch;//yow：縦回転（ｙ軸）、roll：横回転（ｚ軸）、pitch：上下回転（ｘ軸）
	public float rollSpeed ;//縦回転するスピード
	public float yawSpeed ;//回転するスピード
	public float pitchSpeed ;//ピッチするスピード
	public int score;//そのエイリアンのスコア
	public float r, s, t;//内部で使用する汎用変数
	
	//typeはエイリアンのタイプを表す
	public int typeNum;
	public int type;
	//stateはエイリアンの状態を表す。
	public int state;
	public int apper;
	public int apperCount;
	public int apperLimit = 5;//〜回画面下に消えたらそのエイリアンは削除する。
	
	//コンストラクタ（EnemyGroupから作る）
	public Enemy(EnemyGroup g){
		
		type = g.createType;
		//0…コメット型
		//1…T2ウイルス型
		//2…ロケット型
		
		apper = g.appearPattern;
		//0…ランダムに発生
		//1…隊列を組んで発生
		
		state = 1;
		//0：まだ出現していない
		//1：画面に出現中
		//2：弾丸があたった
		//3：自分のロケットにあたった
		//4：画面外に出て消滅させるとき（ロケットがやられたあとなど）
		
		maxSpeed = g.maxSpeed;
		
		apperCount = 0;//画面下に消えたカウント。
		
		switch (type){
		case 0://コメット型
			switch (apper){
			//ランダムに発生させるときはここで座標やベクトルを定める。
			//隊列を組むときはグループオブジェクトに保存してある座標とベクトルを使う。
			case 0://random
				x = (float)(Math.random()*Main.width);//出現する場所はランダムに
				y = Main.height+30;//画面の少し上から出現する。
				vx = (float)(Math.random()* maxSpeed * 2)-maxSpeed;//横移動量は−５〜５の間で
				vy = (-maxSpeed /2) + (float)(-maxSpeed * Math.random());//落ちてくるスピード
				break;
			case 1://make a row
				x = g.x;
				y = g.y;
				vx = g.vx;
				vy = g.vy;
				break;
			}
			
			roll = (float)(Math.random()*360);
			yaw = 0;
			rollSpeed = 3;//縦回転する。
			yawSpeed = 0;//横回転しない。
			
			size = 20;
			score = 10;
			
			break;
			
		case 1://T2ウイルスタイプ
			switch (apper){
			case 0://random
				x = (float)(Math.random()*Main.width);//出現する場所はランダムに
				y = Main.height+30;//画面の少し上から出現する。
				vx = (float)(Math.random()*maxSpeed *2)-maxSpeed;//横移動量は−５〜５の間で
				vy = (-maxSpeed /2) + (float)(-maxSpeed * Math.random());//落ちてくるスピード
				break;
			case 1://make a row
				x = g.x;
				y = g.y;
				vx = g.vx;
				vy = g.vy;
				s =  g.s;
				break;
			}
			
			roll = (float)(Math.random()*360);
			yaw = 0;
			rollSpeed = 3;
			yawSpeed = 0;
			
			size = 20;
			score = 20;
			break;
		case 2://ロケットタイプ
			switch (apper){
			case 0://random
				x = (float)(Math.random()*Main.width);//出現する場所はランダムに
				y = Main.height+30;//画面の少し上から出現する。
				vx = 0;
				vy = (-maxSpeed /2) + (float)(-maxSpeed * Math.random());//落ちてくるスピード
				s = (float)(Main.x - x);//加速度。
				
				break;
			case 1://make a row
				x = g.x;
				y = g.y;
				vx = 0;
				vy = -maxSpeed;
				s = (float)(Main.x - x);//加速度。
				break;
			}
			
			roll = (float)(Math.random()*360);
			yaw = 0;
			rollSpeed = 3;
			yawSpeed = 0;
			
			size = 20;
			score = 20;
			break;
		}
	}
	
	public int update(){
		
		//衝突判定
		//自分のロケットとの衝突判定
		float distance;
		distance = Distance(this.x, this.y, Main.x, Main.y);
				
		if ( distance < this.size + Main.rocketSize && Math.abs(Main.aileronRoll) != 3){
		//距離がこの敵のサイズとロケットのサイズの合計より小さいなら衝突。エルロンロール中は判定しない。
		//自分のロケットが破壊された処理
			this.state = 3;
		}//end if
		
		//弾丸との衝突判定
		
		for ( int i=0; i<Main.bulletNum; i++){
			if (Main.bullet[i].bulletState){//弾丸は発射されている時にのみ判定をする。
				distance = Distance(this.x, this.y, Main.bullet[i].bulletX, Main.bullet[i].bulletY);
				
				if (distance < this.size + Main.bulletSize){
					//敵自身が破壊された処理
					this.state = 2;//2:破壊された（弾があたった）
					Main.bullet[i].bulletState = false;//bulletを消す。
				}//end if(弾があたったか？)
			}//end if(弾は発射されているか？)
		}//for i
		//移動処理
		
		boolean screenOut = false;
		
		switch (type){
		
		case 0:////////////////////////////彗星型/////////////
			
			this.x = this.x + this.vx * Main.move;
	        if (this.x > Main.width){
	        	this.x = 0;
	        	screenOut = true;
	        }
	        if (this.x < 0-this.size){
	        	this.x = Main.width;
	        	screenOut = true;
	        }
	        this.y = this.y + this.vy * Main.move;
	        if (this.y < 0 -this.size -100){
	        	this.y = Main.height + this.size;
	        	this.apperCount ++;
	        	screenOut = true;
	        }
	        
	        this.roll = this.roll + this.rollSpeed;
	        if ( this.roll > 360){
	        	this.roll = this.roll - 360;
	        }
	        this.direction = DegAtan(this.vx, this.vy) +90;
	        //if (this.direction == -1f) this.direction = 180;
	        if (this.direction > 360) this.direction = this.direction - 360;
	        
	        break;
	        
		case 1:////////////////////////////T2ウイルス型/////////////
			
			r ++;
			if (r > 10800 ) r -= 10800;
			
			this.vx = (float)(Math.sin(r/30) * 5) + s;
			if (this.vx > maxSpeed) this.vx = maxSpeed;
			if (this.vx < -maxSpeed) this.vx = -maxSpeed;
			
			this.x = this.x + this.vx * Main.move;
	        if (this.x > Main.width){
	        	this.x = 0;
	        	screenOut = true;
	        }
	        if (this.x < 0-this.size){
	        	this.x = Main.width;
	        	screenOut = true;
	        }
	        this.y = this.y + this.vy * Main.move;
	        if (this.y < 0 -this.size -100){
	        	this.y = Main.height + this.size;
	        	this.apperCount ++;
	        	screenOut = true;
	        }
	        
	        this.roll = this.roll + this.rollSpeed;
	        if ( this.roll > 360){
	        	this.roll = this.roll - 360;
	        }
	        break;
		case 2:////////////////////////////ロケット型/////////////
			
			this.x = this.x + this.vx * Main.move;
			this.vx = this.vx + this.s/7000;//ちょっとずつ向きを変える
			if (this.vx < -maxSpeed) this.vx = -maxSpeed;
			if (this.vx > maxSpeed ) this.vx = maxSpeed;
			
	        if (this.x > Main.width){
	        	this.x = 0;
	        	screenOut = true;
	        }
	        if (this.x < 0-this.size){
	        	this.x = Main.width;
	        	screenOut = true;
	        }
	        this.y = this.y + this.vy * Main.move;
	        if (this.y < 0 -this.size -100){
	        	if ( this.apper == 1) {
	        		this.x = (this.x + Main.width / 2) % Main.width;
	        	}
	        	this.y = Main.height + this.size;
	        	this.vx = 0;
	        	this.s = (int)(Main.x - x);
	        	this.apperCount ++;
	        	screenOut = true;
	        }
	        
	        this.roll = this.roll + this.rollSpeed;
	        if ( this.roll > 360){
	        	this.roll = this.roll - 360;
	        }
	        
	        this.direction = DegAtan(this.vx, this.vy) +90;
	        //if (this.direction == -1f) this.direction = 180;
	        if (this.direction > 360) this.direction = this.direction - 360;
	        
	        break;
	        
		}
		if (Main.game == 2 && screenOut ) state = 4;//自分のロケットがやられているか
		if (this.apperCount > this.apperLimit ) state = 4;//画面にapperLimit(5)回出現した時は消える。
    	
		return state;
	}//end of update
	//(x0, y0)から(x, y)）までの距離を求める
	public float Distance(float x0, float y0, float x, float y){
		float a;
		a = (float)(Math.sqrt(Math.pow(x0 -x, 2) + Math.pow(y0 -y, 2)));
		return a;
	}
	//（ｘ，ｙ）から角度を求める
	public static float DegAtan(float x, float y){
		float d;
		//角度が垂直か水平のときの処理　さらにvx=0のときはtanが計算できない
		if (x == 0){
			if (y>0){
				d = 90;
			}else{
				d = 270;
			}
		if (y == 0) {
			if (x > 0){
				d = 0;
			}else{
				d = 180;
			}
		}
	//tanの逆関数で角度をもとめる
		}else{
			d = (float)(Math.atan(y/x)*180/(Math.PI));
			if (x < 0 ) d += 180;//第2,3事象
			if (x > 0 && y < 0) d += 360;//第４事象
		}
	//もし(x,y)=(0,0)ならば計算できないとして-1を返す
		if (x == 0 && y == 0){
			d = -1;
		}
		return d;
	}

}


		
	

