/**@file
 *
 *@brief	QRL Maker
 *@date		Tue,13 Oct,2015 - Sun,18 Oct,2015
 *@date		Fri,23 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Wed,28 Oct,2015
 *@date		Thu,29 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Thu,11 Feb,2016
 *@date		Sun,16 Apr,2017
 *@date		Sun,09 Jul,2017
 *@date		Sat,15 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,17 Mar,2018
 *@date		Thu,29 Nov,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Sun,30 Dec,2018
 *@date		Fri,19 Feb,2021
 *@date		Sat,29 May,2021
 *
 *@author	Copyright(C)2015-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "qrl.h"
#include "qrlmap.h"
#include <QStringList>

bool QRL::QRLChipList::reallocate(struct QRL::ChipAddrXY* const ret_base_chipaddr) noexcept
{
	struct QRL::ChipAddrXY base_chipaddr = Settings::BuildImage.Chip.Count;

	for (QRL::QRLChipNumber i = 0; i < this->maxlist(); ++i) {
		const QRL::QRLChip* const ptr = this->ptr(i);
		assert (NULL != ptr);
		if (ptr->chip_number <= 0) {
			continue;
		}

		const QRL::QRLChipLibrary* const chip = qrlmaker->QRLLibrary()->chipSearch(ptr->name);
		assert (NULL != chip);

		const struct QRL::ChipAddrXY st = ptr->addr;
		const struct QRL::ChipAddrXY max = chip->size;
		QStringList::const_iterator it = chip->footprint->begin();
		for (QRL::ChipAddr y = 0; y < max.y; ++y, ++it) {
			for (QRL::ChipAddr x = 0; x < max.x; ++x) {
				if (QChar('#') == (*it)[static_cast<int>(x)]) {
					if ((st.x + x) < base_chipaddr.x) {
						base_chipaddr.x = (st.x + x);
					}
					if ((st.y + y) < base_chipaddr.y) {
						base_chipaddr.y = (st.y + y);
					}
				}
			}
		}
	}

	for (QRL::QRLChipNumber i = 0; i < this->maxlist(); ++i) {
		QRL::QRLChip* const ptr = this->ptr_(i);
		assert (NULL != ptr);
		if (ptr->chip_number <= 0) {
			continue;
		}

		ptr->addr.x -= base_chipaddr.x;
		ptr->addr.y -= base_chipaddr.y;
	}

	if (NULL != ret_base_chipaddr) {
		ret_base_chipaddr->x = base_chipaddr.x;
		ret_base_chipaddr->y = base_chipaddr.y;
	}
	return true;
}
// [ End of File ]
