/**@file
 *
 *@brief	QRL Maker
 *@date		Thu,18 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Sat,20 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Thu,25 Feb,2021
 *@date		Fri,26 Feb,2021
 *@date		Sat,27 Feb,2021
 *@date		Sun,23 May,2021
 *@date		Sat,29 May,2021
 *@date		Sun,30 May,2021
 *@date		Thu,03 Jun,2021
 *@date		Sat,27 May,2023
 *
 *@author	Copyright(C)2021-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef QRLMAKER_H
#define QRLMAKER_H

#include <vector>
#include "settings.h"
#include <QtCore>
#include <QStringList>
#include <QImage>

namespace QRL {
	class QRLLibrary;
	class QRLMap;
	class QRLChipList;
};
class MapEditor_ClipBoard;


class QRLMaker_Base
{
	Q_DECLARE_TR_FUNCTIONS(QRLMaker)

public:
	friend class QRL::QRLLibrary;

protected:
	explicit QRLMaker_Base(class QRLMaker* q) noexcept;
	explicit QRLMaker_Base(void) noexcept;
	virtual ~QRLMaker_Base(void) noexcept = 0;

	class QRLMaker* qrlmaker;

	QStringList errmsg;

private:
};

class QRLMaker_QRL : public virtual QRLMaker_Base
{
	Q_DECLARE_TR_FUNCTIONS(QRLMaker)

public:
	friend class QRL::QRLMap;
	friend class QRL::QRLChipList;
	friend class MapEditor_Base;
	friend class MapEditor;
	friend class Dialog_InputDialog;
	friend class Dialog_ListDialog;
	friend class ImageBuilder_QRLMap_Base;
	friend class ImageBuilder_QRLMap_OverlayImage;
	friend class Form_MainForm;
	friend class MainWindow;

protected:
	explicit QRLMaker_QRL(void) noexcept(false);
	virtual ~QRLMaker_QRL(void) noexcept = 0;

	const QRL::QRLLibrary* QRLLibrary(void) const noexcept;

private:
	QRL::QRLLibrary* qrllibrary;
};

class QRLMaker_ClipBoard : public virtual QRLMaker_Base
{
	Q_DECLARE_TR_FUNCTIONS(QRLMaker)

public:
	friend class MapEditor;
	friend class ImageBuilder_QRLMap_OverlayImage;
	friend class Form_MainForm;

protected:
	explicit QRLMaker_ClipBoard(void) noexcept;
	virtual ~QRLMaker_ClipBoard(void) noexcept = 0;

	const MapEditor_ClipBoard* Clipboard(void) const noexcept;
	MapEditor_ClipBoard* Clipboard_(void) noexcept;

private:
	MapEditor_ClipBoard* clipboard;
};

class QRLMaker_ImageBuilder : public virtual QRLMaker_Base
{
	Q_DECLARE_TR_FUNCTIONS(QRLMaker)

public:
	friend class ImageBuilder_QRLMap_Base;
	friend class ImageBuilder_QRLMap_OverlayImage;

protected:
	explicit QRLMaker_ImageBuilder(void) noexcept(false);
	virtual ~QRLMaker_ImageBuilder(void) noexcept = 0;

	const QImage* Cursor(enum Settings::OverlayImage_Info::CursorType t) const noexcept;
	const QImage* ArrowImage(bool mode, QRL::ChipArrow num) const noexcept;

private:
	QImage cursor[Settings::OverlayImage_Info::CURSOR_TYPE_MAX + 1];
	QImage* arrowimage_true;
	QImage* arrowimage_false;
};

class QRLMaker_MainWindow : public virtual QRLMaker_Base
{
	Q_DECLARE_TR_FUNCTIONS(QRLMaker)

public:
	friend class MainWindow;

protected:
	explicit QRLMaker_MainWindow(const QStringList* const filelist) noexcept(false);
	virtual ~QRLMaker_MainWindow(void) noexcept = 0;

	bool open_window(void) noexcept(false);
	bool close_window(const class MainWindow* const target) noexcept;
	size_t num_of_window(void) const noexcept;
	std::vector<class MainWindow*>::const_iterator window_begin(void) const noexcept;
	std::vector<class MainWindow*>::const_iterator window_end(void) const noexcept;
	class MainWindow* window_back_(void) noexcept;

private:
	std::vector<class MainWindow*> w;
};

class QRLMaker :
	public virtual QRLMaker_Base,
	public QRLMaker_QRL,
	public QRLMaker_ClipBoard,
	public QRLMaker_ImageBuilder,
	public QRLMaker_MainWindow
{
public:
	explicit QRLMaker(const QStringList* const filelist) noexcept(false);
	~QRLMaker(void) noexcept;

protected:

private:
};



inline const QRL::QRLLibrary* QRLMaker_QRL::QRLLibrary(void) const noexcept
{
	return qrllibrary;
}

inline const MapEditor_ClipBoard* QRLMaker_ClipBoard::Clipboard(void) const noexcept
{
	return clipboard;
}

inline MapEditor_ClipBoard* QRLMaker_ClipBoard::Clipboard_(void) noexcept
{
	return clipboard;
}

inline size_t QRLMaker_MainWindow::num_of_window(void) const noexcept
{
	return w.size();
}

inline std::vector<class MainWindow*>::const_iterator QRLMaker_MainWindow::window_begin(void) const noexcept
{
	return w.begin();
}

inline std::vector<class MainWindow*>::const_iterator QRLMaker_MainWindow::window_end(void) const noexcept
{
	return w.end();
}

inline class MainWindow* QRLMaker_MainWindow::window_back_(void) noexcept
{
	return w.back();
}

#endif // QRLMAKER_H
// [ End of File ]
