/**@file
 *
 *@brief	QRL Maker
 *@date		Fri,11 Sep,2015
 *@date		Sat,29 May,2021
 *
 *@author	Copyright(C)2014-2021 G-HAL. All rights reserved.
 *@note	Bibliography: Copyright(C)2015 soramimi. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "mystyle.h"
#include <QStyleOption>
#include <QPainter>



MyStyleTreeControl::MyStyleTreeControl(void) noexcept
{
	{
		QImage img(2, 2, QImage::Format_RGB32);
		const QRgb t = qRgb(0xff, 0xff, 0xff);
		const QRgb u = qRgb(0x80, 0x80, 0x80);
		{
			QRgb* const p = (QRgb *)img.scanLine(0);
			p[0] = u;
			p[1] = t;
		}
		{
			QRgb* const p = (QRgb *)img.scanLine(1);
			p[0] = t;
			p[1] = u;
		}
		br_branch = QBrush(img);
	}

	return;
}

MyStyleTreeControl::~MyStyleTreeControl(void) noexcept
{
	return;
}

bool MyStyleTreeControl::drawPrimitive(QStyle::PrimitiveElement element, const QStyleOption* const option, QPainter* const painter, const QWidget* const) const noexcept
{
	if (QStyle::PE_IndicatorBranch == element) {
		const int ox = option->rect.x() + option->rect.width() / 2;
		const int oy = option->rect.y() + option->rect.height() / 2;
		if (QStyle::State_Item & option->state) {
			painter->fillRect(ox, oy, option->rect.right() - ox + 1, 1, br_branch);
		}
		if (QStyle::State_Sibling & option->state) {
			painter->fillRect(ox, oy, 1, option->rect.bottom() - oy + 1, br_branch);
		}
		if ((QStyle::State_Open | QStyle::State_Children | QStyle::State_Item | QStyle::State_Sibling) & option->state) {
			painter->fillRect(ox, option->rect.y(), 1, oy - option->rect.y(), br_branch);
		}
		if (QStyle::State_Children & option->state) {
			return false;
		}
		return true;
	}
	return false;
}


MyStyle::MyStyle(void) noexcept :
	QProxyStyle(0)
{
	return;
}

MyStyle::~MyStyle(void) noexcept
{
	return;
}

void MyStyle::drawPrimitive(PrimitiveElement element, const QStyleOption* const option, QPainter* const painter, const QWidget* const widget) const noexcept
{
	if (QStyle::PE_IndicatorBranch == element) {
		if (mystyle_treeview.drawPrimitive(element, option, painter, widget)) {
			return;
		}
	}
	QProxyStyle::drawPrimitive(element, option, painter, widget);
	return;
}
// [ End of File ]
