/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Sat,19 Sep,2015
 *@date		Sun,20 Sep,2015
 *@date		Sat,03 Oct,2015 - Sat,10 Oct,2015
 *@date		Tue,13 Oct,2015 - Thu,15 Oct,2015
 *@date		Sun,18 Oct,2015
 *@date		Thu,22 Oct,2015 - Sun,25 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Wed,28 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sat,07 Nov,2015
 *@date		Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016 - Sun,14 Feb,2016
 *@date		Sun,16 Apr,2017
 *@date		Sun,09 Jul,2017
 *@date		Sat,15 Jul,2017
 *@date		Sun,16 Jul,2017 - Mon,17 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,05 Aug,2017
 *@date		Sat,17 Mar,2018
 *@date		Mon,16 Jul,2018
 *@date		Sat,21 Jul,2018
 *@date		Sat,27 Oct,2018
 *@date		Fri,23 Nov,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Fri,21 Dec,2018
 *@date		Sat,22 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Sun,30 Dec,2018
 *@date		Mon,31 Dec,2018
 *@date		Mon,21 Jan,2019
 *@date		Fri,25 Jan,2019
 *@date		Sat,19 Sep,2020
 *@date		Sun,27 Dec,2020
 *@date		Wed,17 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Sat,20 Feb,2021
 *@date		Mon,22 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Sat,05 Jun,2021
 *
 *@author	Copyright(C)2015-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "settings.h"
#include "qrlmaker.h"
#include "mapeditor.h"
#include "qrl.h"
#include "qrlmap.h"
#include <QTranslator>

bool MapEditor::EditCommand(enum Settings::EditorCommand::EditorCommand_TYPE edit_mode, enum MapEditor_Type::MouseMode edit_type, const struct QRL::ChipAddrXY& cur_chipaddr, QRL::ChipArrow arrow, int_fast8_t pointed_argument_num, QString* const msg) noexcept
{
	bool needRefresh = false;
	const QRL::QRLChipNumber chip_number = QRLMap().map(cur_chipaddr);
	QRL::QRLChip* const chip_ptr = QRLMap_().search_(chip_number);
	const QRL::QRLChipLibrary* const chip_in_library = (NULL == chip_ptr) ? NULL : qrlmaker->QRLLibrary()->chipSearch(chip_ptr->name);

	switch (edit_mode) {
	case Settings::EditorCommand::NONE:
		if (MapEditor_Type::MOUSE_LEFT_PRESS == edit_type) {
			selected_list->clear();
			selected_list_bak->clear();
			Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);
		} else if (MapEditor_Type::MOUSE_LEFT_PRESS_W_CTRL == edit_type) {
			Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);
		}
		break;
	case Settings::EditorCommand::NORMAL:
		switch (edit_type) {
		case MapEditor_Type::MOUSE_NONE:
			break;
		case MapEditor_Type::MOUSE_LEFT_PRESS:
		case MapEditor_Type::MOUSE_LEFT_PRESS_W_CTRL:
			needRefresh = true;
			{
				(*selected_list_bak) = (*selected_list);
				if (0 < chip_number) {
					if (MapEditor_Type::MOUSE_LEFT_PRESS_W_CTRL == edit_type) {
						Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);
						Reset_Drag_ChipAddr();

						for (QRL::QRLChipNumber i = 0; i < QRLMap().maxlist(); ++i) {
							const QRL::QRLChip* const ptr = QRLMap().ptr(i);
							assert (NULL != ptr);
							if (chip_number == ptr->chip_number) {
								if (!selected_list->remove(chip_number)) {
									selected_list->put(ptr);
								}
								break;
							}
						}

						if (NULL != msg) {
							(*msg) = tr("Select");
						}
					} else {
						Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_DRAG);

						bool hit = false;
						for (QRL::QRLChipNumber i = 0; i < selected_list->maxlist(); ++i) {
							const QRL::QRLChip* const ptr = selected_list->ptr(i);
							assert (NULL != ptr);
							if (chip_number == ptr->chip_number) {
								hit = true;
								break;
							}
						}
						if (!hit) {
							selected_list->clear();
							for (QRL::QRLChipNumber i = 0; i < QRLMap().maxlist(); ++i) {
								const QRL::QRLChip* const ptr = QRLMap().ptr(i);
								assert (NULL != ptr);
								if (chip_number == ptr->chip_number) {
									selected_list->put(ptr);
									break;
								}
							}
						}
						{
							(*(clipboard4drag->list_())) = (*selected_list);
							struct QRL::ChipAddrXY base_chipaddr;
							clipboard4drag->reallocate(&base_chipaddr);
							clipboard4drag->ofs_() = base_chipaddr - cur_chipaddr;

							for (QRL::QRLChipNumber i = 0; i < selected_list->maxlist(); ++i) {
								const QRL::QRLChipNumber chip_number = selected_list->ptr(i)->chip_number;
								if (0 < chip_number) {
									QRLMap_().remove(chip_number);
								}
							}
							//selected_list->clear();
						}
						drag_chipaddr = cur_chipaddr;

						if (NULL != msg) {
							(*msg) = tr("Move");
						}
					}
				} else {
					Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_RECTANGULAR);
					if (MapEditor_Type::MOUSE_LEFT_PRESS_W_CTRL == edit_type) {
					} else {
						selected_list->clear();
					}
					drag_chipaddr = cur_chipaddr;

					if (NULL != msg) {
						(*msg) = tr("Select");
					}
				}
			}
			break;
		case MapEditor_Type::MOUSE_LEFT_DRAG:
		case MapEditor_Type::MOUSE_LEFT_DRAG_W_CTRL:
			break;
		case MapEditor_Type::MOUSE_FIN:
		case MapEditor_Type::MOUSE_FIN_W_CTRL:
			needRefresh = true;
			switch (SimpleCommandMode()) {
			case MapEditor_Type::SIMPLECOMMAND_NONE:
				break;
			case MapEditor_Type::SIMPLECOMMAND_DRAG:
				{
					bool chip_number_changed = false;
					for (QRL::QRLChipNumber i = 0; i < clipboard4drag->maxlist(); ++i) {
						const QRL::QRLChip* const ptr = clipboard4drag->ptr(i);
						assert (NULL != ptr);
						if (ptr->chip_number <= 0) {
							continue;
						}

						const QRL::QRLChipLibrary* const chip = qrlmaker->QRLLibrary()->chipSearch(ptr->name);
						assert (NULL != chip);
						const struct QRL::ChipAddrXY addr = (cur_chipaddr + ptr->addr + clipboard4drag->ofs());
						if (!QRLMap().is_put(addr, chip)) {
							goto EXEC_SIMPLECOMMAND_PASTE_FALSE;
						}
					}
					for (QRL::QRLChipNumber i = 0; i < clipboard4drag->maxlist(); ++i) {
						const QRL::QRLChip* const ptr = clipboard4drag->ptr(i);
						assert (NULL != ptr);
						if (ptr->chip_number <= 0) {
							continue;
						}

						const struct QRL::ChipAddrXY addr = (cur_chipaddr + ptr->addr + clipboard4drag->ofs());
						needRefresh |= QRLMap_().put(addr, ptr, &chip_number_changed);
					}
					{
						const struct QRL::ChipAddrXY ofs = (cur_chipaddr - drag_chipaddr);
						for (QRL::QRLChipNumber i = 0; i < selected_list->maxlist(); ++i) {
							QRL::QRLChip* const ptr_ = selected_list->ptr_(i);
							assert (NULL != ptr_);
							if (ptr_->chip_number <= 0) {
								continue;
							}

							ptr_->addr = (ptr_->addr + ofs);
						}
					}
					if (chip_number_changed) {
						selected_list->clear();
					}
				  EXEC_SIMPLECOMMAND_PASTE_FALSE:
					;
				}
				break;
			case MapEditor_Type::SIMPLECOMMAND_RECTANGULAR:
				if ((0 <= drag_chipaddr.x) || (0 <= drag_chipaddr.y)) {
					const struct QRL::ChipAddrXY st = {
						.x = IMIN(drag_chipaddr.x, cur_chipaddr.x),
						.y = IMIN(drag_chipaddr.y, cur_chipaddr.y),
					};
					const struct QRL::ChipAddrXY ed = {
						.x = IMAX(drag_chipaddr.x, cur_chipaddr.x),
						.y = IMAX(drag_chipaddr.y, cur_chipaddr.y),
					};
					struct QRL::ChipAddrXY cur;
					for (cur.y = st.y; cur.y <= ed.y; ++cur.y) {
						for (cur.x = st.x; cur.x <= ed.x; ++cur.x) {
							const QRL::QRLChipNumber chip_number = QRLMap().map(cur);
							if (chip_number <= 0) {
								continue;
							}

							for (QRL::QRLChipNumber i = 0; i < QRLMap().maxlist(); ++i) {
								const QRL::QRLChip* const ptr = QRLMap().ptr(i);
								assert (NULL != ptr);
								if (chip_number == ptr->chip_number) {
									selected_list->remove(chip_number);
									selected_list->put(ptr);
									break;
								}
							}
						}
					}

					Reset_Drag_ChipAddr();
				}
				break;
			}
			break;
		case MapEditor_Type::MOUSE_RIGHT_PRESS:
			needRefresh = true;
			if (MapEditor_Type::SIMPLECOMMAND_DRAG == SimpleCommandMode()) {
			}
			if (MapEditor_Type::SIMPLECOMMAND_NONE != SimpleCommandMode()) {
				Reset_Drag_ChipAddr();
				(*selected_list) = (*selected_list_bak);
				Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);
			}
			break;
		case MapEditor_Type::MOUSE_DOUBLELEFT:
			if (NULL != chip_in_library) {
				const bool ret_ea = edit_argument_of_chip(chip_ptr, chip_in_library, pointed_argument_num);
				if (ret_ea) {
					needRefresh = true;
					if (NULL != msg) {
						(*msg) = tr("Edit Argument");
					}
				}
				selected_list->clear();
				selected_list_bak->clear();
			}
			break;
		}
		break;
	case Settings::EditorCommand::SELECT:
		if ((MapEditor_Type::MOUSE_RIGHT_PRESS == edit_type) && (MapEditor_Type::SIMPLECOMMAND_NONE != SimpleCommandMode())) {
			(*selected_list) = (*selected_list_bak);
			Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);
		}
		if (MapEditor_Type::MOUSE_RIGHT_PRESS == edit_type) {
			if (0 < chip_number) {
				for (QRL::QRLChipNumber i = 0; i < QRLMap().maxlist(); ++i) {
					const QRL::QRLChip* const ptr = QRLMap().ptr(i);
					assert (NULL != ptr);
					if (chip_number == ptr->chip_number) {
						selected_list->remove(chip_number);
						break;
					}
				}
			}
		} else if ((MapEditor_Type::MOUSE_LEFT_PRESS == edit_type) || (MapEditor_Type::MOUSE_LEFT_PRESS_W_CTRL == edit_type) || (MapEditor_Type::MOUSE_LEFT_DRAG == edit_type) || (MapEditor_Type::MOUSE_LEFT_DRAG_W_CTRL == edit_type)) {
			if (0 < chip_number) {
				for (QRL::QRLChipNumber i = 0; i < QRLMap().maxlist(); ++i) {
					const QRL::QRLChip* const ptr = QRLMap().ptr(i);
					assert (NULL != ptr);
					if (chip_number == ptr->chip_number) {
						if (!selected_list->remove(chip_number)) {
							selected_list->put(ptr);
						}
						break;
					}
				}
			}
		}
		break;
	case Settings::EditorCommand::RECTANGULAR:
		if ((MapEditor_Type::MOUSE_RIGHT_PRESS == edit_type) && (MapEditor_Type::SIMPLECOMMAND_NONE != SimpleCommandMode())) {
			(*selected_list) = (*selected_list_bak);
			Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);
		}
		if (MapEditor_Type::MOUSE_RIGHT_PRESS == edit_type) {
			Reset_Drag_ChipAddr();
		} else if (((MapEditor_Type::MOUSE_LEFT_PRESS == edit_type) || (MapEditor_Type::MOUSE_LEFT_PRESS_W_CTRL == edit_type) || (MapEditor_Type::MOUSE_LEFT_DRAG == edit_type) || (MapEditor_Type::MOUSE_LEFT_DRAG_W_CTRL == edit_type)) && ((drag_chipaddr.x < 0) || (drag_chipaddr.y < 0))) {
			drag_chipaddr = cur_chipaddr;
		} else if (((MapEditor_Type::MOUSE_FIN == edit_type) || (MapEditor_Type::MOUSE_FIN_W_CTRL == edit_type)) && ((0 <= drag_chipaddr.x) || (0 <= drag_chipaddr.y))) {
			const struct QRL::ChipAddrXY st = {
				.x = IMIN(drag_chipaddr.x, cur_chipaddr.x),
				.y = IMIN(drag_chipaddr.y, cur_chipaddr.y),
			};
			const struct QRL::ChipAddrXY ed = {
				.x = IMAX(drag_chipaddr.x, cur_chipaddr.x),
				.y = IMAX(drag_chipaddr.y, cur_chipaddr.y),
			};
			struct QRL::ChipAddrXY cur;
			for (cur.y = st.y; cur.y <= ed.y; ++cur.y) {
				for (cur.x = st.x; cur.x <= ed.x; ++cur.x) {
					const QRL::QRLChipNumber cur_chip_number = QRLMap().map(cur);
					if (cur_chip_number <= 0) {
						continue;
					}

					for (QRL::QRLChipNumber i = 0; i < QRLMap().maxlist(); ++i) {
						const QRL::QRLChip* const ptr = QRLMap().ptr(i);
						assert (NULL != ptr);
						if (cur_chip_number == ptr->chip_number) {
							selected_list->remove(cur_chip_number);
							selected_list->put(ptr);
							break;
						}
					}
				}
			}

			Reset_Drag_ChipAddr();
		}
		break;
	case Settings::EditorCommand::CUT:
		if ((MapEditor_Type::MOUSE_RIGHT_PRESS == edit_type) && (MapEditor_Type::SIMPLECOMMAND_NONE != SimpleCommandMode())) {
			(*selected_list) = (*selected_list_bak);
			Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);
		}
		if ((MapEditor_Type::MOUSE_LEFT_PRESS == edit_type) || (MapEditor_Type::MOUSE_LEFT_DRAG == edit_type)) {
			needRefresh |= QRLMap_().remove(cur_chipaddr);

			if (NULL != msg) {
				(*msg) = tr("Cut");
			}
		}
		break;
	case Settings::EditorCommand::PASTE:
		if ((MapEditor_Type::MOUSE_RIGHT_PRESS == edit_type) && (MapEditor_Type::SIMPLECOMMAND_NONE != SimpleCommandMode())) {
			(*selected_list) = (*selected_list_bak);
			Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);
		}
		if (((MapEditor_Type::MOUSE_LEFT_PRESS == edit_type) || (MapEditor_Type::MOUSE_LEFT_DRAG == edit_type)) && ((0 <= cur_chipaddr.x) && (0 <= cur_chipaddr.y))) {
			for (QRL::QRLChipNumber i = 0; i < qrlmaker->Clipboard_()->maxlist(); ++i) {
				const QRL::QRLChip* const ptr = qrlmaker->Clipboard_()->ptr(i);
				assert (NULL != ptr);
				if (ptr->chip_number <= 0) {
					continue;
				}

				const QRL::QRLChipLibrary* const chip = qrlmaker->QRLLibrary()->chipSearch(ptr->name);
				assert (NULL != chip);
				const struct QRL::ChipAddrXY addr = (cur_chipaddr + ptr->addr + qrlmaker->Clipboard_()->ofs());
				if (!QRLMap().is_put(addr, chip)) {
					goto EXEC_PASTE_FALSE;
				}
			}
			for (QRL::QRLChipNumber i = 0; i < qrlmaker->Clipboard_()->maxlist(); ++i) {
				const QRL::QRLChip* const ptr = qrlmaker->Clipboard_()->ptr(i);
				assert (NULL != ptr);
				if (ptr->chip_number <= 0) {
					continue;
				}

				const struct QRL::ChipAddrXY addr = (cur_chipaddr + ptr->addr + qrlmaker->Clipboard_()->ofs());
				needRefresh |= QRLMap_().put(addr, ptr);
			}

			if (NULL != msg) {
				(*msg) = tr("Paste");
			}
		  EXEC_PASTE_FALSE:
			;
		}
		break;
	case Settings::EditorCommand::DELETE:
		if ((MapEditor_Type::MOUSE_RIGHT_PRESS == edit_type) && (MapEditor_Type::SIMPLECOMMAND_NONE != SimpleCommandMode())) {
			(*selected_list) = (*selected_list_bak);
			Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);
		}
		if ((MapEditor_Type::MOUSE_LEFT_PRESS == edit_type) || (MapEditor_Type::MOUSE_LEFT_DRAG == edit_type)) {
			needRefresh |= QRLMap_().remove(cur_chipaddr);

			if (NULL != msg) {
				(*msg) = tr("Delete");
			}
		}
		break;
	case Settings::EditorCommand::SET_ARROW_TRUE:
		if ((MapEditor_Type::MOUSE_RIGHT_PRESS == edit_type) && (MapEditor_Type::SIMPLECOMMAND_NONE != SimpleCommandMode())) {
			(*selected_list) = (*selected_list_bak);
			Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);
		}
		if ((MapEditor_Type::MOUSE_LEFT_PRESS == edit_type) || (MapEditor_Type::MOUSE_LEFT_DRAG == edit_type)) {
			if (set_arrow(chip_ptr, (cur_chipaddr - chip_ptr->addr), arrow, true)) {
				needRefresh |= true;

				if (NULL != msg) {
					(*msg) = tr("Set Arrow True");
				}
			}
		}
		break;
	case Settings::EditorCommand::SET_ARROW_FALSE:
		if ((MapEditor_Type::MOUSE_RIGHT_PRESS == edit_type) && (MapEditor_Type::SIMPLECOMMAND_NONE != SimpleCommandMode())) {
			(*selected_list) = (*selected_list_bak);
			Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);
		}
		if ((MapEditor_Type::MOUSE_LEFT_PRESS == edit_type) || (MapEditor_Type::MOUSE_LEFT_DRAG == edit_type)) {
			if (set_arrow(chip_ptr, (cur_chipaddr - chip_ptr->addr), arrow, false)) {
				needRefresh |= true;

				if (NULL != msg) {
					(*msg) = tr("Set Arrow False");
				}
			}
		}
		break;
	case Settings::EditorCommand::EDIT_ARGUMENT:
		if (MapEditor_Type::MOUSE_LEFT_PRESS == edit_type) {
			if (NULL != chip_in_library) {
				const bool ret_ea = edit_argument_of_chip(chip_ptr, chip_in_library, pointed_argument_num);
				if (ret_ea) {
					needRefresh = true;
					if (NULL != msg) {
						(*msg) = tr("Edit Argument");
					}
				}
			}
		}
		break;
	case Settings::EditorCommand::PUT_CHIP:
		if ((MapEditor_Type::MOUSE_RIGHT_PRESS == edit_type) && (MapEditor_Type::SIMPLECOMMAND_NONE != SimpleCommandMode())) {
			(*selected_list) = (*selected_list_bak);
			Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);
		}
		if ((MapEditor_Type::MOUSE_LEFT_PRESS == edit_type) || (MapEditor_Type::MOUSE_LEFT_DRAG == edit_type)) {
			needRefresh |= QRLMap_().put(cur_chipaddr, this->selected_library_chip);

			if (NULL != msg) {
				(*msg) = tr("Put") + " " + (*(this->selected_library_chip->name));
			}
		}
		break;
	}

	return needRefresh;
}
// [ End of File ]
