/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Sat,19 Sep,2015
 *@date		Sun,20 Sep,2015
 *@date		Sat,03 Oct,2015 - Sat,10 Oct,2015
 *@date		Tue,13 Oct,2015 - Thu,15 Oct,2015
 *@date		Sun,18 Oct,2015
 *@date		Thu,22 Oct,2015 - Sun,25 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Wed,28 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sat,07 Nov,2015
 *@date		Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016 - Sun,14 Feb,2016
 *@date		Sun,16 Apr,2017
 *@date		Sun,09 Jul,2017
 *@date		Sat,15 Jul,2017
 *@date		Sun,16 Jul,2017 - Mon,17 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,05 Aug,2017
 *@date		Sat,17 Mar,2018
 *@date		Mon,16 Jul,2018
 *@date		Sat,21 Jul,2018
 *@date		Sat,27 Oct,2018
 *@date		Fri,23 Nov,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Fri,21 Dec,2018
 *@date		Sat,22 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Mon,31 Dec,2018
 *@date		Fri,25 Jan,2019
 *@date		Thu,18 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *
 *@author	Copyright(C)2015-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include <cstdint>
#include <string.h>
#include "settings.h"
#include "mapeditor.h"
#include "mytypes.h"
#include "qrl.h"
#include "qrlmap.h"
#include "qrl_type.h"

QRL::QRLChipArrowAddress MapEditor_Base::make_arrowaddress(const QRL::QRLChipLibrary* const chip, const QRL::ChipAddrXY& cur, const QRL::ChipArrow arrow) const noexcept
{
	assert (NULL != chip);

	const QRL::QRLChipArrowAddress arrowaddr = ((static_cast<QRL::QRLChipArrowAddress>(cur.x) + 1) * Settings::QRLChipLibrary.Limit.Address.Base * 10) + ((static_cast<QRL::QRLChipArrowAddress>(cur.y) + 1) * 10) + static_cast<QRL::QRLChipArrowAddress>(arrow);
	if (!qrlmaker->QRLLibrary()->check_arrowaddress(chip, arrowaddr)) {
		return 0;
	}
	return arrowaddr;
}

bool MapEditor_Base::set_arrow(QRL::QRLChip* const ptr, const QRL::ChipAddrXY& ofs, const QRL::ChipArrow arrow, bool arrow_mode) noexcept
{
	assert (NULL != ptr);

	if (QRL::ChipArrow_MIN < arrow) {
		QRL::QRLChipArrowAddress* const next_address_condition = arrow_mode ? &(ptr->next_address_condition_true) : &(ptr->next_address_condition_false);
		if (0 < (*next_address_condition)) {
			const QRL::QRLChipLibrary* const chip = qrlmaker->QRLLibrary()->chipSearch(ptr->name);
			assert (NULL != chip);

			const QRL::QRLChipArrowAddress arrowaddr = make_arrowaddress(chip, ofs, arrow);
			if (0 < arrowaddr) {
				(*next_address_condition) = arrowaddr;
				return true;
			}
		}
	}
	return false;
}
// [ End of File ]
