/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Sat,19 Sep,2015
 *@date		Sun,20 Sep,2015
 *@date		Sat,03 Oct,2015 - Sat,10 Oct,2015
 *@date		Tue,13 Oct,2015 - Thu,15 Oct,2015
 *@date		Sun,18 Oct,2015
 *@date		Thu,22 Oct,2015 - Sun,25 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Wed,28 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sat,07 Nov,2015
 *@date		Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016 - Sun,14 Feb,2016
 *@date		Sun,16 Apr,2017
 *@date		Sun,09 Jul,2017
 *@date		Sat,15 Jul,2017
 *@date		Sun,16 Jul,2017 - Mon,17 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,05 Aug,2017
 *@date		Sat,17 Mar,2018
 *@date		Mon,16 Jul,2018
 *@date		Sat,21 Jul,2018
 *@date		Sat,27 Oct,2018
 *@date		Fri,23 Nov,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Fri,21 Dec,2018
 *@date		Sat,22 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Sun,30 Dec,2018
 *@date		Mon,31 Dec,2018
 *@date		Mon,21 Jan,2019
 *@date		Fri,25 Jan,2019
 *@date		Wed,17 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sun,23 May,2021
 *@date		Mon,24 May,2021
 *@date		Sat,29 May,2021
 *@date		Sun,30 May,2021
 *@date		Thu,03 Jun,2021
 *
 *@author	Copyright(C)2015-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "settings.h"
#include "qrlmaker.h"
#include "mapeditor_clipboard.h"
#include "mapeditor.h"
#include "qrl.h"
#include "qrlmap.h"

MapEditor::MapEditor(QRLMaker* const q, MainWindow* const mw) noexcept :
	MapEditor_Base(q, mw),
	qrlmap(NULL),
	selected_library_chip(NULL),
	selected_list(NULL),
	selected_list_bak(NULL),
	clipboard4drag(NULL)
{
	qrlmap = new(std::nothrow) QRL::QRLMap(qrlmaker, Settings::BuildImage.Chip.Count, Settings::QRLChipLibrary.Limit.Number.Max);
	assert (NULL != qrlmap);

	selected_list = new(std::nothrow) QRL::QRLChipList(qrlmaker, Settings::QRLChipLibrary.Limit.Number.Max);
	assert (NULL != selected_list);

	selected_list_bak = new(std::nothrow) QRL::QRLChipList(qrlmaker, Settings::QRLChipLibrary.Limit.Number.Max);
	assert (NULL != selected_list_bak);

	clipboard4drag = new(std::nothrow) MapEditor_ClipBoard(qrlmaker);
	assert (NULL != clipboard4drag);

	Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);

	this->selected_library_chip = NULL;

	Reset_Drag_ChipAddr();

	return;
}

MapEditor::~MapEditor(void) noexcept
{
	assert (NULL != qrlmap);
	// assert (NULL != selected_library_chip); // Allocate only when using.
	assert (NULL != selected_list);
	assert (NULL != selected_list_bak);
	assert (NULL != clipboard4drag);

	if (NULL != clipboard4drag) {
		delete clipboard4drag;
	}
	if (NULL != selected_list_bak) {
		delete selected_list_bak;
	}
	if (NULL != selected_list) {
		delete selected_list;
	}
	if (NULL != qrlmap) {
		delete qrlmap;
	}
	return;
}
// [ End of File ]
