/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Sat,19 Sep,2015
 *@date		Sun,20 Sep,2015
 *@date		Sat,03 Oct,2015 - Sat,10 Oct,2015
 *@date		Tue,13 Oct,2015 - Thu,15 Oct,2015
 *@date		Sun,18 Oct,2015
 *@date		Thu,22 Oct,2015 - Sun,25 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Wed,28 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sat,07 Nov,2015
 *@date		Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016 - Sun,14 Feb,2016
 *@date		Sun,16 Apr,2017
 *@date		Sun,09 Jul,2017
 *@date		Sat,15 Jul,2017
 *@date		Sun,16 Jul,2017 - Mon,17 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,05 Aug,2017
 *@date		Sat,17 Mar,2018
 *@date		Mon,16 Jul,2018
 *@date		Sat,21 Jul,2018
 *@date		Sat,27 Oct,2018
 *@date		Fri,23 Nov,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Fri,21 Dec,2018
 *@date		Sat,22 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Sun,30 Dec,2018
 *@date		Mon,31 Dec,2018
 *@date		Mon,21 Jan,2019
 *@date		Fri,25 Jan,2019
 *@date		Sun,27 Jan,2019
 *@date		Tue,29 Jan,2019
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Thu,07 Jul,2022
 *@date		Wed,13 Jul,2022
 *
 *@author	Copyright(C)2015-2022 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include <cstdint>
#include <stdio.h>
#include "settings.h"
#include "mapeditor.h"
#include "imagebuilder.h"
#include "qrl.h"
#include "qrlmap.h"
#include <QPainter>
#include <QImage>
#include <QRgb>
#include <QPen>
#include <QColor>
#include <QFont>
#include <QFontMetrics>
#include "xy_.h"

void ImageBuilder_QRLMap_DisplayImage::MakeDisplayImage(const XY_<int_fast32_t>& screen_size, const XY_<int_fast16_t>& screen_ofs) noexcept
{
	if ((NULL != img_display) && ((screen_size.x != img_display->width()) || (screen_size.y != img_display->height()))) {
		delete img_display;
		img_display = NULL;
	}
	if (NULL == img_display) {
		img_display = new(std::nothrow) QImage(screen_size.x, screen_size.y, QImage::Format_RGB32);
		assert (NULL != img_display);
	}

	QPainter imagePainter(img_display);
	{
		const uint_fast8_t r = Settings::BuildImage.Color.Background.R;
		const uint_fast8_t g = Settings::BuildImage.Color.Background.G;
		const uint_fast8_t b = Settings::BuildImage.Color.Background.B;
		const QRgb color = qRgb(r, g, b);
		img_display->fill(color);
	}

	{ // Show Chip-Map Image
		imagePainter.drawImage(ScreenParam()->gauge.x, ScreenParam()->gauge.y, *img_buffer);
	}

	{ // Show Gauge
		const uint_fast8_t r = Settings::BuildImage.Color.GaugeText.R;
		const uint_fast8_t g = Settings::BuildImage.Color.GaugeText.G;
		const uint_fast8_t b = Settings::BuildImage.Color.GaugeText.B;
		imagePainter.setPen(QPen(QColor(r, g, b), 1, Qt::SolidLine));
		QFont ft = imagePainter.font();
		ft.setPointSize(Settings::BuildImage.Font.GaugeTextPointSize);
		const QFontMetrics fm(ft);
		imagePainter.setFont(ft);

		const int_fast16_t sizex = (fm.maxWidth() * Settings::BuildImage.Font.GaugeTextLength);
		const int_fast16_t sizey = (fm.height() * 1);
		const int_fast16_t ofs_x = (ScreenParam()->gap.x + ScreenParam()->core.x / 2) - (sizex / 2);
		const int_fast16_t ofs_y = (ScreenParam()->gap.y + ScreenParam()->core.y / 2) - (sizey / 2);
		const int_fast16_t limit_x = (screen_size.x / ScreenParam()->scs.x);
		const int_fast16_t limit_y = (screen_size.y / ScreenParam()->scs.y);
		const int_fast16_t bs_x = static_cast<int_fast16_t>(ScreenParam()->bs.x * scaling());
		const int_fast16_t bs_y = static_cast<int_fast16_t>(ScreenParam()->bs.y * scaling());
		const int_fast16_t step_nx = (1.0 < scaling()) ? 1 : static_cast<int_fast16_t>(nearbyint(1.0 / scaling()));
		const int_fast16_t step_ny = (1.0 < scaling()) ? 1 : static_cast<int_fast16_t>(nearbyint(1.0 / scaling()));
		for (int_fast16_t nx = 0; nx < limit_x; nx += step_nx) {
			const int_fast16_t num = nx + screen_ofs.x + 1;
			if (Settings::BuildImage.Chip.Count.x < num) {
				break;
			}
			const int_fast32_t px = static_cast<int_fast32_t>(ScreenParam()->gauge.x) + (nx * bs_x) + ofs_x;
			const int_fast32_t py = 0;
			const QString text = QString("%1").arg(num, Settings::BuildImage.Font.GaugeTextLength, 10, QChar(' '));
			imagePainter.drawText(px, py, sizex, ScreenParam()->gauge.x, (Qt::AlignBottom | Qt::AlignHCenter), text);
		}
		for (int_fast16_t ny = 0; ny < limit_y; ny += step_ny) {
			const int_fast16_t num = ny + screen_ofs.y + 1;
			if (Settings::BuildImage.Chip.Count.y < num) {
				break;
			}
			const int_fast32_t px = 0;
			const int_fast32_t py = static_cast<int_fast32_t>(ScreenParam()->gauge.y) + (ny * bs_y) + ofs_y;
			const QString text = QString("%1").arg(num, Settings::BuildImage.Font.GaugeTextLength, 10, QChar(' '));
			imagePainter.drawText(px, py, ScreenParam()->gauge.y, sizey, (Qt::AlignVCenter | Qt::AlignRight), text);
		}
	}

	return;
}
// [ End of File ]
