/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Tue,15 Sep,2015
 *@date		Mon,21 Sep,2015
 *@date		Sat,03 Oct,2015 - Mon,12 Oct,2015
 *@date		Wed,14 Oct,2015 - Sat,17 Oct,2015
 *@date		Thu,22 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sun,10 Jan,2016 - Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016
 *@date		Sun,09 Jul,2017
 *@date		Sun,16 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,17 Mar,2018
 *@date		Fri,23 Nov,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Sat,19 Jan,2019
 *@date		Fri,25 Jan,2019
 *@date		Sun,27 Jan,2019
 *@date		Tue,29 Jan,2019
 *@date		Wed,30 Jan,2019
 *@date		Tue,19 Feb,2019
 *@date		Mon,16 Nov,2020
 *@date		Sun,27 Dec,2020
 *@date		Thu,18 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Mon,22 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Mon,24 May,2021
 *@date		Sat,29 May,2021
 *@date		Wed,13 Jul,2022
 *@date		Sat,29 Apr,2023
 *
 *@author	Copyright(C)2015-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include <stdio.h>
#include "settings.h"
#include "imagebuilder.h"

void ImageBuilder_QRLMap_Base::CalcScreenParam(void) noexcept
{
	assert (0.0 != scaling());

	this->screen_param.gauge.x = Settings::BuildImage.GaugeSize;
	this->screen_param.gauge.y = Settings::BuildImage.GaugeSize;
	this->screen_param.overlapping.x = static_cast<int_fast16_t>(Settings::BuildImage.Chip.OverlappingSize * scaling());
	this->screen_param.overlapping.y = static_cast<int_fast16_t>(Settings::BuildImage.Chip.OverlappingSize * scaling());
	this->screen_param.gap.x = static_cast<int_fast16_t>(Settings::BuildImage.Chip.GapSize * scaling());
	this->screen_param.gap.y = static_cast<int_fast16_t>(Settings::BuildImage.Chip.GapSize * scaling());
	this->screen_param.core.x = static_cast<int_fast16_t>(Settings::BuildImage.Chip.CoreSize * scaling());
	this->screen_param.core.y = static_cast<int_fast16_t>(Settings::BuildImage.Chip.CoreSize * scaling());
	this->screen_param.bs.x = (Settings::BuildImage.Chip.GapSize + Settings::BuildImage.Chip.CoreSize);
	this->screen_param.bs.y = (Settings::BuildImage.Chip.GapSize + Settings::BuildImage.Chip.CoreSize);
	this->screen_param.scs.x = static_cast<int_fast16_t>(qMax(static_cast<float>(1.0), this->screen_param.bs.x * scaling()));
	this->screen_param.scs.y = static_cast<int_fast16_t>(qMax(static_cast<float>(1.0), this->screen_param.bs.y * scaling()));

	return;
}

ImageBuilder_QRLMap_Base::ImageBuilder_QRLMap_Base(const QRLMaker* const q) noexcept :
	qrlmaker(NULL),
	mapeditor(NULL),
	img_base(NULL)
{
	assert (NULL != q);

	qrlmaker = q;

	this->screen_param.scaling = 0.0;

	return;
}

ImageBuilder_QRLMap_Base::~ImageBuilder_QRLMap_Base(void) noexcept
{
	assert (NULL != qrlmaker);
	assert (NULL != mapeditor);
	// assert (NULL != img_base); // Allocate only when using.

	if (NULL != img_base) {
		delete img_base;
	}
	return;
}

ImageBuilder_QRLMap_OverlayImage::ImageBuilder_QRLMap_OverlayImage(const QRLMaker* const q) noexcept :
	ImageBuilder_QRLMap_Base(q),
	img_buffer(NULL)
{
	return;
}

ImageBuilder_QRLMap_OverlayImage::~ImageBuilder_QRLMap_OverlayImage(void) noexcept
{
	assert (NULL != img_buffer);

	if (NULL != img_buffer) {
		delete img_buffer;
	}
	return;
}

ImageBuilder_QRLMap_DisplayImage::ImageBuilder_QRLMap_DisplayImage(const QRLMaker* const q) noexcept :
	ImageBuilder_QRLMap_Base(q),
	ImageBuilder_QRLMap_OverlayImage(q),
	img_display(NULL)
{
	return;
}

ImageBuilder_QRLMap_DisplayImage::~ImageBuilder_QRLMap_DisplayImage(void) noexcept
{
	assert (NULL != img_display);

	if (NULL != img_display) {
		delete img_display;
	}
	return;
}

ImageBuilder_QRLMap_SaveImage::ImageBuilder_QRLMap_SaveImage(const QRLMaker* const q) noexcept :
	ImageBuilder_QRLMap_Base(q),
	img_save(NULL)
{
	return;
}

ImageBuilder_QRLMap_SaveImage::~ImageBuilder_QRLMap_SaveImage(void) noexcept
{
	// assert (NULL != img_save); // Allocate only when using.

	if (NULL != img_save) {
		delete img_save;
	}
	return;
}
// [ End of File ]
