/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Tue,15 Sep,2015
 *@date		Mon,21 Sep,2015
 *@date		Sat,03 Oct,2015 - Mon,12 Oct,2015
 *@date		Tue,13 Oct,2015 - Sat,17 Oct,2015
 *@date		Thu,22 Oct,2015 - Fri,23 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Thu,11 Feb,2016
 *@date		Sun,09 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,17 Mar,2018
 *@date		Fri,23 Nov,2018
 *@date		Wed,28 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018 - Sun,30 Dec,2018
 *@date		Sat,19 Jan,2019
 *@date		Tue,22 Jan,2019
 *@date		Fri,25 Jan,2019
 *@date		Wed,17 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Sat,05 Jun,2021
 *@date		Sun,06 Jun,2021
 *@date		Fri,28 Apr,2023
 *
 *@author	Copyright(C)2015-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <cstdint>
#include <math.h>
#include "settings.h"
#include "mapeditor.h"
#include "form_mainform.h"
#include "mytypes.h"
#include "qrl.h"
#include "qrlmap.h"
#include <QPoint>
#include <QMouseEvent>
#include <QTimer>
#include "xy_.h"

void Form_MainForm::mouseReleaseUserEvent(QMouseEvent* const pEvent) noexcept
{
	QString msg;
	const QPoint p = pEvent->pos();
	const QRL::ChipAddrXY chip_ptr = {
		.x = -1,
		.y = -1,
	};
	const XY_<int_fast32_t> mouse_ptr = {
		.x = p.x(),
		.y = p.y(),
	};
	const Qt::KeyboardModifiers mod = pEvent->modifiers();

	if (this->dragscroll.flag) {
		this->dragscroll.flag = false;
		killTimer(dragscroll.id);
	}

	if (0 != (Qt::ControlModifier & mod)) {
		buildImage(MapEditor_Type::MOUSE_FIN_W_CTRL, chip_ptr, mouse_ptr, &msg);
	} else {
		buildImage(MapEditor_Type::MOUSE_FIN, chip_ptr, mouse_ptr, &msg);
	}

	{
		mapeditor->Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);
		mapeditor->Reset_Drag_ChipAddr();
	}

	if (!msg.isEmpty()) {
		mainwindow->set_statusBar1(msg);
	}
	mainwindow->set_edited(mapeditor->QRLMap_().push_undo(msg));
	mainwindow->set_windowtitle();
	return;
}
// [ End of File ]
