/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Tue,15 Sep,2015
 *@date		Mon,21 Sep,2015
 *@date		Sat,03 Oct,2015 - Mon,12 Oct,2015
 *@date		Tue,13 Oct,2015 - Sat,17 Oct,2015
 *@date		Thu,22 Oct,2015 - Fri,23 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Thu,11 Feb,2016
 *@date		Sun,09 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,17 Mar,2018
 *@date		Fri,23 Nov,2018
 *@date		Wed,28 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018 - Sun,30 Dec,2018
 *@date		Sat,19 Jan,2019
 *@date		Fri,25 Jan,2019
 *@date		Sun,27 Jan,2019
 *@date		Tue,29 Jan,2019
 *@date		Wed,17 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Sat,05 Jun,2021
 *@date		Sun,06 Jun,2021
 *@date		Wed,13 Jul,2022
 *@date		Sat,18 Feb,2023
 *@date		Fri,28 Apr,2023
 *
 *@author	Copyright(C)2015-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <cstdint>
#include <math.h>
#include "settings.h"
#include "mapeditor.h"
#include "imagebuilder.h"
#include "form_mainform.h"
#include "mytypes.h"
#include "qrl.h"
#include "qrlmap.h"
#include <QPoint>
#include <QMouseEvent>
#include <QTimer>
#include "xy_.h"

void Form_MainForm::mouseMoveUserEvent(QMouseEvent* const pEvent) noexcept
{
	const QPoint p = pEvent->pos();
	const QRL::ChipAddrXY chip_ptr = {
		.x = -1,
		.y = -1,
	};
	const XY_<int_fast32_t> mouse_ptr = {
		.x = p.x(),
		.y = p.y(),
	};
	const Qt::KeyboardModifiers mod = pEvent->modifiers();

	if ( pEvent->buttons() & Qt::RightButton ) {

	} else if ( pEvent->buttons() & Qt::LeftButton ) {

		const int_fast32_t gs = static_cast<int_fast32_t>(Settings::BuildImage.GaugeSize);
		if (mouse_ptr.x < gs) {
			this->dragscroll.flag = true;
			this->dragscroll.x = -1;
		} else if ((this->width() - gs) < mouse_ptr.x) {
			this->dragscroll.flag = true;
			this->dragscroll.x = +1;
		} else {
			this->dragscroll.x = 0;
		}
		if (mouse_ptr.y < gs) {
			this->dragscroll.flag = true;
			this->dragscroll.y = -1;
		} else if ((this->height() - gs) < mouse_ptr.y) {
			this->dragscroll.flag = true;
			this->dragscroll.y = +1;
		} else {
			this->dragscroll.y = 0;
		}

		if (0 != (Qt::ControlModifier & mod)) {
			buildImage(MapEditor_Type::MOUSE_LEFT_DRAG_W_CTRL, chip_ptr, mouse_ptr, NULL);
		} else {
			buildImage(MapEditor_Type::MOUSE_LEFT_DRAG, chip_ptr, mouse_ptr, NULL);
		}

		if (this->dragscroll.flag) {
			this->dragscroll.mouse_ptr = mouse_ptr;
			this->dragscroll.with_ctrl = false;
			if (0 != (Qt::ControlModifier & mod)) {
				this->dragscroll.with_ctrl = true;
			}
			this->dragscroll.id = startTimer(Settings::Mouse.get_DragScrollTimer());
		}

	} else if ( pEvent->buttons() & Qt::MiddleButton ) {
		const QPoint d = (this->dragStartPosition - p);
		const int_fast32_t x = static_cast<int_fast32_t>(round(d.x() / display_img->scaling() / static_cast<double>(Settings::BuildImage.Chip.GapSize + Settings::BuildImage.Chip.CoreSize)));
		const int_fast32_t y = static_cast<int_fast32_t>(round(d.y() / display_img->scaling() / static_cast<double>(Settings::BuildImage.Chip.GapSize + Settings::BuildImage.Chip.CoreSize)));
		mainwindow->set_horizontalScrollBar(sliderPosition.x + x);
		mainwindow->set_verticalScrollBar(sliderPosition.y + y);

	} else {
		if (0 != (Qt::ShiftModifier & mod)) {
			buildImage(MapEditor_Type::MOUSE_LEFT_DRAG, chip_ptr, mouse_ptr, NULL);
		} else {
			if ((Settings::EditorCommand::NONE != this->mode) && (Settings::EditorCommand::NORMAL != this->mode)) {
				QString msg;
				if (0 != (Qt::ControlModifier & mod)) {
					buildImage(MapEditor_Type::MOUSE_FIN_W_CTRL, chip_ptr, mouse_ptr, &msg);
				} else {
					buildImage(MapEditor_Type::MOUSE_FIN, chip_ptr, mouse_ptr, &msg);
				}

				if (!msg.isEmpty()) {
					mainwindow->set_statusBar1(msg);
				}
				mainwindow->set_edited(mapeditor->QRLMap_().push_undo(msg));
				mainwindow->set_windowtitle();
			} else {
				mapeditor->Set_SimpleCommand(MapEditor_Type::SIMPLECOMMAND_NONE);
				buildImage(MapEditor_Type::MOUSE_NONE, chip_ptr, mouse_ptr, NULL);
				showStatusMessage(mouse_ptr);
			}
		}
	}

	return;
}
// [ End of File ]
