/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,06 Jun,2021
 *@date		Sun,13 Jun,2021
 *@date		Sat,18 Feb,2023
 *@date		Sat,22 Apr,2023
 *
 *@author	Copyright(C)2021-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include "settings.h"
#include "form_mainform.h"
#include <QApplication>
#include <QMouseEvent>

void Form_MainForm::mousePressEvent(QMouseEvent* const pEvent) noexcept
{
	if (NULL != mousePress_PendingEvent) {
		delete mousePress_PendingEvent;
		mousePress_PendingEvent = NULL;
	}
  #if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
	mousePress_PendingEvent = new(std::nothrow) QMouseEvent(pEvent->type(), pEvent->pos(), pEvent->scenePosition(), pEvent->globalPosition(), pEvent->button(), pEvent->buttons(), pEvent->modifiers());
  #else
	mousePress_PendingEvent = new(std::nothrow) QMouseEvent(*pEvent);
  #endif
	assert (NULL != mousePress_PendingEvent);

	++mouse_press_count;

	mouse_waiting_timeout = true;
	mouse_timer->start((0 <= Settings::Mouse.get_DoubleClickInterval()) ? Settings::Mouse.get_DoubleClickInterval() : QApplication::doubleClickInterval());
	return;
}

void Form_MainForm::mouseReleaseEvent(QMouseEvent* const pEvent) noexcept
{
	if (mouse_waiting_timeout) {
		++mouse_release_count;

		if (NULL != mouseRelease_PendingEvent) {
			delete mouseRelease_PendingEvent;
			mouseRelease_PendingEvent = NULL;
		}
	  #if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
		mouseRelease_PendingEvent = new(std::nothrow) QMouseEvent(pEvent->type(), pEvent->pos(), pEvent->scenePosition(), pEvent->globalPosition(), pEvent->button(), pEvent->buttons(), pEvent->modifiers());
	  #else
		mouseRelease_PendingEvent = new(std::nothrow) QMouseEvent(*pEvent);
	  #endif
		assert (NULL != mouseRelease_PendingEvent);
	} else {
		assert (0 == mouse_press_count);
		assert (0 == mouse_release_count);
		assert (NULL == mousePress_PendingEvent);
		assert (NULL == mouseRelease_PendingEvent);

		mouseReleaseUserEvent(pEvent);
	}

	return;
}

void Form_MainForm::mouseMoveEvent(QMouseEvent* const pEvent) noexcept
{
	mouseExecPendingEvent();

	mouseMoveUserEvent(pEvent);

	return;
}

void Form_MainForm::mouseTimeout(void) noexcept
{
	assert (1 <= mouse_press_count);
	assert (NULL != mousePress_PendingEvent);

	mouseExecPendingEvent();

	return;
}

void Form_MainForm::mouseExecPendingEvent(void) noexcept
{
	mouse_timer->stop();
	mouse_waiting_timeout = false;

	switch (mouse_press_count) {
	case 0:
		// There are no pending events.
		break;

	case 1:
		if ((0 == mouse_release_count) || (1 == mouse_release_count)) {
			assert (NULL != mousePress_PendingEvent);
			mousePressUserEvent(mousePress_PendingEvent);
			delete mousePress_PendingEvent;
			mousePress_PendingEvent = NULL;
			if (NULL != mouseRelease_PendingEvent) {
				mouseReleaseUserEvent(mouseRelease_PendingEvent);
				delete mouseRelease_PendingEvent;
				mouseRelease_PendingEvent = NULL;
			}
		} else {
			// assert (false); // Press -> TimeOut -> Press -> Release -> Release
		}
		break;

	case 2:
		if (1 == mouse_release_count) {
			assert (NULL != mousePress_PendingEvent);
			mousePressUserEvent(mousePress_PendingEvent);
			delete mousePress_PendingEvent;
			mousePress_PendingEvent = NULL;
		} else if (2 == mouse_release_count) {
			assert (NULL != mousePress_PendingEvent);
			mouseDoubleClickUserEvent(mousePress_PendingEvent);
			delete mousePress_PendingEvent;
			mousePress_PendingEvent = NULL;
		} else {
			// assert (false); // Two or more buttons were pressed.
		}
		break;

	default:
		assert (NULL != mousePress_PendingEvent);
		mouseDoubleClickUserEvent(mousePress_PendingEvent);
		delete mousePress_PendingEvent;
		mousePress_PendingEvent = NULL;
		break;
	}

	mouse_press_count = 0;
	mouse_release_count = 0;
	if (NULL != mousePress_PendingEvent) {
		delete mousePress_PendingEvent;
		mousePress_PendingEvent = NULL;
	}
	if (NULL != mouseRelease_PendingEvent) {
		delete mouseRelease_PendingEvent;
		mouseRelease_PendingEvent = NULL;
	}
	return;
}
// [ End of File ]
