/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Sat,19 Sep,2015
 *@date		Sun,20 Sep,2015
 *@date		Sat,03 Oct,2015 - Sat,10 Oct,2015
 *@date		Tue,13 Oct,2015 - Thu,15 Oct,2015
 *@date		Sun,18 Oct,2015
 *@date		Thu,22 Oct,2015 - Sun,25 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Wed,28 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sat,07 Nov,2015
 *@date		Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016 - Sun,14 Feb,2016
 *@date		Sun,16 Apr,2017
 *@date		Sun,09 Jul,2017
 *@date		Sat,15 Jul,2017
 *@date		Sun,16 Jul,2017 - Mon,17 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,05 Aug,2017
 *@date		Sat,17 Mar,2018
 *@date		Mon,16 Jul,2018
 *@date		Sat,21 Jul,2018
 *@date		Sat,27 Oct,2018
 *@date		Fri,23 Nov,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Fri,21 Dec,2018
 *@date		Sat,22 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Fri,25 Jan,2019
 *@date		Sun,29 Nov,2020
 *@date		Sun,27 Dec,2020
 *@date		Wed,17 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Sun,21 Feb,2021
 *@date		Mon,22 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Fri,28 Apr,2023
 *
 *@author	Copyright(C)2015-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include <cstdint>
#include <stdio.h>
#include <string.h>
#include "settings.h"
#include "mapeditor.h"
#include "form_mainform.h"
#include "mytypes.h"
#include "qrl.h"
#include "qrlmap.h"
#include <QCoreApplication>
#include <QString>
#include "xy_.h"

void Form_MainForm::showStatusMessage(const struct QRL::ChipAddrXY& cur_chipaddr) noexcept
{
	if ((0 <= cur_chipaddr.x) && (0 <= cur_chipaddr.y)) {
		const QRL::QRLChipNumber num = mapeditor->QRLMap().map(cur_chipaddr);
		if (0 <= num) {
			const QRL::QRLChip* const ptr = mapeditor->QRLMap().search(num);
			assert (NULL != ptr);

			const QString tmp = (ptr->name);
			const QString tmp_tr = QCoreApplication::translate(Settings::QRLChipLibrary.tr_context.ChipLibrary, qPrintable(tmp), Settings::QRLChipLibrary.tr_disambiguation.Chip);
			if (tmp != tmp_tr) {
				mainwindow->set_statusBar2(tmp_tr + " ( " + tmp + " )");
			} else {
				mainwindow->set_statusBar2(tmp);
			}
		} else {
			if (Settings::EditorCommand::PUT_CHIP == this->mode) {
				const QString tmp = *(mapeditor->SelectedLibraryChip()->name);
				const QString tmp_tr = QCoreApplication::translate(Settings::QRLChipLibrary.tr_context.ChipLibrary, qPrintable(tmp), Settings::QRLChipLibrary.tr_disambiguation.Chip);
				if (tmp != tmp_tr) {
					mainwindow->set_statusBar2(tmp_tr + " ( " + tmp + " )");
				} else {
					mainwindow->set_statusBar2(tmp);
				}
			} else {
				if ("" != selected_form_treeitem_name) {
					mainwindow->set_statusBar2(selected_form_treeitem_name_tr);
				} else {
					mainwindow->set_statusBar2("");
				}
			}
		}
	}

	return;
}

void Form_MainForm::showStatusMessage(const XY_<int_fast32_t>& cur) noexcept
{
	const struct QRL::ChipAddrXY cur_chipaddr = {
		.x = mouseptr2chipaddr_x(cur.x),
		.y = mouseptr2chipaddr_y(cur.y),
	};

	showStatusMessage(cur_chipaddr);

	return;
}
// [ End of File ]
