/**@file
 *
 *@brief	xy coordinate treatment class (non-copy/constructor version for used in union)
 *@date		Mon,31 May,1999 - 14 Jun,1999
 *@date		Fri,20 Aug,1999 - Sun,22 Aug,1999
 *@date		Wed,29 Mar,2000 - Wed,12 Apr,2000
 *@date		Fri,06 Oct,2000
 *@date		Sat,28 Oct,2000 - Wed,01 Nov,2000
 *@date		Fri,24 Nov,2000 , Fri,01 Dec,2000
 *@date		Fri,01 Dec,2000 - Wed,06 Dec,2000
 *@date		Tue,26 Dec,2000 - Wed,27 Dec,2000
 *@date		Mon,25 Nov,2002 - Thr,19 Dec,2002
 *@date		Tue,07 Jan,2003, Wed,22 Jan,2003
 *@date		Sun,29 Oct,2006
 *@date		Thu,08 Feb,2007
 *@date		Sat,03 May,2008 - Sun,04 May,2008
 *@date		Fri,12 Sep,2008
 *@date		Sun,23 Jul,2017
 *@date		Sat,20 Feb,2021
 *@date		Sat,29 May,2021
 *
 *@author	Copyright(C)1996-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef XY__H
#define XY__H

#include <stdio.h>
#include <math.h>
#include "mytypes.h"

#if !defined(XY__INLINE)
# define	XY__INLINE
#else
# undef		XY__INLINE
# define	XY__INLINE	inline
#endif

#if !defined(_unused)
# define	_unused
#endif


template<class Type> class XY_{
	private:
	public:
		Type	x, y;

			// ٥ɽ
		XY__INLINE void		print( FILE* const fp, constString Format ) const noexcept;

			// 
		XY__INLINE XY_<Type>&	set( Type src ) noexcept;
		XY__INLINE XY_<Type>&	set( Type src_x, Type src_y ) noexcept;
		XY__INLINE XY_<Type>&	set( const Type* const src ) noexcept;
		XY__INLINE XY_<Type>&	set( const XY_<Type>& src ) noexcept;

			// 黻
		XY__INLINE bool			operator ==( const XY_<Type>& src ) const noexcept;
		XY__INLINE bool			operator !=( const XY_<Type>& src ) const noexcept;
		XY__INLINE bool			operator <( const XY_<Type>& src ) const noexcept;
		XY__INLINE bool			operator >( const XY_<Type>& src ) const noexcept;

			// §黻
		XY__INLINE XY_<Type>		operator +( void ) const noexcept;
		XY__INLINE XY_<Type>		operator -( void ) const noexcept;
		XY__INLINE XY_<Type>&		operator +=( const XY_<Type>& src ) noexcept;
		XY__INLINE XY_<Type>&		operator -=( const XY_<Type>& src ) noexcept;
		XY__INLINE XY_<Type>&		operator *=( const Type src ) noexcept;
		XY__INLINE XY_<Type>&		operator /=( const Type src ) noexcept;
		XY__INLINE XY_<Type>		operator +( const XY_<Type>& arg ) const noexcept;
		XY__INLINE XY_<Type>		operator -( const XY_<Type>& arg ) const noexcept;
		XY__INLINE XY_<Type>		operator *( const Type arg ) const noexcept;
		XY__INLINE XY_<Type>		operator /( const Type arg ) const noexcept;

			// Υ
//		XY__INLINE friend Type	operator  =( const XY_<Type>& src ) const noexcept;
		XY__INLINE Type			norm( void ) const noexcept;
		XY__INLINE double		norm( _unused double* const dst ) const noexcept;
		XY__INLINE float		norm( _unused float* const dst ) const noexcept;
		XY__INLINE long			norm( _unused long* const dst ) const noexcept;
	  #if !defined(_WIN32)
		XY__INLINE long long	norm( _unused long long* const dst ) const noexcept;
	  #endif

			// 
		XY__INLINE Type			InnerProduct( const XY_<Type>& arg ) const noexcept;
		XY__INLINE double		InnerProduct( const XY_<Type>& arg, _unused double* const dst ) const noexcept;
		XY__INLINE float		InnerProduct( const XY_<Type>& arg, _unused float* const dst ) const noexcept;
		XY__INLINE long			InnerProduct( const XY_<Type>& arg, _unused long* const dst ) const noexcept;
	  #if !defined(_WIN32)
		XY__INLINE long long	InnerProduct( const XY_<Type>& arg, _unused long long* const dst ) const noexcept;
	  #endif
		XY__INLINE Type			operator *( const XY_<Type>& arg ) const noexcept;
			// 
		XY__INLINE Type			OuterProduct( const XY_<Type>& arg ) const noexcept;
		XY__INLINE double		OuterProduct( const XY_<Type>& arg, _unused double* const dst ) const noexcept;
		XY__INLINE float		OuterProduct( const XY_<Type>& arg, _unused float* const dst ) const noexcept;
		XY__INLINE long			OuterProduct( const XY_<Type>& arg, _unused long* const dst ) const noexcept;
	  #if !defined(_WIN32)
		XY__INLINE long long	OuterProduct( const XY_<Type>& arg, _unused long long* const dst ) const noexcept;
	  #endif
//		XY__INLINE Type			operator *( const XY_<Type>& arg ) const noexcept;

			// ¾
		inline	Type&			operator[]( const int column ) const noexcept;
};



template<class Type> XY__INLINE void XY_<Type>::print( FILE* const fp, constString Format ) const noexcept
{
	fprintf(fp, Format, (*this).x );
	fprintf(fp, Format, (*this).y );
	fputs("\n", fp);
	return;
}


template<class Type> XY__INLINE XY_<Type>& XY_<Type>::set( Type src ) noexcept
{
	(*this).x = src;
	(*this).y = src;
	return *this;
}

template<class Type> XY__INLINE XY_<Type>& XY_<Type>::set( Type src_x, Type src_y ) noexcept
{
	(*this).x = src_x;
	(*this).y = src_y;
	return *this;
}

template<class Type> XY__INLINE XY_<Type>& XY_<Type>::set( const Type* const src ) noexcept
{
  #if defined(CHECK)
	if( !src ){
	  #if defined(USE_THROW)
		__STL_THROW(out_of_range("XY_:operator ="));
	  #else
		pr_debug(" XY_: %p->operator=: argument was NULL\n",
						this );
		abort();
	  #endif
	}
  #else
  #endif
	(*this).x = src[0];
	(*this).y = src[1];
	return *this;
}

template<class Type> XY__INLINE XY_<Type>& XY_<Type>::set( const XY_<Type> &src ) noexcept
{
	(*this).x = src.x;
	(*this).y = src.y;
	return *this;
}


template<class Type> XY__INLINE bool XY_<Type>::operator ==( const XY_<Type>& src ) const noexcept
{
	return ((*this).x == src.x) && ((*this).y == src.y);
}

template<class Type> XY__INLINE bool XY_<Type>::operator !=( const XY_<Type>& src ) const noexcept
{
	return !((*this) == src);
}

// for Sorting
template<class Type> XY__INLINE bool XY_<Type>::operator <( const XY_<Type>& src ) const noexcept
{
	return	( (*this).x == src.x )
			? ( (*this).y < src.y )
			: ( (*this).x < src.x );
}

// for Sorting
template<class Type> XY__INLINE bool XY_<Type>::operator >( const XY_<Type>& src ) const noexcept
{
	return	( (*this).x == src.x )
			? ( (*this).y > src.y )
			: ( (*this).x > src.x );
}


#if defined(COMPILER_SUPPORT_NRV)
template<class Type> XY__INLINE XY_<Type> XY_<Type>::operator +( void ) const noexcept return dst
#else
template<class Type> XY__INLINE XY_<Type> XY_<Type>::operator +( void ) const noexcept
#endif
{
  #if defined(COMPILER_SUPPORT_NRV)
  #else
	XY_<Type>	dst;
  #endif
	dst.x = (*this).x;
	dst.y = (*this).y;
	return dst;
}

#if defined(COMPILER_SUPPORT_NRV)
template<class Type> XY__INLINE XY_<Type> XY_<Type>::operator -( void ) const noexcept return dst
#else
template<class Type> XY__INLINE XY_<Type> XY_<Type>::operator -( void ) const noexcept
#endif
{
  #if defined(COMPILER_SUPPORT_NRV)
  #else
	XY_<Type>	dst;
  #endif
	dst.x = - (*this).x;
	dst.y = - (*this).y;
	return dst;
}


template<class Type> XY__INLINE XY_<Type>& XY_<Type>::operator +=( const XY_<Type> &src ) noexcept
{
	(*this).x += src.x;
	(*this).y += src.y;
	return *this;
}

template<class Type> XY__INLINE XY_<Type>& XY_<Type>::operator -=( const XY_<Type> &src ) noexcept
{
	(*this).x -= src.x;
	(*this).y -= src.y;
	return *this;
}

template<class Type> XY__INLINE XY_<Type>& XY_<Type>::operator *=( const Type src ) noexcept
{
	(*this).x *= src;
	(*this).y *= src;
	return *this;
}

template<class Type> XY__INLINE XY_<Type>& XY_<Type>::operator /=( const Type src ) noexcept
{
	(*this).x /= src;
	(*this).y /= src;
	return *this;
}


#if defined(COMPILER_SUPPORT_NRV)
template<class Type> XY__INLINE XY_<Type> XY_<Type>::operator +( const XY_<Type>& arg ) const noexcept return dst
#else
template<class Type> XY__INLINE XY_<Type> XY_<Type>::operator +( const XY_<Type>& arg ) const noexcept
#endif
{
  #if defined(COMPILER_SUPPORT_NRV)
  #else
	XY_<Type>	dst;
  #endif
	dst.x = (*this).x + arg.x;
	dst.y = (*this).y + arg.y;
	return dst;
}

#if defined(COMPILER_SUPPORT_NRV)
template<class Type> XY__INLINE XY_<Type> XY_<Type>::operator -( const XY_<Type>& arg ) const noexcept return dst
#else
template<class Type> XY__INLINE XY_<Type> XY_<Type>::operator -( const XY_<Type>& arg ) const noexcept
#endif
{
  #if defined(COMPILER_SUPPORT_NRV)
  #else
	XY_<Type>	dst;
  #endif
	dst.x = (*this).x - arg.x;
	dst.y = (*this).y - arg.y;
	return dst;
}

#if defined(COMPILER_SUPPORT_NRV)
template<class Type> XY__INLINE XY_<Type> XY_<Type>::operator *( const Type arg ) const noexcept return dst
#else
template<class Type> XY__INLINE XY_<Type> XY_<Type>::operator *( const Type arg ) const noexcept
#endif
{
  #if defined(COMPILER_SUPPORT_NRV)
  #else
	XY_<Type>	dst;
  #endif
	dst.x = (*this).x * arg;
	dst.y = (*this).y * arg;
	return dst;
}

#if defined(COMPILER_SUPPORT_NRV)
template<class Type> XY__INLINE XY_<Type> XY_<Type>::operator /( const Type arg ) const noexcept return dst
#else
template<class Type> XY__INLINE XY_<Type> XY_<Type>::operator /( const Type arg ) const noexcept
#endif
{
  #if defined(COMPILER_SUPPORT_NRV)
  #else
	XY_<Type>	dst;
  #endif
	dst.x = (*this).x / arg;
	dst.y = (*this).y / arg;
	return dst;
}


#if 0
template<class Type> XY__INLINE Type XY_<Type>::operator  =( const XY_<Type> &src ) noexcept
#endif
template<class Type> XY__INLINE Type XY_<Type>::norm( void ) const noexcept
{
	Type		ans;
	ans  = ((*this).x * (*this).x);
	ans += ((*this).y * (*this).y);
	return static_cast<Type>(sqrt(ans));
}

template<class Type> XY__INLINE double XY_<Type>::norm( _unused double* const dst ) const noexcept
{
	double		ans;
	ans  = (static_cast<double>((*this).x) * static_cast<double>((*this).x));
	ans += (static_cast<double>((*this).y) * static_cast<double>((*this).y));
	ans  = static_cast<double>(sqrt( ans ));
  #if defined(CHECK)
	if( dst ){
		(*dst) = ans;
	}
  #endif
	return ans;
}

template<class Type> XY__INLINE float XY_<Type>::norm( _unused float* const dst ) const noexcept
{
	float		ans;
	ans  = (static_cast<float>((*this).x) * static_cast<float>((*this).x));
	ans += (static_cast<float>((*this).y) * static_cast<float>((*this).y));
	ans  = static_cast<float>(sqrt( ans ));
  #if defined(CHECK)
	if( dst ){
		(*dst) = ans;
	}
  #endif
	return ans;
}

template<class Type> XY__INLINE long XY_<Type>::norm( _unused long* const dst ) const noexcept
{
	long		ans;
	ans  = (static_cast<long>((*this).x) * static_cast<long>((*this).x));
	ans += (static_cast<long>((*this).y) * static_cast<long>((*this).y));
	ans  = static_cast<long>(sqrt( ans ));
  #if defined(CHECK)
	if( dst ){
		(*dst) = ans;
	}
  #endif
	return ans;
}

#if !defined(_WIN32)
template<class Type> XY__INLINE long long XY_<Type>::norm( _unused long long* const dst ) const noexcept
{
	long long	ans;
	ans  = (static_cast<long long>((*this).x) * static_cast<long long>((*this).x));
	ans += (static_cast<long long>((*this).y) * static_cast<long long>((*this).y));
	ans  = static_cast<long long>(sqrt( ans ));
  #if defined(CHECK)
	if( dst ){
		(*dst) = ans;
	}
  #endif
	return ans;
}
#endif


#if defined(COMPILER_SUPPORT_NRV)
template<class Type> XY__INLINE Type XY_<Type>::InnerProduct( const XY_<Type>& arg ) const noexcept return ans
#else
template<class Type> XY__INLINE Type XY_<Type>::InnerProduct( const XY_<Type>& arg ) const noexcept
#endif
{
  #if defined(COMPILER_SUPPORT_NRV)
  #else
	Type		ans;
  #endif
	ans  = ((*this).x * arg.x);
	ans += ((*this).y * arg.y);
	return ans;
}

template<class Type> XY__INLINE double XY_<Type>::InnerProduct( const XY_<Type>& arg, _unused double* const dst ) const noexcept
{
	double		ans;
	ans  = (static_cast<double>((*this).x) * static_cast<double>(arg.x));
	ans += (static_cast<double>((*this).y) * static_cast<double>(arg.y));
  #if defined(CHECK)
	if( dst ){
		(*dst) = ans;
	}
  #endif
	return ans;
}

template<class Type> XY__INLINE float XY_<Type>::InnerProduct( const XY_<Type>& arg, _unused float* const dst ) const noexcept
{
	float		ans;
	ans  = (static_cast<float>((*this).x) * static_cast<float>(arg.x));
	ans += (static_cast<float>((*this).y) * static_cast<float>(arg.y));
  #if defined(CHECK)
	if( dst ){
		(*dst) = ans;
	}
  #endif
	return ans;
}

template<class Type> XY__INLINE long XY_<Type>::InnerProduct( const XY_<Type>& arg, _unused long* const dst ) const noexcept
{
	long		ans;
	ans  = (static_cast<long>((*this).x) * static_cast<long>(arg.x));
	ans += (static_cast<long>((*this).y) * static_cast<long>(arg.y));
  #if defined(CHECK)
	if( dst ){
		(*dst) = ans;
	}
  #endif
	return ans;
}

#if !defined(_WIN32)
template<class Type> XY__INLINE long long XY_<Type>::InnerProduct( const XY_<Type>& arg, _unused long long* const dst ) const noexcept
{
	long long	ans;
	ans  = (static_cast<long long>((*this).x) * static_cast<long long>(arg.x));
	ans += (static_cast<long long>((*this).y) * static_cast<long long>(arg.y));
  #if defined(CHECK)
	if( dst ){
		(*dst) = ans;
	}
  #endif
	return ans;
}
#endif

#if defined(COMPILER_SUPPORT_NRV)
template<class Type> XY__INLINE Type XY_<Type>::operator *( const XY_<Type>& arg ) const noexcept return ans
#else
template<class Type> XY__INLINE Type XY_<Type>::operator *( const XY_<Type>& arg ) const noexcept
#endif
{
  #if defined(COMPILER_SUPPORT_NRV)
  #else
	Type		ans;
  #endif
	ans  = ((*this).x * arg.x);
	ans += ((*this).y * arg.y);
	return ans;
}


#if 0
template<class Type> XY__INLINE Type XY_<Type>::operator *( const XY_<Type>& arg ) const noexcept return dst
#endif
#if defined(COMPILER_SUPPORT_NRV)
template<class Type> XY__INLINE Type XY_<Type>::OuterProduct( const XY_<Type>& arg ) const noexcept return dst
#else
template<class Type> XY__INLINE Type XY_<Type>::OuterProduct( const XY_<Type>& arg ) const noexcept
#endif
{
  #if defined(COMPILER_SUPPORT_NRV)
  #else
	Type		dst;
  #endif
	dst = ((*this).x * arg.y) - ((*this).y * arg.x);
	return dst;
}

template<class Type> XY__INLINE double XY_<Type>::OuterProduct( const XY_<Type>& arg, _unused double* const dst ) const noexcept
{
	double		ret;
	ret  = (static_cast<double>((*this).x) * static_cast<double>(arg.y));
	ret -= (static_cast<double>((*this).y) * static_cast<double>(arg.x));
  #if defined(CHECK)
	if( dst ){
		(*dst) = ret;
	}
  #endif
	return ret;
}

template<class Type> XY__INLINE float XY_<Type>::OuterProduct( const XY_<Type>& arg, _unused float* const dst ) const noexcept
{
	float		ret;
	ret  = (static_cast<float>((*this).x) * static_cast<float>(arg.y));
	ret -= (static_cast<float>((*this).y) * static_cast<float>(arg.x));
  #if defined(CHECK)
	if( dst ){
		(*dst) = ret;
	}
  #endif
	return ret;
}

template<class Type> XY__INLINE long XY_<Type>::OuterProduct( const XY_<Type>& arg, _unused long* const dst ) const noexcept
{
	long		ret;
	ret  = (static_cast<long>((*this).x) * static_cast<long>(arg.y));
	ret -= (static_cast<long>((*this).y) * static_cast<long>(arg.x));
  #if defined(CHECK)
	if( dst ){
		(*dst) = ret;
	}
  #endif
	return ret;
}

#if !defined(_WIN32)
template<class Type> XY__INLINE long long XY_<Type>::OuterProduct( const XY_<Type>& arg, _unused long long* const dst ) const noexcept
{
	long long	ret;
	ret  = (static_cast<long long>((*this).x) * static_cast<long long>(arg.y));
	ret -= (static_cast<long long>((*this).y) * static_cast<long long>(arg.x));
  #if defined(CHECK)
	if( dst ){
		(*dst) = ret;
	}
  #endif
	return ret;
}
#endif



template<class Type> inline Type& XY_<Type>::operator[]( const int column ) const noexcept
{
	switch( column ){
	case 0:		return x;
	case 1:		return y;
	default:
  #if defined(CHECK)
	  #if defined(USE_THROW)
		__STL_THROW(out_of_range("XY_:operator[]"));
	  #else
		pr_debug("XY_: %p->operator[%d]: Size over flow\n",
						this, column );
		abort();
	  #endif
  #endif
		break;
	}
	return 0.0;
}


#endif // XY__H
// [ End of File ]
