/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,06 Sep,2015 - Mon,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Sat,12 Sep,2015
 *@date		Sun,20 Sep,2015 - Tue,29 Sep,2015
 *@date		Sat,03 Oct,2015 - Sun,04 Oct,2015
 *@date		Sun,11 Oct,2015 - Mon,12 Oct,2015
 *@date		Wed,14 Oct,2015 - Fri,16 Oct,2015
 *@date		Sun,18 Oct,2015
 *@date		Mon,26 Oct,2015 - Thu,29 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sun,22 Nov,2015
 *@date		Sun,10 Jan,2016 - Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016 - Sun,14 Feb,2016
 *@date		Sun,16 Jul,2017
 *@date		Fri,21 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Mon,14 Aug,2017
 *@date		Fri,18 Aug,2017
 *@date		Sat,03 Mar,2018
 *@date		Sat,17 Mar,2018
 *@date		Sat,02 Jun,2018
 *@date		Sat,27 Oct,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Sat,19 Jan,2019
 *@date		Sun,20 Jan,2019
 *@date		Tue,29 Jan,2019
 *@date		Sat,16 Feb,2019
 *@date		Tue,19 Feb,2019
 *@date		Sun,13 Sep,2020
 *@date		Wed,16 Sep,2020
 *@date		Sun,18 Oct,2020
 *@date		Wed,28 Oct,2020
 *@date		Sat,31 Oct,2020
 *@date		Sun,08 Nov,2020
 *@date		Sun,15 Nov,2020
 *@date		Wed,18 Nov,2020
 *@date		Sat,21 Nov,2020
 *@date		Wed,02 Dec,2020
 *@date		Sun,27 Dec,2020
 *@date		Thu,18 Feb,2021
 *@date		Sat,20 Feb,2021
 *@date		Sun,21 Feb,2021
 *@date		Mon,22 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sun,23 May,2021
 *@date		Sat,05 Jun,2021
 *@date		Sun,26 Sep,2021
 *@date		Sun,10 Oct,2021
 *@date		Sat,30 Oct,2021
 *@date		Sat,06 Nov,2021
 *@date		Mon,21 Feb,2022
 *@date		Thu,07 Jul,2022
 *@date		Fri,08 Jul,2022
 *@date		Wed,13 Jul,2022
 *@date		Sun,17 Jul,2022
 *@date		Sun,24 Jul,2022
 *@date		Mon,09 Jan,2023
 *@date		Sat,18 Feb,2023
 *@date		Sat,25 Feb,2023
 *@date		Sat,22 Apr,2023
 *@date		Sat,27 May,2023
 *
 *@author	Copyright(C)2015-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "settings.h"
#include <QSettings>
#include <QTranslator>
#include <QPoint>
#include <QSize>

namespace Settings {

struct App_Config AppConfig;
App_Config::App_Config(void) noexcept
{
	OrgName = "gharena";
	AppName = "qrlmaker";
	HomePath = "";
	DefaultPath = "";
	return;
}

QSettings* ini = NULL;

extern const struct SettingsKeyValue_Key SettingsKey = {
	.mainwindow_settings = "mainwindow/settings",
	// .mainwindow_geometry = "mainwindow/geometry",
	.mainwindow_size = "mainwindow/size",
	.mainwindow_pos  = "mainwindow/pos",
	.mainwindow_centralwidget_size       = "mainwindow/centralwidget/size",
	//.mainwindow_gridLayout               = "mainwindow/gridLayout/size",
	//.mainwindow_gridLayout_0G            = "mainwindow/gridLayout_0G/size",
	.mainwindow_splitter_1V_size         = "mainwindow/splitter_1V/size",
	.mainwindow_splitter_2H_size         = "mainwindow/splitter_2H/size",
	.mainwindow_Form_TreeWidget_size     = "mainwindow/Form_TreeWidget/size",
	.mainwindow_layoutWidget             = "mainwindow/layoutWidget/size",
	//.mainwindow_gridLayout_3G            = "mainwindow/gridLayout_3G/size",
	.mainwindow_form_mainform_size       = "mainwindow/Form_MainForm/size",
	//.mainwindow_horizontalLayout         = "mainwindow/horizontalLayout/size",
	.mainwindow_horizontalSlider_size    = "mainwindow/horizontalSlider/size",
	.mainwindow_verticalScrollBar_size   = "mainwindow/verticalScrollBar/size",
	.mainwindow_horizontalScrollBar_size = "mainwindow/horizontalScrollBar/size",
	.mainwindow_listWidget_size          = "mainwindow/listWidget/size",
	.mainwindow_menubar_size             = "mainwindow/menubar/size",
	.mainwindow_statusbar_size           = "mainwindow/statusbar/size",
	//.mainwindow_splitter_1V_state = "mainwindow/splitter_1V/state",
	.mainwindow_splitter_1V_sizes = "mainwindow/splitter_1V/sizes/",
	//.mainwindow_splitter_2H_state = "mainwindow/splitter_2H/state",
	.mainwindow_splitter_2H_sizes = "mainwindow/splitter_2H/sizes/",
	.mainwindow_form_mainform_scaling_dB = "mainwindow/Form_MainForm/scaling_dB",
	.dialog_inputdialog_size = "dialog/inputDialog/size",
	.dialog_inputdialog_pos  = "dialog/inputDialog/pos",
	.dialog_listdialog_size = "dialog/listDialog/size",
	.dialog_listdialog_pos  = "dialog/listDialog/pos",
	.mainwindow_Form_TreeWidget_expanded = "mainwindow/Form_TreeWidget/expanded/",
	.mainwindow_DoubleClickInterval = "mainwindow/DoubleClickInterval",
	.mainwindow_DragScrollTimer = "mainwindow/DragScrollTimer",
};

struct SettingsKeyValue_Value SettingsCandidates = {
	.dialog_inputdialog_pos  = QPoint(-1, -1),
	.dialog_inputdialog_size = QSize(-1, -1),
	.dialog_listdialog_pos  = QPoint(-1, -1),
	.dialog_listdialog_size = QSize(-1, -1),
};

const struct Settings::QRLChip_Library::QRL_Syntax::QRL_Argument::QRL_Argument_Type_Num_List argument_type_num_list[] = {
	{
	  #if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
		.regex = "^[-+]{0,1}0([0-7]+)$",
	  #else
		.regex = "[-+]{0,1}0([0-7]+)",
	  #endif
		.syntax = "tonumber(\"###\", 8)",
		.argument = "###",
	},
	{
	  #if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
		.regex = "^[-+]{0,1}0b([0-1]+)$",
	  #else
		.regex = "[-+]{0,1}0b([0-1]+)",
	  #endif
		.syntax = "tonumber(\"###\", 2)",
		.argument = "###",
	},
	{
		.regex = "",
		.syntax = "",
		.argument = "",
	},
};

const struct QRLChip_Library QRLChipLibrary = {
	.tr_context = {
		.EditorCommand = "Editor Command",
		.ChipLabel = "QRL Chip Label",
		.ChipLibrary = "QRL Chip Library",
		.ChipArgument = "QRL Chip Argument",
		.ChipArgumentList = "QRL Chip Argument List",
	},
	.tr_disambiguation = {
		.Label = "Label",
		.Chip = "Chip",
		.ArgumentComment = "Argument Comment",
		.ArgumentList = "Argument List",
	},
	.LibraryFile = {
		.LuaChipDir = "./LuaChip/",
		.LuaContainer_Filename_Header = "container_header.lua",
		.LuaContainer_Filename_Stamp = "container_stamp.lua",
		.LuaContainer_Filename_Footer = "container_footer.lua",
		.LuaChip_Filename_Header = "chip",
		.LuaChip_Filename_Wildcard = "[0-9]*",
		.LuaChip_Filename_Label_ext = ".txt",
		.LuaChip_Filename_Chip_ext = ".lua",
		.LuaChip_Filename_Image_ext = ".png",
		.LuaChip_Filename_MaxNestLevel = 10,
	},
	.Syntax = {
		.Begin = "##begin##",
		.Body = "##body##",
		.End = "##end##",
		.Header = {
			.name = "name :",
			.size = "size :",
			.footprint = "footprint :",
			.footprint_header_substance = "-- ",
			.address = "address :",
			.chip_coordinates_tag = "chip_coordinates_tag :",
			.chip_number_tag = "chip_number_tag :",
			.chip_number = "chip_number :",
			.chip_footprint_tag = "chip_footprint_tag :",
			.next_address_condition_true_coordinates_tag = "next_address_condition_true_coordinates_tag :",
			.next_address_condition_true_tag = "next_address_condition_true_tag :",
			.next_address_condition_true = "next_address_condition_true :",
			.next_address_condition_false_coordinates_tag = "next_address_condition_false_coordinates_tag :",
			.next_address_condition_false_tag = "next_address_condition_false_tag :",
			.next_address_condition_false = "next_address_condition_false :",
			.argument_num = "argument :",
			.argument_comment = "argument_comment[",
			.argument_arg = "argument[",
			.argument_tag = "argument_tag[",
			.argument_tag_raw = "argument_tag_raw[",
			.argument_type = "argument_type[",
			.argument_type_kind = {
				{ QRLChip_Library::QRL_Syntax::QRL_Header::Argument_Type::VAR, "var", QT_TRANSLATE_NOOP("QRL Chip Argument", "Variable Name") },
				{ QRLChip_Library::QRL_Syntax::QRL_Header::Argument_Type::NUM, "num", QT_TRANSLATE_NOOP("QRL Chip Argument", "Integer Data Type") },
				{ QRLChip_Library::QRL_Syntax::QRL_Header::Argument_Type::VAR_NUM, "var-num", QT_TRANSLATE_NOOP("QRL Chip Argument", "Variable Name or Integer Data Type") },
				{ QRLChip_Library::QRL_Syntax::QRL_Header::Argument_Type::STRING, "str", QT_TRANSLATE_NOOP("QRL Chip Argument", "String Data Type") },
				{ QRLChip_Library::QRL_Syntax::QRL_Header::Argument_Type::LABEL, "label", QT_TRANSLATE_NOOP("QRL Chip Argument", "Label Data Type") },
				{ QRLChip_Library::QRL_Syntax::QRL_Header::Argument_Type::LIST, "list", QT_TRANSLATE_NOOP("QRL Chip Argument", "Select from List") },
				{ QRLChip_Library::QRL_Syntax::QRL_Header::Argument_Type::SENTINEL, "", QT_TRANSLATE_NOOP("QRL Chip Argument", "Unknown Data Type") },
			},
			.argument_type_selected = "argument_type_selected[",
			.argument_list = "argument_list[",
			.argument_position = "argument_position[",
			.argument_closebracket = "] :",
			.argument_geometry = "argument_geometry[",
		  #if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
			.argument_geometry_regex = "^argument_geometry[ \t]*\\[[ \t]*([0-9]+)[ \t]*\\][ \t]*:[ \t]*x[ \t]*:[ \t]*([0-9]+)[ \t]*,[ \t]*y[ \t]*:[ \t]*([0-9]+)[ \t]*,[ \t]*w[ \t]*:[ \t]*([0-9]+)[ \t]*,[ \t]*h[ \t]*:[ \t]*([0-9]+)$",
		  #else
			.argument_geometry_regex = "argument_geometry[ \t]*\\[[ \t]*([0-9]+)[ \t]*\\][ \t]*:[ \t]*x[ \t]*:[ \t]*([0-9]+)[ \t]*,[ \t]*y[ \t]*:[ \t]*([0-9]+)[ \t]*,[ \t]*w[ \t]*:[ \t]*([0-9]+)[ \t]*,[ \t]*h[ \t]*:[ \t]*([0-9]+)",
		  #endif
		},
		.Argument = {
		  #if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
			.regex_num = "^[-+]{0,1}(0|[1-9][0-9]*|[0-9]+\\.[0-9]*|0x[0-9a-fA-F]+|0[0-7]+|0b[0-1]+)$",
		  #else
			.regex_num = "[-+]{0,1}(0|[1-9][0-9]*|[0-9]+\\.[0-9]*|0x[0-9a-fA-F]+|0[0-7]+|0b[0-1]+)",
		  #endif
			.argument_type_num = argument_type_num_list,
		  #if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
			.regex_var = "^[^-+0-9'\" \\\\][^'\" \\\\]*$",
			.regex_str = "^[^'\"\\\\]*$",
			.regex_label = "^[_0-9a-zA-Z]+$",
		  #else
			.regex_var = "[^-+0-9'\" \\\\][^'\" \\\\]*",
			.regex_str = "[^'\"\\\\]*",
			.regex_label = "[_0-9a-zA-Z]+",
		  #endif
			.var_syntax = "g_Variable_Contents[\"###\"]",
			.var_argument = "###",
		},
		.Label_OutOfRange = "_outofrange",
	},
	.Limit = {
		.Number = {
			.Max = 9999,
			.Digit = 4,
		},
		.Address = {
			.Max = 999,
			.Digit = 3,
			.Base = 1000,
		},
		.Arrow = {
			.Max = 9999999,
			.Digit = 7,
		},
		.Undo = 100,
	},
	.Icon_size = QSize(8, 3),
};

const struct BuildImage_Info BuildImage = {
	.GaugeSize = 32,
	.EdgeSize = 4,
	.Chip = {
		.OverlappingSize = 0,
		.GapSize = 16,
		.CoreSize = 64,
		.Count = {
			.x = 100,
			.y = 100,
		},
	},
	.Color = {
		.Background = {
			.R = 0,
			.G = 0,
			.B = 0,
		},
		.GaugeText = {
			.R = 255,
			.G = 255,
			.B = 255,
		},
		.Line = {
			.R = 128,
			.G = 128,
			.B = 128,
		},
		.ChipText = {
			.R = 255,
			.G = 255,
			.B = 255,
		},
	},
	.Font = {
		.GaugeTextPointSize = 12,
		.GaugeTextLength = 3,
		.ChipTextPointSize = 23,
	},
};

const struct OverlayImage_Info OverlayImage = {
	.File = {
		.ImageDir = "./Image.qrlmaker/",
		.Cursor = {
			[Settings::OverlayImage_Info::CURSOR_TYPE_FOCUS] = "cursor_focus.png",
			[Settings::OverlayImage_Info::CURSOR_TYPE_SELECT] = "cursor_select.png",
			[Settings::OverlayImage_Info::CURSOR_TYPE_HIGHLIGHT] = "cursor_highlight.png",
		},
		.ArrowImage_True = "arrow_true_",
		.ArrowImage_False = "arrow_false_",
		.ArrowImage_Ext = "png",
	},
};

const struct QRLData_Info QRLData = {
	.File = {
		.DataDir = "./LuaData/",
		.Prefix = "QRL",
		.QRLMap_Ext = "lua",
		.QRLMap_Backup_Ext = "bak",
		.QRLMap_Image_Ext = "png",
	},
};

const struct EditorCommand EditorCommands[] = {
	{ EditorCommand::NORMAL, QT_TRANSLATE_NOOP("Editor Command", "Normal Mode"), },
	{ EditorCommand::SELECT, QT_TRANSLATE_NOOP("Editor Command", "Select Mode"), },
	{ EditorCommand::RECTANGULAR, QT_TRANSLATE_NOOP("Editor Command", "Rectangular Mode"), },
	{ EditorCommand::CUT, QT_TRANSLATE_NOOP("Editor Command", "Cut"), },
	{ EditorCommand::PASTE, QT_TRANSLATE_NOOP("Editor Command", "Paste"), },
	{ EditorCommand::DELETE, QT_TRANSLATE_NOOP("Editor Command", "Delete"), },
	{ EditorCommand::SET_ARROW_TRUE, QT_TRANSLATE_NOOP("Editor Command", "Set Arrow True Mode"), },
	{ EditorCommand::SET_ARROW_FALSE, QT_TRANSLATE_NOOP("Editor Command", "Set Arrow False Mode"), },
	{ EditorCommand::EDIT_ARGUMENT, QT_TRANSLATE_NOOP("Editor Command", "Edit Argument Mode"), },
	{ EditorCommand::NONE, NULL, },
};

struct Mouse_Info Mouse;
Mouse_Info::Mouse_Info(void) noexcept
{
	DoubleClickInterval = -1;
	DragScrollTimer = 500;
	return;
}

}

// [ End of File ]
