/**@file
 *
 *@brief	QRL Maker
 *@date		Wed,07 Oct,2015 - Mon,12 Oct,2015
 *@date		Tue,13 Oct,2015
 *@date		Thu,22 Oct,2015
 *@date		Wed,28 Oct,2015
 *@date		Thu,29 Nov,2018
 *@date		Fri,28 Dec,2018
 *@date		Fri,04 Jan,2019
 *@date		Sat,29 May,2021
 *
 *@author	Copyright(C)2015-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "settings.h"
#include "qrlmap.h"
#include <QStringList>

bool QRL::QRLMap::is_put(const QRL::ChipAddrXY& addr, const QRL::QRLChipLibrary* const chip) const noexcept
{
	assert (NULL != chip);

	const struct QRL::ChipAddrXY max = chip->size;
	QStringList::const_iterator it = chip->footprint->begin();
	for (QRL::ChipAddr y = 0; y < max.y; ++y, ++it) {
		for (QRL::ChipAddr x = 0; x < max.x; ++x) {
			if (QChar('#') == (*it)[static_cast<int>(x)]) {
				const QRL::ChipAddrXY ptr = {
					.x = static_cast<QRL::ChipAddr>(addr.x + x),
					.y = static_cast<QRL::ChipAddr>(addr.y + y),
				};
				if (QRLChipEmptyFlag != map(ptr)) {
					return false;
				}
			}
		}
	}
	return true;
}
// [ End of File ]
