/**@file
 *
 *@brief	QRL Maker
 *@date		Fri,11 Sep,2015
 *@date		Sat,29 May,2021
 *
 *@author	Copyright(C)2014-2021 G-HAL. All rights reserved.
 *@note	Bibliography: Copyright(C)2015 soramimi. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MYSTYLE_H
#define MYSTYLE_H

#include <QProxyStyle>
#include <QBrush>

namespace Ui {
class MyStyle;
}

class MyStyleTreeControl
{
public:
	explicit MyStyleTreeControl(void) noexcept;
	~MyStyleTreeControl(void) noexcept;
	bool drawPrimitive(QStyle::PrimitiveElement element, const QStyleOption* const option, QPainter* const painter, const QWidget* const widget = 0) const noexcept;

protected:

private:
	QBrush br_branch;
};


class MyStyle : public QProxyStyle
{
	Q_OBJECT

public:
	explicit MyStyle(void) noexcept;
	~MyStyle(void) noexcept;

	void drawPrimitive(PrimitiveElement element, const QStyleOption* const option, QPainter* const painter, const QWidget* const widget = 0) const noexcept;

protected:

private:
	MyStyleTreeControl mystyle_treeview;
};

#endif // MYSTYLE_H
// [ End of File ]
