/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015
 *@date		Mon,21 Sep,2015
 *@date		Sat,03 Oct,2015 - Mon,12 Oct,2015
 *@date		Tue,13 Oct,2015 - Sun,18 Oct,2015
 *@date		Thu,22 Oct,2015 - Sun,25 Oct,2015
 *@date		Thu,29 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sun,10 Jan,2016 - Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016
 *@date		Sun,09 Jul,2017
 *@date		Sun,16 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,17 Mar,2018
 *@date		Fri,23 Nov,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018 - Sun,30 Dec,2018
 *@date		Mon,31 Dec,2018
 *@date		Sat,19 Jan,2019
 *@date		Mon,21 Jan,2019
 *@date		Fri,25 Jan,2019
 *@date		Sun,27 Jan,2019
 *@date		Wed,17 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sun,23 May,2021
 *@date		Sat,29 May,2021
 *@date		Sun,30 May,2021
 *
 *@author	Copyright(C)2015-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MAPEDITOR_CLIPBOARD_H
#define MAPEDITOR_CLIPBOARD_H

#include "qrlmaker.h"
#include "qrl.h"
#include "qrlmap.h"
#include <QString>

class MapEditor_ClipBoard
{
public:
	explicit MapEditor_ClipBoard(const QRLMaker* const q) noexcept;
	~MapEditor_ClipBoard(void) noexcept;

	bool load(const QString& filename) noexcept(false);

	QRL::QRLChipList* list_(void) noexcept;
	QRL::QRLChipNumber maxlist(void) const noexcept;
	const QRL::QRLChip* ptr(QRL::QRLChipNumber num) const noexcept;
	QRL::QRLChip* ptr_(QRL::QRLChipNumber num) noexcept;
	const struct QRL::ChipAddrXY& ofs(void) const noexcept;
	struct QRL::ChipAddrXY& ofs_(void) noexcept;
	bool reallocate(struct QRL::ChipAddrXY* const ret_base_chipaddr) noexcept;
	void reset_ofs(void) noexcept;

private:
	QRL::QRLChipList list;
	struct QRL::ChipAddrXY ofs_addr;
};



inline bool MapEditor_ClipBoard::load(const QString& filename) noexcept(false)
{
	try {
		return list.load(filename);
	}
	catch (QStringList errmsg) {
		throw std::move(errmsg);
	}
	return false;
}

inline QRL::QRLChipList* MapEditor_ClipBoard::list_(void) noexcept
{
	return &list;
}

inline QRL::QRLChipNumber MapEditor_ClipBoard::maxlist(void) const noexcept
{
	return list.maxlist();
}

inline const QRL::QRLChip* MapEditor_ClipBoard::ptr(QRL::QRLChipNumber num) const noexcept
{
	return list.ptr(num);
}

inline QRL::QRLChip* MapEditor_ClipBoard::ptr_(QRL::QRLChipNumber num) noexcept
{
	return list.ptr_(num);
}

inline const struct QRL::ChipAddrXY& MapEditor_ClipBoard::ofs(void) const noexcept
{
	return ofs_addr;
}

inline struct QRL::ChipAddrXY& MapEditor_ClipBoard::ofs_(void) noexcept
{
	return ofs_addr;
}

inline bool MapEditor_ClipBoard::reallocate(struct QRL::ChipAddrXY* const ret_base_chipaddr) noexcept
{
	return list.reallocate(ret_base_chipaddr);
}

inline void MapEditor_ClipBoard::reset_ofs(void) noexcept
{
	ofs_addr.x = 0;
	ofs_addr.y = 0;
	return;
}

#endif // MAPEDITOR_CLIPBOARD_H
// [ End of File ]
