/**@file
 *
 *@brief	QRL Maker
 *@date		Sat,17 Mar,2018
 *@date		Fri,28 Dec,2018
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Wed,13 Jul,2022
 *
 *@author	Copyright(C)2018-2022 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QTreeWidgetItem>

void MainWindow::on_actionResetView_triggered(void) noexcept
{
	select_scaling_dB_reset();
	return;
}

void MainWindow::on_actionExpandView_triggered(void) noexcept
{
	select_scaling_dB_expand();
	return;
}

void MainWindow::on_actionShrinkView_triggered(void) noexcept
{
	select_scaling_dB_shrink();
	return;
}

void MainWindow::ExpandAll(QTreeWidgetItem* const item) noexcept
{
	ui->form_treewidget->expandItem(item);
	for (int i = 0; i < item->childCount(); ++i) {
		this->ExpandAll(item->child(i));
	}
	return;
}

void MainWindow::CollapseAll(QTreeWidgetItem* const item) noexcept
{
	ui->form_treewidget->collapseItem(item);
	for (int i = 0; i < item->childCount(); ++i) {
		this->CollapseAll(item->child(i));
	}
	return;
}

void MainWindow::on_actionExpand_All_triggered(void) noexcept
{
	QList<QTreeWidgetItem *> selected_list = ui->form_treewidget->selectedItems();
	if (selected_list.length() < 1) {
		return;
	}

	this->ExpandAll(selected_list[0]);
	return;
}

void MainWindow::on_actionCollapse_All_triggered(void) noexcept
{
	QList<QTreeWidgetItem *> selected_list = ui->form_treewidget->selectedItems();
	if (selected_list.length() < 1) {
		return;
	}

	this->CollapseAll(selected_list[0]);
	return;
}

bool MainWindow::select_form_treeitem_expand_All(void) noexcept
{
	QList<QTreeWidgetItem *> selected_list = ui->form_treewidget->selectedItems();
	if (selected_list.length() < 1) {
		return false;
	}

	this->ExpandAll(selected_list[0]);
	return true;
}

bool MainWindow::select_form_treeitem_collapse_All(void) noexcept
{
	QList<QTreeWidgetItem *> selected_list = ui->form_treewidget->selectedItems();
	if (selected_list.length() < 1) {
		return false;
	}

	this->CollapseAll(selected_list[0]);
	return true;
}

bool MainWindow::select_form_treeitem_expand(void) noexcept
{
	QList<QTreeWidgetItem *> selected_list = ui->form_treewidget->selectedItems();
	if (selected_list.length() < 1) {
		return false;
	}

	ui->form_treewidget->expandItem(selected_list[0]);
	return true;
}

bool MainWindow::select_form_treeitem_collapse(void) noexcept
{
	QList<QTreeWidgetItem *> selected_list = ui->form_treewidget->selectedItems();
	if (selected_list.length() < 1) {
		return false;
	}

	ui->form_treewidget->collapseItem(selected_list[0]);
	return true;
}

// [ End of File ]
