/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,11 Oct,2015 - Sat,17 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Thu,29 Oct,2015
 *@date		Sun,09 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,17 Mar,2018
 *@date		Mon,24 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Sun,30 Dec,2018
 *@date		Sun,27 Dec,2020
 *@date		Tue,23 Feb,2021
 *@date		Sat,27 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Sun,30 May,2021
 *
 *@author	Copyright(C)2015-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QTranslator>
#include <QDateTime>

void MainWindow::on_action_ModeCancel_triggered(void) noexcept
{
	ui->form_mainform->action_cancel();
	return;
}

void MainWindow::on_actionSelect_All_triggered(void) noexcept
{
	ui->form_mainform->action_selectall();
	return;
}

void MainWindow::on_actionUnselect_All_triggered(void) noexcept
{
	ui->form_mainform->action_unselectall();
	return;
}

void MainWindow::on_action_Undo_triggered(void) noexcept
{
	const bool ret = ui->form_mainform->action_undo();
	if (!ret) {
		Write_ErrorConsole(QDateTime::currentDateTime().toString(QObject::tr("ddd,dd MMM,yyyy hh:mm:ss")) + " "
						   + tr("Can not undo."));
	}
	return;
}

void MainWindow::on_action_Redo_triggered(void) noexcept
{
	const bool ret = ui->form_mainform->action_redo();
	if (!ret) {
		Write_ErrorConsole(QDateTime::currentDateTime().toString(QObject::tr("ddd,dd MMM,yyyy hh:mm:ss")) + " "
						   + tr("Can not redo."));
	}
	return;
}

void MainWindow::on_action_Cut_triggered(void) noexcept
{
	ui->form_mainform->action_cut();
	return;
}

void MainWindow::on_action_Copy_triggered(void) noexcept
{
	ui->form_mainform->action_copy();
	return;
}

void MainWindow::on_action_Paste_triggered(void) noexcept
{
	select_form_treeitem(Settings::EditorCommand::PASTE);
	ui->form_mainform->select_form_treeitem(Settings::EditorCommand::PASTE, NULL);
	ui->form_mainform->action_paste();
	return;
}

void MainWindow::on_action_Delete_triggered(void) noexcept
{
	ui->form_mainform->action_delete();
	return;
}
// [ End of File ]
