/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,10 Aug,2014
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015
 *@date		Thu,17 Sep,2015
 *@date		Mon,21 Sep,2015
 *@date		Sat,03 Oct,2015
 *@date		Sun,11 Oct,2015
 *@date		Fri,16 Oct,2015 - Sat,17 Oct,2015
 *@date		Thu,22 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Thu,29 Oct,2015
 *@date		Sun,16 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,17 Mar,2018
 *@date		Fri,23 Nov,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Mon,16 Nov,2020
 *@date		Thu,19 Nov,2020 - Fri,20 Nov,2020
 *@date		Wed,17 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Sat,20 Feb,2021
 *@date		Mon,22 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Thu,25 Feb,2021
 *@date		Fri,26 Feb,2021
 *@date		Sat,27 Feb,2021
 *@date		Sun,28 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Sun,30 May,2021
 *@date		Thu,03 Jun,2021
 *@date		Fri,04 Jun,2021
 *@date		Sun,12 Dec,2021
 *@date		Wed,13 Jul,2022
 *@date		Sat,16 Jul,2022
 *@date		Thu,16 Feb,2023
 *@date		Fri,28 Apr,2023
 *@date		Sat,27 May,2023
 *@date		Thu,02 Nov,2023
 *
 *@author	Copyright(C)2014-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <cstdint>
#include "settings.h"
#include "qrlmaker.h"
#include "qrl.h"
#include <QMainWindow>
#include <QWidget>
#include <QString>
#include <QStringList>
#include <QLabel>
#include <QTreeWidgetItem>
#include <QPoint>
#include <QMenu>

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
	Q_OBJECT

public:
	explicit MainWindow(QRLMaker* const q, QWidget* parent = 0) noexcept;
	~MainWindow(void) noexcept;

	void Write_ErrorConsole(QString msg) noexcept;
	void Write_ErrorConsole(QStringList& msg) noexcept;

	bool set_windowtitle(void) noexcept;
	void clear_edited(int_fast8_t ptr) noexcept;
	void set_edited(int_fast8_t ptr) noexcept;
	bool is_edited(void) const noexcept;
	bool open(QString& strFName) noexcept;

	float get_dB2scale(void) const noexcept;
	float get_scale2dB(float arg) const noexcept;
	void draw_ScaleLabel() noexcept;
	bool select_scaling_dB_reset(void) noexcept;
	bool select_scaling_dB_expand(void) noexcept;
	bool select_scaling_dB_shrink(void) noexcept;
	bool select_form_treeitem(enum Settings::EditorCommand::EditorCommand_TYPE mode_arg) noexcept;
	bool select_form_treeitem_prev(void) noexcept;
	bool select_form_treeitem_next(void) noexcept;
	bool select_form_treeitem_expand_All(void) noexcept;
	bool select_form_treeitem_collapse_All(void) noexcept;
	bool select_form_treeitem_expand(void) noexcept;
	bool select_form_treeitem_collapse(void) noexcept;

	void set_statusBar1(const QString& str) noexcept;
	void set_statusBar2(const QString& str) noexcept;
	int get_horizontalScrollBar(void) const noexcept;
	int get_verticalScrollBar(void) const noexcept;
	void set_horizontalScrollBar(int pos) noexcept;
	void set_verticalScrollBar(int pos) noexcept;

protected:
	void showEvent(QShowEvent* const e) noexcept;
	void paintEvent(QPaintEvent* const e) noexcept;
	bool question_triggered(void) noexcept;

private slots:
	void on_action_New_triggered(void) noexcept;
	void on_actionNew_Window_triggered(void) noexcept;
	void on_action_Open_triggered(void) noexcept;
	void on_actionOpen_New_Window_triggered(void) noexcept;
	void on_action_Import_triggered(void) noexcept;
	void on_action_Save_triggered(void) noexcept;
	void on_actionSave_as_triggered(void) noexcept;
	void on_actionReload_Settings_triggered(void) noexcept;
	void on_actionSave_Settings_triggered(void) noexcept;
	void on_action_Close_triggered(void) noexcept;
	void on_action_Quit_triggered(void) noexcept;

	void on_actionSelect_All_triggered(void) noexcept;
	void on_actionUnselect_All_triggered(void) noexcept;
	void on_action_Undo_triggered(void) noexcept;
	void on_action_Redo_triggered(void) noexcept;
	void on_action_Cut_triggered(void) noexcept;
	void on_action_Copy_triggered(void) noexcept;
	void on_action_Paste_triggered(void) noexcept;
	void on_action_Delete_triggered(void) noexcept;

	void on_actionResetView_triggered(void) noexcept;
	void on_actionExpandView_triggered(void) noexcept;
	void on_actionShrinkView_triggered(void) noexcept;

	void on_actionExpand_All_triggered(void) noexcept;
	void on_actionCollapse_All_triggered(void) noexcept;

	void on_action_ModeCancel_triggered(void) noexcept;

	void menu_UndoHistory_show(void) noexcept;
	void menu_UndoHistory_do(int_fast8_t ptr) noexcept;

	void menu_Windows_show(void) noexcept;

	void on_action_About_triggered(void) noexcept;
	void on_action_AboutQt_triggered(void) noexcept;

	void scaling_dB_changed(void) noexcept;
	void select_form_treeitem(void) noexcept;

	void on_form_mainform_customContextMenuRequested(const QPoint &pos) noexcept;
	void on_form_treewidget_customContextMenuRequested(const QPoint &pos) noexcept;

	void contextmenu_Cancel(void) noexcept;
	void contextmenu_Normal(void) noexcept;
	void contextmenu_Select(void) noexcept;
	void contextmenu_Rectangular(void) noexcept;
	void contextmenu_Cut(void) noexcept;
	void contextmenu_Paste(void) noexcept;
	void contextmenu_Delete(void) noexcept;
	void contextmenu_SetArrowTrue(void) noexcept;
	void contextmenu_SetArrowFalse(void) noexcept;
	void contextmenu_EditArgument(void) noexcept;

private:
	Ui::MainWindow *ui;

	void init_form_treeview(void) noexcept;

	void ExpandAll(QTreeWidgetItem* const item) noexcept;
	void CollapseAll(QTreeWidgetItem* const item) noexcept;

	bool is_duplicate_dialog(const QString& strFName, bool check_this_whidow) const noexcept;

	QRLMaker* qrlmaker;

	bool needRefresh;

	QLabel statusBar1;
	QLabel statusBar2;

	int_fast8_t saved_ptr;
	QString filename;

	QTreeWidgetItem* item_of_EditorCommand;

	QMenu Form_MainFormContextMenu;
	QMenu Form_TreeWidgetContextMenu;
};



inline void MainWindow::clear_edited(int_fast8_t ptr) noexcept
{
	saved_ptr = ptr;
	return;
}

inline void MainWindow::set_edited(int_fast8_t ptr) noexcept
{
	if (saved_ptr == ptr) {
		saved_ptr = -1;
	}
	return;
}

inline void MainWindow::set_statusBar1(const QString& str) noexcept
{
	statusBar1.setText(str);
	return;
}

inline void MainWindow::set_statusBar2(const QString& str) noexcept
{
	statusBar2.setText(str);
	return;
}

#endif // MAINWINDOW_H
// [ End of File ]
