/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,10 Aug,2014
 *@date		Thu,28 May,2015 - Sun,31 May,2015
 *@date		Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Tue,15 Sep,2015
 *@date		Thu,17 Sep,2015
 *@date		Sat,19 Sep,2015
 *@date		Sat,03 Oct,2015
 *@date		Sat,17 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sun,10 Jan,2016
 *@date		Sun,09 Jul,2017
 *@date		Sun,16 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,17 Mar,2018
 *@date		Fri,23 Nov,2018
 *@date		Mon,24 Dec,2018
 *@date		Mon,16 Nov,2020
 *@date		Thu,19 Nov,2020 - Fri,20 Nov,2020
 *@date		Sun,27 Dec,2020
 *@date		Wed,17 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Sat,20 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,27 Feb,2021
 *@date		Sun,23 May,2021
 *@date		Mon,24 May,2021
 *@date		Fri,28 May,2021
 *@date		Sat,29 May,2021
 *@date		Sun,30 May,2021
 *@date		Thu,03 Jun,2021
 *@date		Fri,04 Jun,2021
 *@date		Wed,13 Jul,2022
 *@date		Sat,16 Jul,2022
 *@date		Sun,17 Jul,2022
 *@date		Thu,16 Feb,2023
 *@date		Fri,28 Apr,2023
 *@date		Sat,27 May,2023
 *
 *@author	Copyright(C)2014-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "qrl.h"
#include "qrlmaker.h"
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QString>
#include <QStringList>
#include <QTranslator>
#include <QListWidgetItem>

void MainWindow::Write_ErrorConsole(QString msg) noexcept
{
	QListWidgetItem* const qlw = new(std::nothrow) QListWidgetItem(msg);
	assert (NULL != qlw);
	ui->listWidget->addItem(qlw);
	ui->listWidget->scrollToItem(qlw);
	return;
}

void MainWindow::Write_ErrorConsole(QStringList& msgs) noexcept
{
	for (QStringList::const_iterator itr = msgs.constBegin(); itr != msgs.constEnd(); ++itr) {
		Write_ErrorConsole(*itr);
	}
	return;
}

bool MainWindow::is_edited(void) const noexcept
{
	const int_fast8_t ptr = ui->form_mainform->get_undo_ptr();
	if (ptr < 0) {
		return true;
	}
	if (saved_ptr == ptr) {
		return false;
	}
	return true;
}

bool MainWindow::open(QString& strFName) noexcept
{
	const bool ret = ui->form_mainform->action_open(strFName);
	if (!ret) {
		filename = "";
		set_windowtitle();
		Write_ErrorConsole(QDateTime::currentDateTime().toString(QObject::tr("ddd,dd MMM,yyyy hh:mm:ss")) + " "
								  + tr("Failed to open a file '%1' in a new window.").arg(strFName));
	} else {
		filename = strFName;
		set_windowtitle();
		Write_ErrorConsole(QDateTime::currentDateTime().toString(QObject::tr("ddd,dd MMM,yyyy hh:mm:ss")) + " "
								  + tr("A file '%1' was opened.").arg(filename));
	}
	return ret;
}

int MainWindow::get_horizontalScrollBar(void) const noexcept
{
	return ui->horizontalScrollBar->sliderPosition();
}

int MainWindow::get_verticalScrollBar(void) const noexcept
{
	return ui->verticalScrollBar->sliderPosition();
}

void MainWindow::set_horizontalScrollBar(int pos) noexcept
{
	ui->horizontalScrollBar->setSliderPosition(pos);
	return;
}

void MainWindow::set_verticalScrollBar(int pos) noexcept
{
	ui->verticalScrollBar->setSliderPosition(pos);
	return;
}

MainWindow::MainWindow(QRLMaker* q, QWidget* parent) noexcept :
	QMainWindow(parent),
	ui(new(std::nothrow) Ui::MainWindow),
	qrlmaker(NULL),
	statusBar1(this),
	statusBar2(this),
	item_of_EditorCommand(NULL)
{
	assert (NULL != q);
	assert (NULL != ui);

	qrlmaker = q;

	filename = "";

	ui->setupUi(this);

	ui->form_mainform->setMainWindow(qrlmaker, this);
	clear_edited(ui->form_mainform->get_undo_ptr());

	{
		ui->statusbar->addWidget(&statusBar1, 100);
		ui->statusbar->addPermanentWidget(&statusBar2, 100);
	}

	this->init_form_treeview();

	this->scaling_dB_changed();
	this->needRefresh = true;

	{
		Form_MainFormContextMenu.addAction(tr("Mode Cancel"), this, SLOT(contextmenu_Cancel()));
		Form_MainFormContextMenu.addSeparator();
		Form_MainFormContextMenu.addAction(tr("Select All"), this, SLOT(on_actionSelect_All_triggered()));
		Form_MainFormContextMenu.addAction(tr("Unselect All"), this, SLOT(on_actionUnselect_All_triggered()));
		Form_MainFormContextMenu.addSeparator();
		Form_MainFormContextMenu.addAction(tr("Undo"), this, SLOT(on_action_Undo_triggered()));
		Form_MainFormContextMenu.addAction(tr("Redo"), this, SLOT(on_action_Redo_triggered()));
		Form_MainFormContextMenu.addSeparator();
		Form_MainFormContextMenu.addAction(tr("Cut"), this, SLOT(on_action_Cut_triggered()));
		Form_MainFormContextMenu.addAction(tr("Copy"), this, SLOT(on_action_Copy_triggered()));
		Form_MainFormContextMenu.addAction(tr("Paste"), this, SLOT(on_action_Paste_triggered()));
		Form_MainFormContextMenu.addAction(tr("Delete"), this, SLOT(on_action_Delete_triggered()));
		Form_MainFormContextMenu.addSeparator();
		Form_MainFormContextMenu.addAction(tr("Reset View Scaling"), this, SLOT(on_actionResetView_triggered()));
		Form_MainFormContextMenu.addAction(tr("Expand View Scaling"), this, SLOT(on_actionExpandView_triggered()));
		Form_MainFormContextMenu.addAction(tr("Shrink View Scaling"), this, SLOT(on_actionShrinkView_triggered()));
		Form_MainFormContextMenu.addSeparator();
		Form_MainFormContextMenu.addAction(tr("Normal Mode"), this, SLOT(contextmenu_Normal()));
		Form_MainFormContextMenu.addAction(tr("Select Mode"), this, SLOT(contextmenu_Select()));
		Form_MainFormContextMenu.addAction(tr("Rectangular Mode"), this, SLOT(contextmenu_Rectangular()));
		Form_MainFormContextMenu.addAction(tr("Set Arrow True Mode"), this, SLOT(contextmenu_SetArrowTrue()));
		Form_MainFormContextMenu.addAction(tr("Set Arrow False Mode"), this, SLOT(contextmenu_SetArrowFalse()));
		Form_MainFormContextMenu.addAction(tr("Edit Argument Mode"), this, SLOT(contextmenu_EditArgument()));
	}
	{
		Form_TreeWidgetContextMenu.addAction(tr("Expand All"), this, SLOT(on_actionExpand_All_triggered()));
		Form_TreeWidgetContextMenu.addAction(tr("Collapse All"), this, SLOT(on_actionCollapse_All_triggered()));
	}

	return;
}

MainWindow::~MainWindow(void) noexcept
{
	assert (NULL != ui);
	assert (NULL != qrlmaker);
	assert (NULL != item_of_EditorCommand);

	delete item_of_EditorCommand;
	delete ui;

	qrlmaker->close_window(this);

	return;
}
// [ End of File ]
