/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Sat,19 Sep,2015
 *@date		Sun,20 Sep,2015
 *@date		Sat,03 Oct,2015 - Sat,10 Oct,2015
 *@date		Tue,13 Oct,2015 - Thu,15 Oct,2015
 *@date		Sun,18 Oct,2015
 *@date		Thu,22 Oct,2015 - Sun,25 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Wed,28 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sat,07 Nov,2015
 *@date		Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016 - Sun,14 Feb,2016
 *@date		Sun,16 Apr,2017
 *@date		Sun,09 Jul,2017
 *@date		Sat,15 Jul,2017
 *@date		Sun,16 Jul,2017 - Mon,17 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,05 Aug,2017
 *@date		Sat,17 Mar,2018
 *@date		Mon,16 Jul,2018
 *@date		Sat,21 Jul,2018
 *@date		Sat,27 Oct,2018
 *@date		Fri,23 Nov,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Fri,21 Dec,2018
 *@date		Sat,22 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Sun,30 Dec,2018
 *@date		Mon,31 Dec,2018
 *@date		Mon,21 Jan,2019
 *@date		Fri,25 Jan,2019
 *@date		Sun,27 Jan,2019
 *@date		Tue,29 Jan,2019
 *@date		Tue,19 Feb,2019
 *@date		Wed,17 Feb,2021
 *@date		Thu,18 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Sat,20 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Thu,07 Jul,2022
 *@date		Wed,13 Jul,2022
 *@date		Sun,29 Jan,2023
 *@date		Sun,25 Jun,2023
 *
 *@author	Copyright(C)2015-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include <cstdint>
#include <stdio.h>
#include "settings.h"
#include "qrlmaker.h"
#include "mapeditor.h"
#include "imagebuilder.h"
#include "qrl.h"
#include "qrlmap.h"
#include <QPainter>
#include <QImage>
#include <QRgb>
#include <QPen>
#include <QColor>
#include <QFont>
#include "xy_.h"

void ImageBuilder_QRLMap_OverlayImage::MakeOverlayImage(const int blink_color, enum Settings::EditorCommand::EditorCommand_TYPE edit_mode, enum MapEditor_Type::MouseMode edit_type, const XY_<int_fast32_t>& screen_size, const XY_<int_fast16_t>& screen_ofs, const struct QRL::ChipAddrXY& cur_chipaddr, const QRL::ChipArrow& arrow, const struct QRL::ChipAddrXY& cur_arrowaddr, const struct QRL::ChipAddrXY& focus_addr) noexcept
{
	const XY_<int_fast32_t> base = {
		.x = static_cast<int_fast32_t>(screen_ofs.x) * ScreenParam()->scs.x,
		.y = static_cast<int_fast32_t>(screen_ofs.y) * ScreenParam()->scs.y,
	};
	const struct QRL::ChipAddrXY chipaddr_ofs = {
		.x = static_cast<QRL::ChipAddr>(- screen_ofs.x),
		.y = static_cast<QRL::ChipAddr>(- screen_ofs.y),
	};

	if (NULL == img_buffer) {
		img_buffer = new(std::nothrow) QImage(screen_size.x, screen_size.y, QImage::Format_RGB32);
		assert (NULL != img_buffer);
	}

	{
		*img_buffer = img_base->copy(base.x, base.y, screen_size.x, screen_size.y);
	}

	QPainter painter(img_buffer);
	{
		const uint_fast8_t r = Settings::BuildImage.Color.ChipText.R;
		const uint_fast8_t g = Settings::BuildImage.Color.ChipText.G;
		const uint_fast8_t b = Settings::BuildImage.Color.ChipText.B;
		painter.setPen(QPen(QColor(r, g, b), 1, Qt::SolidLine));
		QFont ft = painter.font();
		ft.setPointSizeF(Settings::BuildImage.Font.ChipTextPointSize * scaling());
		painter.setFont(ft);
	}
	const int_fast16_t cw = ScreenParam()->gap.x + ScreenParam()->core.x + ScreenParam()->gap.x + 1;
	const int_fast16_t ch = ScreenParam()->gap.y + ScreenParam()->core.y + ScreenParam()->gap.y + 1;
	const QImage img_tmp_focuscursor = qrlmaker->Cursor(Settings::OverlayImage_Info::CURSOR_TYPE_FOCUS)->scaled(cw, ch, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
	const QImage img_tmp_selectcursor = qrlmaker->Cursor(Settings::OverlayImage_Info::CURSOR_TYPE_SELECT)->scaled(cw, ch, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
	const QImage img_tmp_highlightcursor = qrlmaker->Cursor(Settings::OverlayImage_Info::CURSOR_TYPE_HIGHLIGHT)->scaled(cw, ch, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);

	switch (edit_mode) {
	case Settings::EditorCommand::NONE:
		draw_chipcursor_highlight(painter, chipaddr_ofs, &img_tmp_highlightcursor);
		break;
	case Settings::EditorCommand::NORMAL:
		switch (mapeditor->SimpleCommandMode()) {
		case MapEditor_Type::SIMPLECOMMAND_NONE:
			draw_chipcursor_highlight(painter, chipaddr_ofs, &img_tmp_highlightcursor);
			break;
		case MapEditor_Type::SIMPLECOMMAND_DRAG:
			{
				draw_chipcursor_highlight(painter, chipaddr_ofs, &img_tmp_highlightcursor);
				if ((0 <= cur_chipaddr.x) && (0 <= cur_chipaddr.y)) {
					for (QRL::QRLChipNumber i = 0; i < mapeditor->Clipboard4drag()->maxlist(); ++i) {
						const QRL::QRLChip* const ptr = mapeditor->Clipboard4drag()->ptr(i);
						assert (NULL != ptr);
						if (ptr->chip_number <= 0) {
							continue;
						}

						const QRL::QRLChipLibrary* const chip = qrlmaker->QRLLibrary()->chipSearch(ptr->name);
						assert (NULL != chip);
						const struct QRL::ChipAddrXY addr = (cur_chipaddr + ptr->addr + mapeditor->Clipboard4drag()->ofs());
						if (!mapeditor->QRLMap().is_put(addr, chip)) {
							goto DRAWOVERLAY_SIMPLECOMMAND_PASTE_FALSE;
						}
					}
					{
						const struct QRL::ChipAddrXY ofs = (chipaddr_ofs + cur_chipaddr + mapeditor->Clipboard4drag()->ofs());
						for (QRL::QRLChipNumber i = 0; i < mapeditor->Clipboard4drag()->maxlist(); ++i) {
							const QRL::QRLChip* const ptr = mapeditor->Clipboard4drag()->ptr(i);
							assert (NULL != ptr);
							if (ptr->chip_number <= 0) {
								continue;
							}

							draw_chip_wo_arrow(painter, blink_color, ofs, ptr);
							draw_chipcursor(painter, ofs, ptr, &img_tmp_selectcursor);
						}
						for (QRL::QRLChipNumber i = 0; i < mapeditor->Clipboard4drag()->maxlist(); ++i) {
							const QRL::QRLChip* const ptr = mapeditor->Clipboard4drag()->ptr(i);
							assert (NULL != ptr);
							if (ptr->chip_number <= 0) {
								continue;
							}

							draw_chip_only_arrow(painter, ofs, ptr);
						}
					}
				  DRAWOVERLAY_SIMPLECOMMAND_PASTE_FALSE:
					;
				}
			}
			break;
		case MapEditor_Type::SIMPLECOMMAND_RECTANGULAR:
			{
				draw_chipcursor_highlight(painter, chipaddr_ofs, &img_tmp_highlightcursor);
				if ((MapEditor_Type::MOUSE_LEFT_PRESS == edit_type) || (MapEditor_Type::MOUSE_LEFT_PRESS_W_CTRL == edit_type) || (MapEditor_Type::MOUSE_LEFT_DRAG == edit_type) || (MapEditor_Type::MOUSE_LEFT_DRAG_W_CTRL == edit_type)) {
					const struct QRL::ChipAddrXY st = {
						.x = IMIN(mapeditor->Drag_ChipAddr().x, cur_chipaddr.x),
						.y = IMIN(mapeditor->Drag_ChipAddr().y, cur_chipaddr.y),
					};
					const struct QRL::ChipAddrXY ed = {
						.x = IMAX(mapeditor->Drag_ChipAddr().x, cur_chipaddr.x),
						.y = IMAX(mapeditor->Drag_ChipAddr().y, cur_chipaddr.y),
					};
					struct QRL::ChipAddrXY cur;
					for (cur.y = st.y; cur.y <= ed.y; ++cur.y) {
						for (cur.x = st.x; cur.x <= ed.x; ++cur.x) {
							draw_cursor_raw(painter, (chipaddr_ofs + cur), &img_tmp_selectcursor);
						}
					}
				}
			}
			break;
		}
		break;
	case Settings::EditorCommand::SELECT:
		{
			draw_chipcursor_highlight(painter, chipaddr_ofs, &img_tmp_highlightcursor);
			if ((0 <= cur_chipaddr.x) && (0 <= cur_chipaddr.y)) {
				draw_cursor_raw(painter, (chipaddr_ofs + cur_chipaddr), &img_tmp_highlightcursor);
			}
		}
		break;
	case Settings::EditorCommand::RECTANGULAR:
		{
			draw_chipcursor_highlight(painter, chipaddr_ofs, &img_tmp_highlightcursor);
			if ((MapEditor_Type::MOUSE_LEFT_PRESS == edit_type) || (MapEditor_Type::MOUSE_LEFT_PRESS_W_CTRL == edit_type) || (MapEditor_Type::MOUSE_LEFT_DRAG == edit_type) || (MapEditor_Type::MOUSE_LEFT_DRAG_W_CTRL == edit_type)) {
				const struct QRL::ChipAddrXY st = {
					.x = IMIN(mapeditor->Drag_ChipAddr().x, cur_chipaddr.x),
					.y = IMIN(mapeditor->Drag_ChipAddr().y, cur_chipaddr.y),
				};
				const struct QRL::ChipAddrXY ed = {
					.x = IMAX(mapeditor->Drag_ChipAddr().x, cur_chipaddr.x),
					.y = IMAX(mapeditor->Drag_ChipAddr().y, cur_chipaddr.y),
				};
				struct QRL::ChipAddrXY cur;
				for (cur.y = st.y; cur.y <= ed.y; ++cur.y) {
					for (cur.x = st.x; cur.x <= ed.x; ++cur.x) {
						draw_cursor_raw(painter, (chipaddr_ofs + cur), &img_tmp_selectcursor);
					}
				}
			}
		}
		break;
	case Settings::EditorCommand::CUT:
		{
			if ((0 <= cur_chipaddr.x) && (0 <= cur_chipaddr.y)) {
				QRL::QRLChipNumber num = mapeditor->QRLMap().map(cur_chipaddr);
				if (0 <= num) {
					const QRL::QRLChip* const ptr = mapeditor->QRLMap().search(num);
					assert (NULL != ptr);

					draw_chipcursor(painter, chipaddr_ofs, ptr, &img_tmp_highlightcursor);
				}
			}
		}
		break;
	case Settings::EditorCommand::PASTE:
		draw_chipcursor_highlight(painter, chipaddr_ofs, &img_tmp_highlightcursor);
		if ((0 <= cur_chipaddr.x) && (0 <= cur_chipaddr.y)) {
			for (QRL::QRLChipNumber i = 0; i < qrlmaker->Clipboard()->maxlist(); ++i) {
				const QRL::QRLChip* const ptr = qrlmaker->Clipboard()->ptr(i);
				assert (NULL != ptr);
				if (ptr->chip_number <= 0) {
					continue;
				}

				const QRL::QRLChipLibrary* const chip = qrlmaker->QRLLibrary()->chipSearch(ptr->name);
				assert (NULL != chip);
				const struct QRL::ChipAddrXY addr = (cur_chipaddr + ptr->addr + qrlmaker->Clipboard()->ofs());
				if (!mapeditor->QRLMap().is_put(addr, chip)) {
					goto DRAWOVERLAY_PASTE_FALSE;
				}
			}
			{
				const struct QRL::ChipAddrXY ofs = (chipaddr_ofs + cur_chipaddr + qrlmaker->Clipboard()->ofs());
				for (QRL::QRLChipNumber i = 0; i < qrlmaker->Clipboard()->maxlist(); ++i) {
					const QRL::QRLChip* const ptr = qrlmaker->Clipboard()->ptr(i);
					assert (NULL != ptr);
					if (ptr->chip_number <= 0) {
						continue;
					}

					draw_chip_wo_arrow(painter, blink_color, ofs, ptr);
					draw_chipcursor(painter, ofs, ptr, &img_tmp_selectcursor);
				}
				for (QRL::QRLChipNumber i = 0; i < qrlmaker->Clipboard()->maxlist(); ++i) {
					const QRL::QRLChip* const ptr = qrlmaker->Clipboard()->ptr(i);
					assert (NULL != ptr);
					if (ptr->chip_number <= 0) {
						continue;
					}

					draw_chip_only_arrow(painter, ofs, ptr);
				}
			}
		  DRAWOVERLAY_PASTE_FALSE:
			;
		}
		break;
	case Settings::EditorCommand::DELETE:
		{
			if ((0 <= cur_chipaddr.x) && (0 <= cur_chipaddr.y)) {
				QRL::QRLChipNumber num = mapeditor->QRLMap().map(cur_chipaddr);
				if (0 <= num) {
					const QRL::QRLChip* const ptr = mapeditor->QRLMap().search(num);
					assert (NULL != ptr);

					draw_chipcursor(painter, chipaddr_ofs, ptr, &img_tmp_highlightcursor);
				}
			}
		}
		break;
	case Settings::EditorCommand::SET_ARROW_TRUE:
		{
			if ((QRL::ChipArrow_MIN < arrow) && (0 <= cur_arrowaddr.x) && (0 <= cur_arrowaddr.y)) {
				QRL::QRLChipNumber num = mapeditor->QRLMap().map(cur_arrowaddr);
				if (0 <= num) {
					const QRL::QRLChip* const ptr = mapeditor->QRLMap().search(num);
					assert (NULL != ptr);
					if (0 < ptr->next_address_condition_true) {
						const QRL::QRLChipLibrary* const chip = qrlmaker->QRLLibrary()->chipSearch(ptr->name);
						assert (NULL != chip);

						const QRL::QRLChipArrowAddress arrowaddr = mapeditor->make_arrowaddress(chip, (cur_arrowaddr - ptr->addr), arrow);

						const struct QRL::ChipAddrXY ofs = (chipaddr_ofs + ptr->addr);
						draw_chipcursor_highlight(painter, chipaddr_ofs, &img_tmp_highlightcursor);

						draw_chip_raw(painter, blink_color, ofs, chip, ptr);
						draw_arrow_raw(painter, ofs, ((0 < arrowaddr) ? arrowaddr : ptr->next_address_condition_true), true);
						draw_arrow_raw(painter, ofs, ptr->next_address_condition_false, false);
						draw_chipcursor(painter, chipaddr_ofs, ptr, &img_tmp_selectcursor);
					}
				}
			}
		}
		break;
	case Settings::EditorCommand::SET_ARROW_FALSE:
		{
			if ((QRL::ChipArrow_MIN < arrow) && (0 <= cur_arrowaddr.x) && (0 <= cur_arrowaddr.y)) {
				QRL::QRLChipNumber num = mapeditor->QRLMap().map(cur_arrowaddr);
				if (0 <= num) {
					const QRL::QRLChip* const ptr = mapeditor->QRLMap().search(num);
					assert (NULL != ptr);
					if (0 < ptr->next_address_condition_false) {
						const QRL::QRLChipLibrary* const chip = qrlmaker->QRLLibrary()->chipSearch(ptr->name);
						assert (NULL != chip);

						const QRL::QRLChipArrowAddress arrowaddr = mapeditor->make_arrowaddress(chip, (cur_arrowaddr - ptr->addr), arrow);

						const struct QRL::ChipAddrXY ofs = (chipaddr_ofs + ptr->addr);
						draw_chipcursor_highlight(painter, chipaddr_ofs, &img_tmp_highlightcursor);

						draw_chip_raw(painter, blink_color, ofs, chip, ptr);
						draw_arrow_raw(painter, ofs, ptr->next_address_condition_true, true);
						draw_arrow_raw(painter, ofs, ((0 < arrowaddr) ? arrowaddr : ptr->next_address_condition_false), false);
						draw_chipcursor(painter, chipaddr_ofs, ptr, &img_tmp_selectcursor);
					}
				}
			}
		}
		break;
	case Settings::EditorCommand::EDIT_ARGUMENT:
		break;
	case Settings::EditorCommand::PUT_CHIP:
		{
			draw_chipcursor_highlight(painter, chipaddr_ofs, &img_tmp_highlightcursor);

			if ((0 <= cur_chipaddr.x) && (0 <= cur_chipaddr.y)) {
				if (mapeditor->QRLMap().is_put(cur_chipaddr, mapeditor->SelectedLibraryChip())) {
					const struct QRL::ChipAddrXY ofs = (chipaddr_ofs + cur_chipaddr);
					draw_chip_raw(painter, blink_color, ofs, mapeditor->SelectedLibraryChip(), NULL);
					draw_chipcursor_raw(painter, ofs, mapeditor->SelectedLibraryChip(), &img_tmp_selectcursor);
				}
			}
		}
		break;
	}

	draw_cursor_raw(painter, (chipaddr_ofs + focus_addr), &img_tmp_focuscursor);

	return;
}
// [ End of File ]
