/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015
 *@date		Mon,21 Sep,2015
 *@date		Sat,03 Oct,2015 - Mon,12 Oct,2015
 *@date		Tue,13 Oct,2015 - Sun,18 Oct,2015
 *@date		Thu,22 Oct,2015 - Sun,25 Oct,2015
 *@date		Thu,29 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sun,10 Jan,2016 - Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016
 *@date		Sun,09 Jul,2017
 *@date		Sun,16 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,17 Mar,2018
 *@date		Fri,23 Nov,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018 - Sun,30 Dec,2018
 *@date		Mon,31 Dec,2018
 *@date		Sat,19 Jan,2019
 *@date		Mon,21 Jan,2019
 *@date		Fri,25 Jan,2019
 *@date		Sun,27 Jan,2019
 *@date		Tue,29 Jan,2019
 *@date		Wed,30 Jan,2019
 *@date		Tue,19 Feb,2019
 *@date		Mon,16 Nov,2020
 *@date		Thu,18 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Sat,20 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Wed,13 Jul,2022
 *@date		Sun,25 Jun,2023
 *
 *@author	Copyright(C)2015-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef IMAGEBUILDER_H
#define IMAGEBUILDER_H

#include <cstdint>
#include "settings.h"
#include "qrlmaker.h"
#include "mapeditor.h"
#include <QImage>
#include "xy_.h"

class ImageBuilder_QRLMap_Base
{
public:
	struct ScreenParameter {
		float scaling;
		XY_<int_fast16_t> gauge;
		XY_<int_fast16_t> overlapping;
		XY_<int_fast16_t> gap;
		XY_<int_fast16_t> core;
		XY_<int_fast16_t> bs;
		XY_<int_fast16_t> scs;
	};

	explicit ImageBuilder_QRLMap_Base(const QRLMaker* const q) noexcept;
	virtual ~ImageBuilder_QRLMap_Base(void) noexcept = 0;

	void setMapeditor(const MapEditor* const me) noexcept;

	void draw_image_raw(QPainter& painter, const QRL::ChipAddrXY& ofs, const QImage* const drawing_img) noexcept;
	void draw_cursor_raw(QPainter& painter, const QRL::ChipAddrXY& ofs, const QImage* const drawing_img) noexcept;
	void draw_chip_raw(QPainter& painter, const int blink_color, const QRL::ChipAddrXY& ofs, const QRL::QRLChipLibrary* const chip, const QRL::QRLChip* const ptr) noexcept;
	void draw_arrow_raw(QPainter& painter, const QRL::ChipAddrXY& ofs, QRL::QRLChipArrowAddress arrow_addr, bool arrow_mode) noexcept;
	void draw_chip_w_arrow(QPainter& painter, const int blink_color, const QRL::ChipAddrXY& ofs, const QRL::QRLChip* const ptr) noexcept;
	void draw_chip_wo_arrow(QPainter& painter, const int blink_color, const QRL::ChipAddrXY& ofs, const QRL::QRLChip* const ptr) noexcept;
	void draw_chip_only_arrow(QPainter& painter, const QRL::ChipAddrXY& ofs, const QRL::QRLChip* const ptr) noexcept;
	void draw_chipcursor_raw(QPainter& painter, const QRL::ChipAddrXY& ofs, const QRL::QRLChipLibrary* const chip, const QImage* const drawing_img) noexcept;
	void draw_chipcursor(QPainter& painter, const QRL::ChipAddrXY& ofs, const QRL::QRLChip* const ptr, const QImage* const drawing_img) noexcept;
	void draw_chipcursor_highlight(QPainter& painter, const QRL::ChipAddrXY& ofs, const QImage* const drawing_img) noexcept;

	void ResetImage(void) noexcept;
	void MakeBaseImage(const int blink_color) noexcept;

	void CalcScreenParam(void) noexcept;
	const ScreenParameter* ScreenParam(void) const noexcept;
	float scaling(void) const noexcept;
	void Set_scaling(float scale) noexcept;

protected:
	const QRLMaker* qrlmaker;

	const MapEditor* mapeditor;

	QImage* img_base;

private:
	ScreenParameter screen_param;
};

class ImageBuilder_QRLMap_OverlayImage : public virtual ImageBuilder_QRLMap_Base
{
public:
	explicit ImageBuilder_QRLMap_OverlayImage(const QRLMaker* const q) noexcept;
	virtual ~ImageBuilder_QRLMap_OverlayImage(void) noexcept = 0;

	void MakeOverlayImage(const int blink_color, enum Settings::EditorCommand::EditorCommand_TYPE edit_mode, enum MapEditor_Type::MouseMode edit_type, const XY_<int_fast32_t>& screen_size, const XY_<int_fast16_t>& screen_ofs, const struct QRL::ChipAddrXY& cur_chipaddr, const QRL::ChipArrow& arrow, const struct QRL::ChipAddrXY& cur_arrowaddr, const struct QRL::ChipAddrXY& focus_addr) noexcept;

protected:
	QImage* img_buffer;

private:
};

class ImageBuilder_QRLMap_DisplayImage : public virtual ImageBuilder_QRLMap_Base, public virtual ImageBuilder_QRLMap_OverlayImage
{
public:
	explicit ImageBuilder_QRLMap_DisplayImage(const QRLMaker* const q) noexcept;
	~ImageBuilder_QRLMap_DisplayImage(void) noexcept;

	void MakeDisplayImage(const XY_<int_fast32_t>& screen_size, const XY_<int_fast16_t>& screen_ofs) noexcept;

	const QImage* DisplayImage(void) const noexcept;

protected:
	QImage* img_display;

private:
};

class ImageBuilder_QRLMap_SaveImage : public virtual ImageBuilder_QRLMap_Base
{
public:
	explicit ImageBuilder_QRLMap_SaveImage(const QRLMaker* const q) noexcept;
	~ImageBuilder_QRLMap_SaveImage(void) noexcept;

	void MakeSaveImage(void) noexcept;

	const QImage* QRLMap_SaveImage(void) const noexcept;

protected:
	QImage* img_save;

private:
};



inline void ImageBuilder_QRLMap_Base::setMapeditor(const MapEditor* const me) noexcept
{
	mapeditor = me;
	return;
}

inline const ImageBuilder_QRLMap_Base::ScreenParameter* ImageBuilder_QRLMap_Base::ScreenParam(void) const noexcept
{
	return &screen_param;
}

inline float ImageBuilder_QRLMap_Base::scaling(void) const noexcept
{
	return screen_param.scaling;
}

inline void ImageBuilder_QRLMap_Base::Set_scaling(float scale) noexcept
{
	screen_param.scaling = scale;
	return;
}

inline const QImage* ImageBuilder_QRLMap_DisplayImage::DisplayImage(void) const noexcept
{
	return img_display;
}

inline const QImage* ImageBuilder_QRLMap_SaveImage::QRLMap_SaveImage(void) const noexcept
{
	return img_save;
}

#endif // IMAGEBUILDER_H
// [ End of File ]
