/**@file
 *
 *@brief	QRL Maker
 *@date		Tue,28 Jun,2022
 *@date		Sun,10 Jul,2022
 *@date		Mon,11 Jul,2022
 *
 *@author	Copyright(C)2022 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include <cstdint>
#include "settings.h"
#include "form_treeview.h"
#include <QStyledItemDelegate>
#include <QWidget>
#include <QPainter>
#include <QStyleOptionViewItem>
#include <QModelIndex>
#include <QSize>
#include <QString>
#include <QIcon>
#include <QStyle>
#include <QRect>
#include <QPalette>
#include <QColor>
#include <QPen>
#include <QFont>
#include <QFontMetrics>

void TreeItemDelegate::paint(QPainter* painter, const QStyleOptionViewItem& option, const QModelIndex& index) const noexcept
{
	const QString& str = index.data(Qt::DisplayRole).toString();
	const QIcon& icon = index.data(Qt::DecorationRole).value<QIcon>();
	const QSize iconSize = icon.actualSize(option.decorationSize);

	{
		painter->save();

		QStyleOptionViewItem opt = option;
		initStyleOption(&opt, index);

		const QStyle* const style = opt.widget->style();
		style->drawPrimitive(QStyle::PE_PanelItemViewItem, &opt, painter, opt.widget);

		const QRect itemRect = opt.rect;
		const int w = opt.fontMetrics.maxWidth();
		const int h = opt.fontMetrics.lineSpacing();

		const QColor general_color = opt.palette.brush(QPalette::WindowText).color();
		const QColor highlight_color = opt.palette.brush(QPalette::HighlightedText).color();
		const QColor color = (QStyle::State_Selected & opt.state) ? highlight_color : general_color;
		const QPen pen = QPen(color, 1.0, Qt::SolidLine);
		painter->setPen(pen);
		const QRect textRect((itemRect.left() + w), itemRect.top(), opt.fontMetrics.horizontalAdvance(str), h);
		painter->drawText(textRect, (Qt::AlignTop | Qt::AlignLeft), str);

		if (0 < iconSize.width()) {
			const QRect r((itemRect.left() + w), (itemRect.top() + h), iconSize.width(), iconSize.height());
			opt.icon.paint(painter, r);
		}

		painter->restore();
	}

	return;
}

QSize TreeItemDelegate::sizeHint(const QStyleOptionViewItem& option, const QModelIndex& index) const noexcept
{
	QSize size = QStyledItemDelegate::sizeHint(option, index);

	QFont fnt = option.font;
	fnt.setPointSize(fnt.pointSize() * 1.3);
	QFontMetrics fm(fnt);

	const QIcon& icon = index.data(Qt::DecorationRole).value<QIcon>();
	const QSize iconSize = icon.actualSize(option.decorationSize);

	// The width was already set by MainWindow::init_form_treeview().

	{
		const int total_h = fm.lineSpacing() + iconSize.height();
		size.setHeight(total_h);
	}

	return size;
}

TreeItemDelegate::TreeItemDelegate(QWidget* parent) noexcept :
	QStyledItemDelegate(parent)
{
	return;
}

TreeItemDelegate::~TreeItemDelegate(void) noexcept
{
	return;
}
// [ End of File ]
