/**@file
 *
 *@brief	QRL Maker
 *@date		Fri,11 Sep,2015 - Sat,12 Sep,2015
 *@date		Thu,17 Sep,2015 - Sat,19 Sep,2015
 *@date		Sun,20 Sep,2015 - Mon,21 Sep,2015
 *@date		Sat,03 Oct,2015 - Sun,04 Oct,2015
 *@date		Tue,13 Oct,2015
 *@date		Fri,16 Oct,2015 - Mon,19 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Thu,29 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sun,23 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Fri,04 Aug,2017
 *@date		Sat,05 Aug,2017
 *@date		Sat,03 Mar,2018
 *@date		Sat,17 Mar,2018
 *@date		Sat,02 Jun,2018
 *@date		Sat,21 Jul,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Sun,29 Nov,2020
 *@date		Sun,27 Dec,2020
 *@date		Fri,19 Feb,2021
 *@date		Sun,21 Feb,2021
 *@date		Mon,22 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Mon,21 Feb,2022
 *@date		Tue,28 Jun,2022
 *@date		Sun,10 Jul,2022
 *@date		Mon,11 Jul,2022
 *@date		Sun,29 Jan,2023
 *
 *@author	Copyright(C)2014-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include <cstdint>
#include "settings.h"
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "form_treeview.h"
#include <QCoreApplication>
#include <QStringList>
#include <QTranslator>
#include <QVector>
#include <iostream>
#include <fstream>
#include <QDir>
#include <QTextStream>
#include <QString>
#include <QPixmap>
#include <QPainter>
#include <QTreeWidgetItem>
#include <QListWidgetItem>
#include <QFont>
#include <QFontMetrics>

bool MainWindow::select_form_treeitem(enum Settings::EditorCommand::EditorCommand_TYPE mode_arg) noexcept
{
	QTreeWidget* const w = ui->form_treewidget;
	assert (NULL != w);

	w->scrollToItem(item_of_EditorCommand);

	uint_fast8_t i = 0;
	for (QTreeWidgetItem* item = item_of_EditorCommand; NULL != item; item = w->itemBelow(item), ++i) {
		if (mode_arg == i) {
			w->scrollToItem(item);
			w->setCurrentItem(item);
			return true;
		}
	}
	return false;
}

bool MainWindow::select_form_treeitem_prev(void) noexcept
{
	QTreeWidget* const w = ui->form_treewidget;
	assert (NULL != w);

	QList<QTreeWidgetItem *> selected_list = ui->form_treewidget->selectedItems();
	if (selected_list.length() < 1) {
		ui->form_mainform->select_form_treeitem(Settings::EditorCommand::NORMAL, NULL);
		return false;
	}

	QTreeWidgetItem* const item = selected_list[0];

	QTreeWidgetItem* const new_item = w->itemAbove(item);
	if (NULL == new_item) {
		return false;
	}

	w->scrollToItem(new_item);
	w->setCurrentItem(new_item);

	return true;
}

bool MainWindow::select_form_treeitem_next(void) noexcept
{
	QTreeWidget* const w = ui->form_treewidget;
	assert (NULL != w);

	QList<QTreeWidgetItem *> selected_list = ui->form_treewidget->selectedItems();
	if (selected_list.length() < 1) {
		ui->form_mainform->select_form_treeitem(Settings::EditorCommand::NORMAL, NULL);
		return false;
	}

	QTreeWidgetItem* const item = selected_list[0];

	QTreeWidgetItem* const new_item = w->itemBelow(item);
	if (NULL == new_item) {
		return false;
	}

	w->scrollToItem(new_item);
	w->setCurrentItem(new_item);

	return true;
}

void MainWindow::init_form_treeview(void) noexcept
{
	uint_fast8_t max_nestlevel = 0;
	int max_icon_width = 0;
	int max_msg_width = 0;
	const QFont fnt = ui->form_treewidget->font();
	const QFontMetrics fm(fnt);

	{
		QStringList list;
		list << tr("ORDERS");
		ui->form_treewidget->setHeaderLabels(list);
	}

	ui->form_treewidget->setItemDelegate(new TreeItemDelegate);

	{
		item_of_EditorCommand = new(std::nothrow) QTreeWidgetItem;
		{
			assert (NULL != item_of_EditorCommand);
			const QString tmp = QT_TRANSLATE_NOOP("Editor Command", "Editor Command");
			const QString tmp_tr = QCoreApplication::translate(Settings::QRLChipLibrary.tr_context.EditorCommand, qPrintable(tmp));
			const QString tmp_msg = "  " + tmp_tr + " ( " + tmp + " )";
			max_msg_width = qMax(max_msg_width, fm.horizontalAdvance(tmp_msg));
			item_of_EditorCommand->setText(0, tmp_msg);
			item_of_EditorCommand->setText(1, "  " + tmp);
			item_of_EditorCommand->setToolTip(0, tmp_tr);
		}
		ui->form_treewidget->addTopLevelItem(item_of_EditorCommand);
		ui->form_treewidget->expandItem(item_of_EditorCommand);

		for (uint_fast8_t i = 0; NULL != Settings::EditorCommands[i].label; ++i) {
			QTreeWidgetItem* const child = new(std::nothrow) QTreeWidgetItem;
			assert (NULL != child);
			const QString tmp = Settings::EditorCommands[i].label;
			const QString tmp_tr = QCoreApplication::translate(Settings::QRLChipLibrary.tr_context.EditorCommand, qPrintable(tmp));
			const QString tmp_msg = " " + tmp_tr + " ( " + tmp + " )";
			max_msg_width = qMax(max_msg_width, fm.horizontalAdvance(tmp_msg));
			child->setText(0, tmp_msg);
			child->setText(1, " " + tmp);
			child->setToolTip(0, tmp_tr);
			item_of_EditorCommand->addChild(child);
		}
	}

	{
		QTreeWidgetItem* top_item = new(std::nothrow) QTreeWidgetItem;
		{
			assert (NULL != top_item);
			const QString tmp = QT_TRANSLATE_NOOP("QRL Chip Library", "QRL Library");
			const QString tmp_tr = QCoreApplication::translate(Settings::QRLChipLibrary.tr_context.ChipLibrary, qPrintable(tmp));
			const QString tmp_msg = "  " + tmp_tr + " ( " + tmp + " )";
			max_msg_width = qMax(max_msg_width, fm.horizontalAdvance(tmp_msg));
			top_item->setText(0, tmp_msg);
			top_item->setText(1, "  " + tmp);
			top_item->setToolTip(0, tmp_tr);
		}
		ui->form_treewidget->addTopLevelItem(top_item);
		ui->form_treewidget->expandItem(top_item);

		{
			struct Items {
				uint_fast8_t length;
				QTreeWidgetItem* item;
			};
			Items* const items = new(std::nothrow) Items[Settings::QRLChipLibrary.LibraryFile.LuaChip_Filename_MaxNestLevel];
			assert (NULL != items);
			for (uint_fast8_t i = 0; i < Settings::QRLChipLibrary.LibraryFile.LuaChip_Filename_MaxNestLevel; ++i) {
				items[i].length = Settings::QRLChipLibrary.LibraryFile.LuaChip_Filename_Header.length();
				items[i].item = NULL;
			}
			uint_fast8_t nestlevel = 0;

			for (QVector<QRL::QRLChipLibrary_List>::const_iterator itr = qrlmaker->QRLLibrary()->libraryBegin(); itr != qrlmaker->QRLLibrary()->libraryEnd(); ++itr) {
				switch (itr->type) {
				case QRL::QRLChipLibrary_List::NONE:
					items[nestlevel].item = new(std::nothrow) QTreeWidgetItem;
					assert (NULL != items[nestlevel].item);
					items[nestlevel].item->setText(0, "  ???");
					items[nestlevel].item->setText(1, "  ???");
					items[nestlevel].item->setToolTip(0, "???");
					top_item->addChild(items[nestlevel].item);
					ui->form_treewidget->collapseItem(items[nestlevel].item);
					break;

				case QRL::QRLChipLibrary_List::LABEL:
					{
						const uint_fast8_t len = itr->data.label.basename->length();
						if (len < items[nestlevel].length) {
							const uint_fast8_t lv_distance = (items[nestlevel].length - len);
							const uint_fast8_t lv_diff = (nestlevel < lv_distance) ? nestlevel : lv_distance;
							nestlevel -= lv_diff;
						} else if ((0 == items[nestlevel].length) || (len == items[nestlevel].length)) {
						} else {
							const uint_fast8_t limit = (Settings::QRLChipLibrary.LibraryFile.LuaChip_Filename_MaxNestLevel - 1);
							const uint_fast8_t lv_distance = (len - items[nestlevel].length);
							const uint_fast8_t lv_diff = ((nestlevel + lv_distance) < limit) ? lv_distance : (limit - nestlevel);
							for (uint_fast8_t i = 1; i < lv_diff; ++i) {
								items[nestlevel + i].length = items[nestlevel].length;
								items[nestlevel + i].item = items[nestlevel].item;
							}
							nestlevel += lv_diff;
						}
						max_nestlevel = qMax(max_nestlevel, nestlevel);
					}
					items[nestlevel].length = itr->data.label.basename->length();
					items[nestlevel].item = new(std::nothrow) QTreeWidgetItem;
					assert (NULL != items[nestlevel].item);
					if (NULL != itr->data.label.label) {
						const QString tmp = *(itr->data.label.label);
						const QString tmp_tr = QCoreApplication::translate(Settings::QRLChipLibrary.tr_context.ChipLabel, qPrintable(tmp), Settings::QRLChipLibrary.tr_disambiguation.Label);
						const QString tmp_msg = "  " + tmp_tr + " ( " + tmp + " )";
						max_msg_width = qMax(max_msg_width, fm.horizontalAdvance(tmp_msg));
						items[nestlevel].item->setText(0, tmp_msg);
						items[nestlevel].item->setText(1, "  " + tmp);
						items[nestlevel].item->setToolTip(0, tmp_tr);
					}
					if ((nestlevel < 1) || (NULL == items[nestlevel-1].item)) {
						top_item->addChild(items[nestlevel].item);
					} else {
						items[nestlevel-1].item->addChild(items[nestlevel].item);
					}
					ui->form_treewidget->collapseItem(items[nestlevel].item);
					break;

				case QRL::QRLChipLibrary_List::CHIP:
					assert (NULL != items[nestlevel].item);
					QTreeWidgetItem* const child = new(std::nothrow) QTreeWidgetItem;
					assert (NULL != child);
					if (NULL != itr->data.chip.name) {
						const QString tmp = *(itr->data.chip.name);
						const QString tmp_tr = QCoreApplication::translate(Settings::QRLChipLibrary.tr_context.ChipLibrary, qPrintable(tmp), Settings::QRLChipLibrary.tr_disambiguation.Chip);
						const QString tmp_msg = tmp_tr + " ( " + tmp + " )";
						max_msg_width = qMax(max_msg_width, fm.horizontalAdvance(tmp_msg));
						child->setText(0, tmp_msg);
						child->setText(1, tmp);
						child->setToolTip(0, tmp_tr);
					}
					if (NULL != itr->data.chip.image) {
						const uint_fast16_t cw = itr->data.chip.size.x * (Settings::BuildImage.Chip.GapSize + Settings::BuildImage.Chip.CoreSize) - Settings::BuildImage.Chip.GapSize + 1;
						const uint_fast16_t ch = itr->data.chip.size.y * (Settings::BuildImage.Chip.GapSize + Settings::BuildImage.Chip.CoreSize) - Settings::BuildImage.Chip.GapSize + 1;
						QPixmap pixmap((cw + 2), (ch + 2));
						pixmap.fill(Qt::transparent);
						{
							QPainter imagePainter(&pixmap);
							const QImage img_tmp = itr->data.chip.image->scaled(cw, ch, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
							imagePainter.drawImage(1, 1, img_tmp);
						}
						child->setIcon(0, pixmap);
					}
					items[nestlevel].item->addChild(child);
					break;
				}
			}

			delete[] items;

			{
				const uint_fast16_t cw = Settings::QRLChipLibrary.Icon_size.width()  * (Settings::BuildImage.Chip.GapSize + Settings::BuildImage.Chip.CoreSize) + Settings::BuildImage.Chip.GapSize + 1;
				const uint_fast16_t ch = Settings::QRLChipLibrary.Icon_size.height() * (Settings::BuildImage.Chip.GapSize + Settings::BuildImage.Chip.CoreSize) + Settings::BuildImage.Chip.GapSize + 1;
				max_icon_width = qMax(max_icon_width, static_cast<int>(cw));
				ui->form_treewidget->setIconSize(QSize(cw,ch));
			}
		}
	}

	{
		const int fm_w = fm.maxWidth();
		const int column_width = 20 * max_nestlevel + qMax(max_icon_width, max_msg_width) + (2 * fm_w);
		ui->form_treewidget->resizeColumnToContents(0);
		ui->form_treewidget->setColumnWidth(0, column_width);
		ui->form_treewidget->header()->setStretchLastSection(false);
	}

	select_form_treeitem(Settings::EditorCommand::NORMAL);
	return;
}
// [ End of File ]
